/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.providers.walrus;

import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.objectstorage.exceptions.s3.BadDigestException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketAlreadyExistsException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketAlreadyOwnedByYouException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketNotEmptyException;
import com.eucalyptus.objectstorage.exceptions.s3.EntityTooLargeException;
import com.eucalyptus.objectstorage.exceptions.s3.InlineDataTooLargeException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidTargetBucketForLoggingException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchKeyException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.exceptions.s3.ServiceUnavailableException;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageResponseType;
import com.eucalyptus.objectstorage.providers.walrus.MessageProxy;
import com.eucalyptus.objectstorage.providers.walrus.WalrusExceptionProxy;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.exceptions.ContentMismatchException;
import com.eucalyptus.walrus.exceptions.DecryptionFailedException;
import com.eucalyptus.walrus.exceptions.HeadAccessDeniedException;
import com.eucalyptus.walrus.exceptions.HeadNoSuchBucketException;
import com.eucalyptus.walrus.exceptions.HeadNoSuchEntityException;
import com.eucalyptus.walrus.exceptions.InternalErrorException;
import com.eucalyptus.walrus.exceptions.InvalidArgumentException;
import com.eucalyptus.walrus.exceptions.InvalidBucketNameException;
import com.eucalyptus.walrus.exceptions.NoSuchBucketException;
import com.eucalyptus.walrus.exceptions.NoSuchEntityException;
import com.eucalyptus.walrus.exceptions.NotAuthorizedException;
import com.eucalyptus.walrus.exceptions.NotImplementedException;
import com.eucalyptus.walrus.exceptions.NotReadyException;
import com.eucalyptus.walrus.exceptions.PreconditionFailedException;
import com.eucalyptus.walrus.exceptions.TooManyBucketsException;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.WalrusDataRequestType;
import com.eucalyptus.walrus.msgs.WalrusDataResponseType;
import com.eucalyptus.walrus.msgs.WalrusRequestType;
import com.eucalyptus.walrus.msgs.WalrusResponseType;
import java.util.HashMap;
import org.apache.log4j.Logger;

public enum MessageMapper {
    INSTANCE;

    private static final Logger LOG;
    private static HashMap<Class<? extends WalrusException>, Class<? extends S3Exception>> exceptionMap;

    public <O extends WalrusDataRequestType, I extends ObjectStorageDataRequestType> O proxyWalrusDataRequest(Class<O> outputClass, I request) {
        WalrusDataRequestType outputRequest = (WalrusDataRequestType)Classes.newInstance(outputClass, (Object[])new Object[0]);
        outputRequest = MessageProxy.mapExcludeNulls(request, outputRequest);
        outputRequest.regardingUserRequest(request);
        return (O)outputRequest;
    }

    public <O extends WalrusRequestType, I extends ObjectStorageRequestType> O proxyWalrusRequest(Class<O> outputClass, I request) {
        WalrusRequestType outputRequest = (WalrusRequestType)Classes.newInstance(outputClass, (Object[])new Object[0]);
        outputRequest = MessageProxy.mapExcludeNulls(request, outputRequest);
        outputRequest.regardingUserRequest(request);
        return (O)outputRequest;
    }

    public <O extends ObjectStorageDataResponseType, T extends ObjectStorageDataRequestType, I extends WalrusDataResponseType> O proxyWalrusDataResponse(T initialRequest, I response) {
        ObjectStorageDataResponseType outputResponse = (ObjectStorageDataResponseType)initialRequest.getReply();
        outputResponse = MessageProxy.mapExcludeNulls(response, outputResponse);
        return (O)outputResponse;
    }

    public <O extends ObjectStorageResponseType, T extends ObjectStorageRequestType, I extends WalrusResponseType> O proxyWalrusResponse(T initialRequest, I response) {
        ObjectStorageResponseType outputResponse = (ObjectStorageResponseType)initialRequest.getReply();
        outputResponse = MessageProxy.mapExcludeNulls(response, outputResponse);
        return (O)outputResponse;
    }

    public <O extends S3Exception, T extends WalrusException> O proxyWalrusException(T initialException) throws EucalyptusCloudException {
        try {
            Class<? extends S3Exception> c = exceptionMap.get(initialException.getClass());
            if (c == null) {
                LOG.warn((Object)("an attempt to proxy a walrus exception failed because there is no mapping for " + initialException.getClass().getName()));
                WalrusException proxied = new WalrusException("no mapping for " + initialException.getClass().getName(), initialException);
                return this.proxyWalrusException(proxied);
            }
            S3Exception outputException = c.newInstance();
            outputException = WalrusExceptionProxy.mapExcludeNulls(initialException, outputException);
            return (O)((Object)outputException);
        }
        catch (Exception e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    static {
        LOG = Logger.getLogger(MessageMapper.class);
        exceptionMap = new HashMap();
        exceptionMap.put(com.eucalyptus.walrus.exceptions.AccessDeniedException.class, AccessDeniedException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.BucketAlreadyExistsException.class, BucketAlreadyExistsException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.BucketAlreadyOwnedByYouException.class, BucketAlreadyOwnedByYouException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.BucketNotEmptyException.class, BucketNotEmptyException.class);
        exceptionMap.put(ContentMismatchException.class, BadDigestException.class);
        exceptionMap.put(DecryptionFailedException.class, com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.EntityTooLargeException.class, EntityTooLargeException.class);
        exceptionMap.put(HeadAccessDeniedException.class, AccessDeniedException.class);
        exceptionMap.put(HeadNoSuchBucketException.class, com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException.class);
        exceptionMap.put(HeadNoSuchEntityException.class, NoSuchKeyException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.InlineDataTooLargeException.class, InlineDataTooLargeException.class);
        exceptionMap.put(InvalidArgumentException.class, com.eucalyptus.objectstorage.exceptions.s3.InvalidArgumentException.class);
        exceptionMap.put(InvalidBucketNameException.class, com.eucalyptus.objectstorage.exceptions.s3.InvalidBucketNameException.class);
        exceptionMap.put(InternalErrorException.class, com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException.class);
        exceptionMap.put(com.eucalyptus.walrus.exceptions.InvalidTargetBucketForLoggingException.class, InvalidTargetBucketForLoggingException.class);
        exceptionMap.put(NoSuchBucketException.class, com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException.class);
        exceptionMap.put(NoSuchEntityException.class, NoSuchKeyException.class);
        exceptionMap.put(NotAuthorizedException.class, AccessDeniedException.class);
        exceptionMap.put(NotImplementedException.class, com.eucalyptus.objectstorage.exceptions.s3.NotImplementedException.class);
        exceptionMap.put(NotReadyException.class, ServiceUnavailableException.class);
        exceptionMap.put(PreconditionFailedException.class, com.eucalyptus.objectstorage.exceptions.s3.PreconditionFailedException.class);
        exceptionMap.put(TooManyBucketsException.class, com.eucalyptus.objectstorage.exceptions.s3.TooManyBucketsException.class);
        exceptionMap.put(WalrusException.class, com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException.class);
    }
}

