/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.providers.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.objectstorage.client.OsgInternalS3Client;
import com.eucalyptus.objectstorage.entities.S3ProviderConfiguration;
import com.eucalyptus.objectstorage.exceptions.S3ExceptionMapper;
import com.eucalyptus.objectstorage.exceptions.s3.AccountProblemException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.NotImplementedException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CopyObjectResponseType;
import com.eucalyptus.objectstorage.msgs.CopyObjectType;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectType;
import com.eucalyptus.objectstorage.msgs.DeleteVersionResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteVersionType;
import com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.GetBucketLocationResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLocationType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.GetObjectExtendedResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectExtendedType;
import com.eucalyptus.objectstorage.msgs.GetObjectResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectType;
import com.eucalyptus.objectstorage.msgs.HeadBucketResponseType;
import com.eucalyptus.objectstorage.msgs.HeadBucketType;
import com.eucalyptus.objectstorage.msgs.HeadObjectResponseType;
import com.eucalyptus.objectstorage.msgs.HeadObjectType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsType;
import com.eucalyptus.objectstorage.msgs.ListBucketResponseType;
import com.eucalyptus.objectstorage.msgs.ListBucketType;
import com.eucalyptus.objectstorage.msgs.ListMultipartUploadsResponseType;
import com.eucalyptus.objectstorage.msgs.ListMultipartUploadsType;
import com.eucalyptus.objectstorage.msgs.ListPartsResponseType;
import com.eucalyptus.objectstorage.msgs.ListPartsType;
import com.eucalyptus.objectstorage.msgs.ListVersionsResponseType;
import com.eucalyptus.objectstorage.msgs.ListVersionsType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.msgs.PostObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PostObjectType;
import com.eucalyptus.objectstorage.msgs.PutObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PutObjectType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.UploadPartResponseType;
import com.eucalyptus.objectstorage.msgs.UploadPartType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviderClient;
import com.eucalyptus.objectstorage.util.AclUtils;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.config.ConfigurationCache;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.BucketListEntry;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.CommonPrefixesEntry;
import com.eucalyptus.storage.msgs.s3.DeleteMarkerEntry;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.storage.msgs.s3.Initiator;
import com.eucalyptus.storage.msgs.s3.ListAllMyBucketsList;
import com.eucalyptus.storage.msgs.s3.ListEntry;
import com.eucalyptus.storage.msgs.s3.LoggingEnabled;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.storage.msgs.s3.Part;
import com.eucalyptus.storage.msgs.s3.Upload;
import com.eucalyptus.storage.msgs.s3.VersionEntry;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class S3ProviderClient
implements ObjectStorageProviderClient {
    private static final Logger LOG = Logger.getLogger(S3ProviderClient.class);
    private volatile URI upstreamEndpoint;
    private volatile OsgInternalS3Client backendClient;
    private static final List<String> copyableHeaders = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"Cache-Control", "Content-Disposition", "Content-Encoding", "Expires"}));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OsgInternalS3Client getS3Client(User requestUser) throws InternalErrorException {
        BasicAWSCredentials credentials;
        S3ProviderConfiguration providerConfig = (S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class);
        try {
            credentials = this.mapCredentials(requestUser);
        }
        catch (Exception e) {
            LOG.error((Object)("Error mapping credentials for user " + (requestUser != null ? requestUser.getUserId() : "null") + " for walrus backend call."), (Throwable)e);
            throw new InternalErrorException("Cannot construct s3client due to inability to map credentials for user: " + (requestUser != null ? requestUser.getUserId() : "null"), (Throwable)e);
        }
        if (this.backendClient == null) {
            S3ProviderClient e = this;
            synchronized (e) {
                if (this.backendClient == null) {
                    try {
                        this.backendClient = new OsgInternalS3Client((AWSCredentials)credentials, this.getUpstreamEndpoint().toASCIIString(), providerConfig.getS3UseHttps().booleanValue(), providerConfig.getS3UseBackendDns());
                        return this.backendClient;
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"exception thrown retrieving internal s3 client", (Throwable)e2);
                        throw new InternalErrorException("Cannot get s3client from pool", (Throwable)e2);
                    }
                }
            }
        }
        try {
            this.backendClient.update((AWSCredentials)credentials, this.getUpstreamEndpoint().toASCIIString(), providerConfig.getS3UseHttps(), Boolean.valueOf(providerConfig.getS3UseBackendDns()));
            return this.backendClient;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI getUpstreamEndpoint() throws URISyntaxException {
        String raw = ((S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class)).getS3Endpoint();
        if (this.upstreamEndpoint == null || !this.upstreamEndpoint.getHost().equals(this.getUpstreamEndpointHost(raw)) || this.upstreamEndpoint.getPort() != this.getUpstreamEndpointPort(raw)) {
            S3ProviderClient s3ProviderClient = this;
            synchronized (s3ProviderClient) {
                this.upstreamEndpoint = this.convertToFullURI(raw);
            }
        }
        return this.upstreamEndpoint;
    }

    protected URI convertToFullURI(@Nonnull String raw) {
        URI tmp;
        if (!raw.startsWith("http://") && !raw.startsWith("https://")) {
            raw = "http://" + raw;
        }
        if ((tmp = URI.create(raw)).getPort() != -1) {
            return tmp;
        }
        return URI.create(raw + ":80");
    }

    protected String getUpstreamEndpointHost(@Nonnull String raw) {
        String[] s3EndpointParts = raw.split(":");
        if (s3EndpointParts.length > 0) {
            return s3EndpointParts[0];
        }
        return null;
    }

    protected int getUpstreamEndpointPort(@Nonnull String raw) {
        String[] s3EndpointParts = raw.split(":");
        if (s3EndpointParts.length > 1) {
            try {
                return Integer.parseInt(s3EndpointParts[1]);
            }
            catch (NumberFormatException e) {
                return 80;
            }
        }
        return 80;
    }

    protected boolean doUsePathStyle() {
        return !((S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class)).getS3UseBackendDns();
    }

    protected static AccessControlPolicy sdkAclToEucaAcl(AccessControlList s3Acl) {
        if (s3Acl == null) {
            return null;
        }
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setOwner(new CanonicalUser(acp.getOwner().getID(), acp.getOwner().getDisplayName()));
        if (acp.getAccessControlList() == null) {
            acp.setAccessControlList(new com.eucalyptus.storage.msgs.s3.AccessControlList());
        }
        Grantee grantee = null;
        for (Grant g : s3Acl.getGrants()) {
            grantee = new Grantee();
            if (g.getGrantee() instanceof CanonicalGrantee) {
                grantee.setCanonicalUser(new CanonicalUser(g.getGrantee().getIdentifier(), ((CanonicalGrantee)g.getGrantee()).getDisplayName()));
            } else if (g.getGrantee() instanceof GroupGrantee) {
                grantee.setGroup(new Group(g.getGrantee().getIdentifier()));
            } else if (g.getGrantee() instanceof EmailAddressGrantee) {
                grantee.setEmailAddress(g.getGrantee().getIdentifier());
            }
            acp.getAccessControlList().getGrants().add(new com.eucalyptus.storage.msgs.s3.Grant(grantee, g.getPermission().toString()));
        }
        return acp;
    }

    protected BasicAWSCredentials mapCredentials(User requestUser) throws Exception {
        return new BasicAWSCredentials(((S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class)).getS3AccessKey(), ((S3ProviderConfiguration)ConfigurationCache.getConfiguration(S3ProviderConfiguration.class)).getS3SecretKey());
    }

    protected ObjectMetadata getS3ObjectMetadata(PutObjectType request) {
        Map headersToCopy;
        ObjectMetadata meta = new ObjectMetadata();
        if (request.getMetaData() != null) {
            for (MetaDataEntry m : request.getMetaData()) {
                meta.addUserMetadata(m.getName(), m.getValue());
            }
        }
        if (!Strings.isNullOrEmpty((String)request.getContentLength())) {
            meta.setContentLength(Long.parseLong(request.getContentLength()));
        }
        if (!Strings.isNullOrEmpty((String)request.getContentMD5())) {
            meta.setContentMD5(request.getContentMD5());
        }
        if (!Strings.isNullOrEmpty((String)request.getContentType())) {
            meta.setContentType(request.getContentType());
        }
        if ((headersToCopy = request.getCopiedHeaders()) != null && headersToCopy.size() > 0) {
            for (String header : copyableHeaders) {
                Date expireDate;
                if (!headersToCopy.containsKey(header)) continue;
                String v = (String)headersToCopy.get(header);
                if ("Cache-Control".equals(header)) {
                    meta.setCacheControl(v);
                }
                if ("Content-Disposition".equals(header)) {
                    meta.setContentDisposition(v);
                }
                if ("Content-Encoding".equals(header)) {
                    meta.setContentEncoding(v);
                }
                if (!"Expires".equals(header) || (expireDate = DateFormatter.dateFromHeaderFormattedString((String)v)) == null) continue;
                meta.setHttpExpiresDate(expireDate);
            }
        }
        return meta;
    }

    public void initialize() throws EucalyptusCloudException {
        LOG.debug((Object)"Initializing");
        ConfigurationCache.getConfiguration(S3ProviderConfiguration.class);
        this.check();
        LOG.debug((Object)"Initialization completed successfully");
    }

    public void check() throws EucalyptusCloudException {
        LOG.debug((Object)"Checking");
        Socket s = null;
        try {
            URI endpoint = this.getUpstreamEndpoint();
            s = new Socket(endpoint.getHost(), endpoint.getPort());
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new EucalyptusCloudException("Host Exception. Unable to connect to S3 Endpoint Please check configuration and network connection");
        }
        catch (IOException e) {
            throw new EucalyptusCloudException("Unable to connect to S3 Endpoint. Please check configuration and network connection");
        }
        finally {
            try {
                if (s != null && !s.isClosed()) {
                    s.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed closing socked used to check remote S3 endpoint", (Throwable)e);
            }
        }
        LOG.debug((Object)"Check completed successfully");
    }

    public void checkPreconditions() throws EucalyptusCloudException {
        LOG.debug((Object)"Checking preconditions");
        LOG.debug((Object)"Check preconditions completed successfully");
    }

    public void start() throws EucalyptusCloudException {
        LOG.debug((Object)"Starting");
        LOG.debug((Object)"Start completed successfully");
    }

    public void stop() throws EucalyptusCloudException {
        LOG.debug((Object)"Stopping");
        LOG.debug((Object)"Stop completed successfully");
    }

    public void enable() throws EucalyptusCloudException {
        LOG.debug((Object)"Enabling");
        LOG.debug((Object)"Enable completed successfully");
    }

    public void disable() throws EucalyptusCloudException {
        LOG.debug((Object)"Disabling");
        LOG.debug((Object)"Disable completed successfully");
    }

    protected CanonicalUser getCanonicalUser(User usr) {
        try {
            return new CanonicalUser(usr.getAccount().getCanonicalId(), usr.getAccount().getName());
        }
        catch (AuthException e) {
            LOG.debug((Object)("Exception getting the canonicalId and display name for the user: " + usr.getName()), (Throwable)e);
            return new CanonicalUser();
        }
    }

    public ListAllMyBucketsResponseType listAllMyBuckets(ListAllMyBucketsType request) throws S3Exception {
        ListAllMyBucketsResponseType reply = (ListAllMyBucketsResponseType)request.getReply();
        OsgInternalS3Client internalS3Client = null;
        User requestUser = null;
        try {
            requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
            ListAllMyBucketsList myBucketList = new ListAllMyBucketsList();
            myBucketList.setBuckets(new ArrayList());
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            ListBucketsRequest listRequest = new ListBucketsRequest();
            List result = s3Client.listBuckets(listRequest);
            for (Bucket b : result) {
                myBucketList.getBuckets().add(new BucketListEntry(b.getName(), DateFormatter.dateToHeaderFormattedString((Date)b.getCreationDate())));
            }
            reply.setBucketList(myBucketList);
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    public HeadBucketResponseType headBucket(HeadBucketType request) throws S3Exception {
        HeadBucketResponseType reply = (HeadBucketResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            AccessControlList responseList = s3Client.getBucketAcl(request.getBucket());
            reply.setBucket(request.getBucket());
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    public CreateBucketResponseType createBucket(CreateBucketType request) throws S3Exception {
        CreateBucketResponseType reply = (CreateBucketResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            Bucket responseBucket = s3Client.createBucket(request.getBucket());
            reply.setBucket(request.getBucket());
            reply.setStatus(HttpResponseStatus.OK);
            reply.setStatusMessage("OK");
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    public DeleteBucketResponseType deleteBucket(DeleteBucketType request) throws S3Exception {
        DeleteBucketResponseType reply = (DeleteBucketResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            s3Client.deleteBucket(request.getBucket());
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    private static User getRequestUser(ObjectStorageRequestType request) {
        return request.getUser();
    }

    public GetBucketAccessControlPolicyResponseType getBucketAccessControlPolicy(GetBucketAccessControlPolicyType request) throws S3Exception {
        GetBucketAccessControlPolicyResponseType reply = (GetBucketAccessControlPolicyResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            AccessControlList acl = s3Client.getBucketAcl(request.getBucket());
            reply.setAccessControlPolicy(S3ProviderClient.sdkAclToEucaAcl(acl));
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    public PutObjectResponseType putObject(PutObjectType request, InputStream inputData) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            ObjectMetadata metadata = this.getS3ObjectMetadata(request);
            PutObjectRequest putRequest = new PutObjectRequest(request.getBucket(), request.getKey(), inputData, metadata).withCannedAcl(CannedAccessControlList.Private);
            PutObjectResult result = s3Client.putObject(putRequest);
            PutObjectResponseType reply = (PutObjectResponseType)request.getReply();
            if (result == null) {
                throw new InternalErrorException("Null result from backend");
            }
            reply.setEtag(result.getETag());
            reply.setVersionId(result.getVersionId());
            reply.setLastModified(new Date());
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public PostObjectResponseType postObject(PostObjectType request) throws S3Exception {
        throw new NotImplementedException("PostObject");
    }

    public DeleteObjectResponseType deleteObject(DeleteObjectType request) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            DeleteObjectResponseType reply = (DeleteObjectResponseType)request.getReply();
            reply.setStatus(HttpResponseStatus.NO_CONTENT);
            reply.setStatusMessage("NO CONTENT");
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            s3Client.deleteObject(request.getBucket(), request.getKey());
            return reply;
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)"Error from backend", (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
    }

    public ListBucketResponseType listBucket(ListBucketType request) throws S3Exception {
        ListBucketResponseType reply = (ListBucketResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            ListObjectsRequest listRequest = new ListObjectsRequest();
            listRequest.setBucketName(request.getBucket());
            listRequest.setDelimiter(Strings.isNullOrEmpty((String)request.getDelimiter()) ? null : request.getDelimiter());
            listRequest.setMarker(Strings.isNullOrEmpty((String)request.getMarker()) ? null : request.getMarker());
            listRequest.setMaxKeys(request.getMaxKeys() == null ? null : Integer.valueOf(Integer.parseInt(request.getMaxKeys())));
            listRequest.setPrefix(Strings.isNullOrEmpty((String)request.getPrefix()) ? null : request.getPrefix());
            ObjectListing response = s3Client.listObjects(listRequest);
            reply.setName(request.getBucket());
            reply.setMaxKeys(response.getMaxKeys());
            reply.setMarker(response.getMarker() == null ? "" : response.getMarker());
            reply.setPrefix(response.getPrefix() == null ? "" : response.getPrefix());
            reply.setIsTruncated(response.isTruncated());
            reply.setNextMarker(response.getNextMarker());
            reply.setDelimiter(response.getDelimiter());
            if (reply.getContents() == null) {
                reply.setContents(new ArrayList());
            }
            if (reply.getCommonPrefixesList() == null) {
                reply.setCommonPrefixesList(new ArrayList());
            }
            for (S3ObjectSummary obj : response.getObjectSummaries()) {
                reply.getContents().add(new ListEntry(obj.getKey(), DateFormatter.dateToHeaderFormattedString((Date)obj.getLastModified()), obj.getETag(), obj.getSize(), this.getCanonicalUser(requestUser), obj.getStorageClass()));
            }
            if (response.getCommonPrefixes() != null && response.getCommonPrefixes().size() > 0) {
                reply.setCommonPrefixesList(new ArrayList());
                for (String s : response.getCommonPrefixes()) {
                    reply.getCommonPrefixesList().add(new CommonPrefixesEntry(s));
                }
            }
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public GetObjectAccessControlPolicyResponseType getObjectAccessControlPolicy(GetObjectAccessControlPolicyType request) throws S3Exception {
        GetObjectAccessControlPolicyResponseType reply = (GetObjectAccessControlPolicyResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            AccessControlList acl = s3Client.getObjectAcl(request.getBucket(), request.getKey(), request.getVersionId());
            reply.setAccessControlPolicy(S3ProviderClient.sdkAclToEucaAcl(acl));
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public SetBucketAccessControlPolicyResponseType setBucketAccessControlPolicy(SetBucketAccessControlPolicyType request) throws S3Exception {
        throw new NotImplementedException("?acl");
    }

    public SetObjectAccessControlPolicyResponseType setObjectAccessControlPolicy(SetObjectAccessControlPolicyType request) throws S3Exception {
        throw new NotImplementedException("?acl");
    }

    protected void populateResponseMetadata(ObjectStorageDataResponseType reply, ObjectMetadata metadata) {
        reply.setSize(Long.valueOf(metadata.getContentLength()));
        reply.setContentDisposition(metadata.getContentDisposition());
        reply.setContentType(metadata.getContentType());
        reply.setCacheControl(metadata.getCacheControl());
        reply.setContentEncoding(metadata.getContentEncoding());
        Date expires = metadata.getHttpExpiresDate();
        reply.setExpires(DateFormatter.dateToHeaderFormattedString((Date)expires));
        reply.setEtag(metadata.getETag());
        reply.setLastModified(metadata.getLastModified());
        if (metadata.getUserMetadata() != null && metadata.getUserMetadata().size() > 0) {
            if (reply.getMetaData() == null) {
                reply.setMetaData(new ArrayList());
            }
            for (String k : metadata.getUserMetadata().keySet()) {
                reply.getMetaData().add(new MetaDataEntry(k, (String)metadata.getUserMetadata().get(k)));
            }
        }
    }

    public GetObjectResponseType getObject(GetObjectType request) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        GetObjectRequest getRequest = new GetObjectRequest(request.getBucket(), request.getKey());
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            GetObjectResponseType reply = (GetObjectResponseType)request.getReply();
            S3Object response = s3Client.getObject(getRequest);
            this.populateResponseMetadata((ObjectStorageDataResponseType)reply, response.getObjectMetadata());
            reply.setDataInputStream((InputStream)response.getObjectContent());
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public GetObjectExtendedResponseType getObjectExtended(GetObjectExtendedType request) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        Boolean getMetaData = request.getGetMetaData();
        Long byteRangeStart = request.getByteRangeStart();
        Long byteRangeEnd = request.getByteRangeEnd();
        Date ifModifiedSince = request.getIfModifiedSince();
        Date ifUnmodifiedSince = request.getIfUnmodifiedSince();
        String ifMatch = request.getIfMatch();
        String ifNoneMatch = request.getIfNoneMatch();
        GetObjectRequest getRequest = new GetObjectRequest(request.getBucket(), request.getKey());
        if (byteRangeStart != null && byteRangeEnd != null) {
            getRequest.setRange(byteRangeStart.longValue(), byteRangeEnd.longValue());
        }
        if (getMetaData != null) {
            // empty if block
        }
        if (ifModifiedSince != null) {
            getRequest.setModifiedSinceConstraint(ifModifiedSince);
        }
        if (ifUnmodifiedSince != null) {
            getRequest.setUnmodifiedSinceConstraint(ifUnmodifiedSince);
        }
        if (ifMatch != null) {
            ArrayList<String> matchList = new ArrayList<String>();
            matchList.add(ifMatch);
            getRequest.setMatchingETagConstraints(matchList);
        }
        if (ifNoneMatch != null) {
            ArrayList<String> nonMatchList = new ArrayList<String>();
            nonMatchList.add(ifNoneMatch);
            getRequest.setNonmatchingETagConstraints(nonMatchList);
        }
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            S3Object response = s3Client.getObject(getRequest);
            GetObjectExtendedResponseType reply = (GetObjectExtendedResponseType)request.getReply();
            this.populateResponseMetadata((ObjectStorageDataResponseType)reply, response.getObjectMetadata());
            reply.setDataInputStream((InputStream)response.getObjectContent());
            reply.setByteRangeStart(request.getByteRangeStart());
            reply.setByteRangeEnd(request.getByteRangeEnd());
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public GetBucketLocationResponseType getBucketLocation(GetBucketLocationType request) throws S3Exception {
        GetBucketLocationResponseType reply = (GetBucketLocationResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            String bucketLocation = s3Client.getBucketLocation(request.getBucket());
            reply.setLocationConstraint(bucketLocation);
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public CopyObjectResponseType copyObject(CopyObjectType request) throws S3Exception {
        CopyObjectResponseType reply = (CopyObjectResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String sourceBucket = request.getSourceBucket();
        String sourceKey = request.getSourceObject();
        String sourceVersionId = request.getSourceVersionId();
        String destinationBucket = request.getDestinationBucket();
        String destinationKey = request.getDestinationObject();
        String copyIfMatch = request.getCopySourceIfMatch();
        String copyIfNoneMatch = request.getCopySourceIfNoneMatch();
        Date copyIfUnmodifiedSince = request.getCopySourceIfUnmodifiedSince();
        Date copyIfModifiedSince = request.getCopySourceIfModifiedSince();
        try {
            CopyObjectRequest copyRequest = new CopyObjectRequest(sourceBucket, sourceKey, sourceVersionId, destinationBucket, destinationKey);
            copyRequest.setModifiedSinceConstraint(copyIfModifiedSince);
            copyRequest.setUnmodifiedSinceConstraint(copyIfUnmodifiedSince);
            if (copyIfMatch != null) {
                ArrayList<String> copyIfMatchConstraint = new ArrayList<String>();
                copyIfMatchConstraint.add(copyIfMatch);
                copyRequest.setMatchingETagConstraints(copyIfMatchConstraint);
            }
            if (copyIfNoneMatch != null) {
                ArrayList<String> copyIfNoneMatchConstraint = new ArrayList<String>();
                copyIfNoneMatchConstraint.add(copyIfNoneMatch);
                copyRequest.setNonmatchingETagConstraints(copyIfNoneMatchConstraint);
            }
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            CopyObjectResult result = s3Client.copyObject(copyRequest);
            reply.setEtag(result.getETag());
            reply.setLastModified(DateFormatter.dateToListingFormattedString((Date)result.getLastModifiedDate()));
            String destinationVersionId = result.getVersionId();
            if (destinationVersionId != null) {
                reply.setCopySourceVersionId(sourceVersionId);
                reply.setVersionId(destinationVersionId);
            }
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public SetBucketLoggingStatusResponseType setBucketLoggingStatus(SetBucketLoggingStatusType request) throws S3Exception {
        SetBucketLoggingStatusResponseType reply = (SetBucketLoggingStatusResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            BucketLoggingConfiguration config = new BucketLoggingConfiguration();
            LoggingEnabled requestConfig = request.getLoggingEnabled();
            config.setDestinationBucketName(requestConfig == null ? null : requestConfig.getTargetBucket());
            config.setLogFilePrefix(requestConfig == null ? null : requestConfig.getTargetPrefix());
            SetBucketLoggingConfigurationRequest loggingRequest = new SetBucketLoggingConfigurationRequest(request.getBucket(), config);
            s3Client.setBucketLoggingConfiguration(loggingRequest);
            reply.setStatus(HttpResponseStatus.OK);
            reply.setStatusMessage("OK");
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public GetBucketLoggingStatusResponseType getBucketLoggingStatus(GetBucketLoggingStatusType request) throws S3Exception {
        GetBucketLoggingStatusResponseType reply = (GetBucketLoggingStatusResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            BucketLoggingConfiguration loggingConfig = s3Client.getBucketLoggingConfiguration(request.getBucket());
            LoggingEnabled loggingEnabled = new LoggingEnabled();
            if (loggingConfig != null && loggingConfig.isLoggingEnabled()) {
                loggingEnabled.setTargetBucket(loggingConfig.getDestinationBucketName());
                loggingEnabled.setTargetPrefix(loggingConfig.getLogFilePrefix());
            }
            reply.setLoggingEnabled(loggingEnabled);
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public GetBucketVersioningStatusResponseType getBucketVersioningStatus(GetBucketVersioningStatusType request) throws S3Exception {
        GetBucketVersioningStatusResponseType reply = (GetBucketVersioningStatusResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            BucketVersioningConfiguration versioning = s3Client.getBucketVersioningConfiguration(request.getBucket());
            reply.setVersioningStatus(versioning.getStatus());
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public SetBucketVersioningStatusResponseType setBucketVersioningStatus(SetBucketVersioningStatusType request) throws S3Exception {
        SetBucketVersioningStatusResponseType reply = (SetBucketVersioningStatusResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            BucketVersioningConfiguration config = new BucketVersioningConfiguration().withStatus(request.getVersioningStatus());
            SetBucketVersioningConfigurationRequest configRequest = new SetBucketVersioningConfigurationRequest(request.getBucket(), config);
            s3Client.setBucketVersioningConfiguration(configRequest);
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public ListVersionsResponseType listVersions(ListVersionsType request) throws S3Exception {
        ListVersionsResponseType reply = (ListVersionsResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            CanonicalUser owner;
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            ListVersionsRequest listVersionsRequest = new ListVersionsRequest(request.getBucket(), request.getPrefix(), request.getKeyMarker(), request.getVersionIdMarker(), request.getDelimiter(), Integer.valueOf(Integer.parseInt(request.getMaxKeys())));
            VersionListing result = s3Client.listVersions(listVersionsRequest);
            try {
                owner = AclUtils.buildCanonicalUser((Account)requestUser.getAccount());
            }
            catch (AuthException e) {
                LOG.error((Object)"Error getting request user's account during bucket version listing", (Throwable)e);
                Object owner2 = null;
                throw new AccountProblemException("Account for user " + requestUser.getUserId());
            }
            reply.setBucket(request.getBucket());
            reply.setMaxKeys(result.getMaxKeys());
            reply.setDelimiter(result.getDelimiter());
            reply.setNextKeyMarker(result.getNextKeyMarker());
            reply.setNextVersionIdMarker(result.getNextVersionIdMarker());
            reply.setIsTruncated(result.isTruncated());
            reply.setVersionIdMarker(result.getVersionIdMarker());
            reply.setKeyMarker(result.getKeyMarker());
            if (result.getCommonPrefixes() != null && result.getCommonPrefixes().size() > 0) {
                reply.setCommonPrefixesList(new ArrayList());
                for (String s : result.getCommonPrefixes()) {
                    reply.getCommonPrefixesList().add(new CommonPrefixesEntry(s));
                }
            }
            ArrayList<Object> versions = new ArrayList<Object>();
            for (S3VersionSummary summary : result.getVersionSummaries()) {
                if (!summary.isDeleteMarker()) {
                    VersionEntry v = new VersionEntry();
                    v.setKey(summary.getKey());
                    v.setVersionId(summary.getVersionId());
                    v.setLastModified(DateFormatter.dateToHeaderFormattedString((Date)summary.getLastModified()));
                    v.setEtag(summary.getETag());
                    v.setIsLatest(Boolean.valueOf(summary.isLatest()));
                    v.setOwner(owner);
                    v.setSize(summary.getSize());
                    versions.add(v);
                    continue;
                }
                DeleteMarkerEntry d = new DeleteMarkerEntry();
                d.setIsLatest(Boolean.valueOf(summary.isLatest()));
                d.setKey(summary.getKey());
                d.setLastModified(DateFormatter.dateToHeaderFormattedString((Date)summary.getLastModified()));
                d.setOwner(owner);
                d.setVersionId(summary.getVersionId());
                versions.add(d);
            }
            reply.setKeyEntries(versions);
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public DeleteVersionResponseType deleteVersion(DeleteVersionType request) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            s3Client.deleteVersion(request.getBucket(), request.getKey(), request.getVersionId());
            DeleteVersionResponseType reply = (DeleteVersionResponseType)request.getReply();
            reply.setStatus(HttpResponseStatus.NO_CONTENT);
            reply.setStatusMessage("NO CONTENT");
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public HeadObjectResponseType headObject(HeadObjectType request) throws S3Exception {
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        GetObjectMetadataRequest getMetadataRequest = new GetObjectMetadataRequest(request.getBucket(), request.getKey());
        getMetadataRequest.setVersionId(request.getVersionId());
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            ObjectMetadata metadata = s3Client.getObjectMetadata(getMetadataRequest);
            HeadObjectResponseType reply = (HeadObjectResponseType)request.getReply();
            this.populateResponseMetadata((ObjectStorageDataResponseType)reply, metadata);
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public InitiateMultipartUploadResponseType initiateMultipartUpload(InitiateMultipartUploadType request) throws S3Exception {
        InitiateMultipartUploadResponseType reply = (InitiateMultipartUploadResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String bucketName = request.getBucket();
        String key = request.getKey();
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
        ObjectMetadata metadata = new ObjectMetadata();
        for (MetaDataEntry meta : request.getMetaData()) {
            metadata.addUserMetadata(meta.getName(), meta.getValue());
        }
        initiateMultipartUploadRequest.setObjectMetadata(metadata);
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            InitiateMultipartUploadResult result = s3Client.initiateMultipartUpload(initiateMultipartUploadRequest);
            reply.setUploadId(result.getUploadId());
            reply.setBucket(bucketName);
            reply.setKey(key);
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public UploadPartResponseType uploadPart(UploadPartType request, InputStream dataContent) throws S3Exception {
        String bucketName = request.getBucket();
        String key = request.getKey();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        try {
            UploadPartResult result;
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(bucketName);
            uploadPartRequest.setKey(key);
            uploadPartRequest.setInputStream(dataContent);
            uploadPartRequest.setUploadId(request.getUploadId());
            uploadPartRequest.setPartNumber(Integer.valueOf(request.getPartNumber()).intValue());
            uploadPartRequest.setMd5Digest(request.getContentMD5());
            uploadPartRequest.setPartSize(Long.valueOf(request.getContentLength()).longValue());
            try {
                result = s3Client.uploadPart(uploadPartRequest);
            }
            catch (AmazonServiceException e) {
                LOG.debug((Object)"Error from backend", (Throwable)e);
                throw S3ExceptionMapper.fromAWSJavaSDK(e);
            }
            UploadPartResponseType reply = (UploadPartResponseType)request.getReply();
            reply.setEtag(result.getETag());
            reply.setLastModified(new Date());
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }

    public CompleteMultipartUploadResponseType completeMultipartUpload(CompleteMultipartUploadType request) throws S3Exception {
        CompleteMultipartUploadResponseType reply = (CompleteMultipartUploadResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String bucketName = request.getBucket();
        String key = request.getKey();
        String uploadId = request.getUploadId();
        ArrayList parts = request.getParts();
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        for (Part part : parts) {
            PartETag partETag = new PartETag(part.getPartNumber().intValue(), part.getEtag());
            partETags.add(partETag);
        }
        CompleteMultipartUploadRequest multipartRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            CompleteMultipartUploadResult result = s3Client.completeMultipartUpload(multipartRequest);
            reply.setEtag(result.getETag());
            reply.setBucket(bucketName);
            reply.setKey(key);
            reply.setLocation(result.getLocation());
            reply.setLastModified(new Date());
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public AbortMultipartUploadResponseType abortMultipartUpload(AbortMultipartUploadType request) throws S3Exception {
        AbortMultipartUploadResponseType reply = (AbortMultipartUploadResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String bucketName = request.getBucket();
        String key = request.getKey();
        String uploadId = request.getUploadId();
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, key, uploadId);
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            s3Client.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
        return reply;
    }

    public ListPartsResponseType listParts(ListPartsType request) throws S3Exception {
        ListPartsResponseType reply = (ListPartsResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String bucketName = request.getBucket();
        String key = request.getKey();
        String uploadId = request.getUploadId();
        ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
        if (request.getMaxParts() != null) {
            listPartsRequest.setMaxParts(Integer.parseInt(request.getMaxParts()));
        }
        if (request.getPartNumberMarker() != null) {
            listPartsRequest.setPartNumberMarker(Integer.valueOf(Integer.parseInt(request.getPartNumberMarker())));
        }
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            PartListing listing = s3Client.listParts(listPartsRequest);
            reply.setBucket(bucketName);
            reply.setKey(key);
            reply.setUploadId(uploadId);
            Initiator initiator = new Initiator(listing.getInitiator().getId(), listing.getInitiator().getDisplayName());
            reply.setInitiator(initiator);
            CanonicalUser owner = new CanonicalUser(listing.getOwner().getId(), listing.getOwner().getDisplayName());
            reply.setOwner(owner);
            reply.setStorageClass(listing.getStorageClass());
            reply.setPartNumberMarker(listing.getPartNumberMarker().intValue());
            reply.setNextPartNumberMarker(listing.getNextPartNumberMarker().intValue());
            reply.setMaxParts(listing.getMaxParts().intValue());
            reply.setIsTruncated(Boolean.valueOf(listing.isTruncated()));
            List parts = listing.getParts();
            ArrayList replyParts = reply.getParts();
            for (PartSummary part : parts) {
                replyParts.add(new Part(Integer.valueOf(part.getPartNumber()), part.getETag(), part.getLastModified(), Long.valueOf(part.getSize())));
            }
        }
        catch (AmazonServiceException ex) {
            LOG.debug((Object)("Got service error from backend: " + ex.getMessage()), (Throwable)ex);
            throw S3ExceptionMapper.fromAWSJavaSDK(ex);
        }
        return reply;
    }

    public ListMultipartUploadsResponseType listMultipartUploads(ListMultipartUploadsType request) throws S3Exception {
        ListMultipartUploadsResponseType reply = (ListMultipartUploadsResponseType)request.getReply();
        User requestUser = S3ProviderClient.getRequestUser((ObjectStorageRequestType)request);
        OsgInternalS3Client internalS3Client = null;
        String bucketName = request.getBucket();
        ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
        listMultipartUploadsRequest.setMaxUploads(Integer.valueOf(Integer.parseInt(request.getMaxUploads())));
        listMultipartUploadsRequest.setKeyMarker(request.getKeyMarker());
        listMultipartUploadsRequest.setDelimiter(request.getDelimiter());
        listMultipartUploadsRequest.setPrefix(request.getPrefix());
        listMultipartUploadsRequest.setUploadIdMarker(request.getUploadIdMarker());
        try {
            internalS3Client = this.getS3Client(requestUser);
            AmazonS3Client s3Client = internalS3Client.getS3Client();
            MultipartUploadListing listing = s3Client.listMultipartUploads(listMultipartUploadsRequest);
            reply.setBucket(listing.getBucketName());
            reply.setKeyMarker(listing.getKeyMarker());
            reply.setUploadIdMarker(listing.getUploadIdMarker());
            reply.setNextKeyMarker(listing.getNextKeyMarker());
            reply.setNextUploadIdMarker(listing.getNextUploadIdMarker());
            reply.setMaxUploads(Integer.valueOf(listing.getMaxUploads()));
            reply.setIsTruncated(Boolean.valueOf(listing.isTruncated()));
            reply.setPrefix(listing.getPrefix());
            reply.setDelimiter(listing.getDelimiter());
            List commonPrefixes = listing.getCommonPrefixes();
            List multipartUploads = listing.getMultipartUploads();
            List uploads = reply.getUploads();
            ArrayList prefixes = reply.getCommonPrefixes();
            for (MultipartUpload multipartUpload : multipartUploads) {
                uploads.add(new Upload(multipartUpload.getKey(), multipartUpload.getUploadId(), new Initiator(multipartUpload.getInitiator().getId(), multipartUpload.getInitiator().getDisplayName()), new CanonicalUser(multipartUpload.getOwner().getId(), multipartUpload.getOwner().getDisplayName()), multipartUpload.getStorageClass(), multipartUpload.getInitiated()));
            }
            for (String commonPrefix : commonPrefixes) {
                prefixes.add(new CommonPrefixesEntry(commonPrefix));
            }
            return reply;
        }
        catch (AmazonServiceException e) {
            LOG.debug((Object)"Error from backend", (Throwable)e);
            throw S3ExceptionMapper.fromAWSJavaSDK(e);
        }
    }
}

