/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.policy;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.objectstorage.BucketMetadataManagers;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.entities.Bucket;
import java.util.List;

public class ObjectStorageQuotaUtil {
    public static long countBucketsByAccount(String accountId) throws AuthException {
        try {
            return BucketMetadataManagers.getInstance().countBucketsByAccount(Accounts.lookupAccountById((String)accountId).getCanonicalId());
        }
        catch (Exception e) {
            throw new AuthException("Failed to search bucket", (Throwable)e);
        }
    }

    public static long countBucketsByUser(String userId) throws AuthException {
        try {
            return BucketMetadataManagers.getInstance().countBucketsByUser(userId);
        }
        catch (Exception e) {
            throw new AuthException("Failed to search bucket", (Throwable)e);
        }
    }

    public static long countBucketObjects(String bucketName) throws AuthException {
        try {
            return ObjectMetadataManagers.getInstance().countValid(BucketMetadataManagers.getInstance().lookupBucket(bucketName));
        }
        catch (Exception e) {
            throw new AuthException("Failed to search object", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getBucketSize(String bucketName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            Bucket bucket = BucketMetadataManagers.getInstance().lookupBucket(bucketName);
            long objectSize = ObjectMetadataManagers.getInstance().getTotalSize(bucket);
            long mpuPartsSize = MpuPartMetadataManagers.getInstance().getTotalSize(bucket);
            long l = objectSize + mpuPartsSize;
            return l;
        }
        catch (Exception e) {
            throw new AuthException("Failed to get bucket total size", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getTotalObjectsSizeByAccount(String accountId) throws AuthException {
        String canonicalId = Accounts.lookupAccountById((String)accountId).getCanonicalId();
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            List<Bucket> bucketList = BucketMetadataManagers.getInstance().lookupBucketsByOwner(canonicalId);
            long size = 0L;
            for (Bucket b : bucketList) {
                size += ObjectMetadataManagers.getInstance().getTotalSize(b);
                size += MpuPartMetadataManagers.getInstance().getTotalSize(b);
            }
            long l = size;
            return l;
        }
        catch (Exception e) {
            throw new AuthException("Failed to search bucket", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getTotalObjectsSizeByUser(String userId) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            List<Bucket> bucketList = BucketMetadataManagers.getInstance().lookupBucketsByUser(userId);
            long size = 0L;
            for (Bucket b : bucketList) {
                size += ObjectMetadataManagers.getInstance().getTotalSize(b);
                size += MpuPartMetadataManagers.getInstance().getTotalSize(b);
            }
            long l = size;
            return l;
        }
        catch (Exception e) {
            throw new AuthException("Failed to search bucket", (Throwable)e);
        }
    }

    public static long getTotalObjectSize() throws Exception {
        return ObjectMetadataManagers.getInstance().getTotalSize(null) + MpuPartMetadataManagers.getInstance().getTotalSize(null);
    }
}

