/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.objectstorage.policy.ObjectStorageQuotaUtil;
import net.sf.json.JSONException;

@PolicyKey(value="s3:quota-buckettotalsize")
public class BucketTotalSizeQuotaKey
extends QuotaKey {
    private static final String KEY = "s3:quota-buckettotalsize";

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"s3", (String)"putobject").equals(action);
    }

    public String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        switch (scope) {
            case ACCOUNT: {
                return Long.toString(BucketTotalSizeQuotaKey.toMb((Long)(ObjectStorageQuotaUtil.getTotalObjectsSizeByAccount(id) + quantity)));
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return Long.toString(BucketTotalSizeQuotaKey.toMb((Long)(ObjectStorageQuotaUtil.getTotalObjectsSizeByUser(id) + quantity)));
            }
        }
        throw new AuthException("Invalid scope");
    }
}

