/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.objectstorage.policy.ObjectStorageQuotaUtil;
import net.sf.json.JSONException;

@PolicyKey(value="s3:quota-bucketsize")
public class BucketSizeQuotaKey
extends QuotaKey {
    private static final String KEY = "s3:quota-bucketsize";

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"s3", (String)"putobject").equals(action);
    }

    public String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        String bucketName = resource.split("/", 2)[0];
        switch (scope) {
            case ACCOUNT: {
                return Long.toString(BucketSizeQuotaKey.toMb((Long)(ObjectStorageQuotaUtil.getBucketSize(bucketName) + quantity)));
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return Long.toString(BucketSizeQuotaKey.toMb((Long)(ObjectStorageQuotaUtil.getBucketSize(bucketName) + quantity)));
            }
        }
        throw new AuthException("Invalid scope");
    }
}

