/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.stages;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.ObjectStorageBucketLogger;
import com.eucalyptus.objectstorage.msgs.ObjectStorageErrorMessageType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageResponseType;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageRESTLoggerOutbound
extends MessageStackHandler {
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            ObjectStorageErrorMessageType errorMessage;
            BucketLogData logData;
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            if (httpResponse.getMessage() instanceof ObjectStorageResponseType) {
                ObjectStorageResponseType response = (ObjectStorageResponseType)httpResponse.getMessage();
                BucketLogData logData2 = response.getLogData();
                if (logData2 != null) {
                    this.computeStats(logData2, httpResponse);
                    response.setLogData(null);
                }
            } else if (httpResponse.getMessage() instanceof ObjectStorageErrorMessageType && (logData = (errorMessage = (ObjectStorageErrorMessageType)httpResponse.getMessage()).getLogData()) != null) {
                this.computeStats(logData, httpResponse);
                logData.setError(errorMessage.getCode());
                errorMessage.setLogData(null);
            }
        }
    }

    private void computeStats(BucketLogData logData, MappingHttpResponse httpResponse) {
        logData.setBytesSent((long)httpResponse.getContent().readableBytes());
        long startTime = logData.getTotalTime();
        long currentTime = System.currentTimeMillis();
        logData.setTotalTime(currentTime - startTime);
        long startTurnAroundTime = logData.getTurnAroundTime();
        logData.setTurnAroundTime(Math.min(currentTime - startTurnAroundTime, logData.getTotalTime()));
        HttpResponseStatus status = httpResponse.getStatus();
        if (status != null) {
            logData.setStatus(Integer.toString(status.getCode()));
        }
        ObjectStorageBucketLogger.getInstance().addLogEntry(logData);
    }
}

