/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.objectstorage.exceptions.s3.InvalidPolicyDocumentException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;
import org.bouncycastle.util.encoders.Base64;

public class UploadPolicyChecker {
    private static Logger LOG = Logger.getLogger(UploadPolicyChecker.class);

    public static void checkPolicy(Map<String, String> formFields) throws S3Exception {
        if (formFields.containsKey(ObjectStorageProperties.FormField.Policy.toString())) {
            String policy = new String(Base64.decode((String)formFields.get(ObjectStorageProperties.FormField.Policy.toString())));
            try {
                String policyData = new String(Base64.encode((byte[])policy.getBytes()));
            }
            catch (Exception ex) {
                LOG.warn((Object)"Denying POST upload due to inability to decode/read required upload Policy from request", (Throwable)ex);
                throw new InvalidPolicyDocumentException(policy, "Invalid policy content");
            }
            try {
                JsonSlurper jsonSlurper = new JsonSlurper();
                JSONObject policyObject = (JSONObject)jsonSlurper.parseText(policy);
                String expiration = (String)policyObject.get(ObjectStorageProperties.PolicyHeaders.expiration.toString());
                if (expiration != null) {
                    Date expirationDate = DateUtils.parseIso8601DateTimeOrDate((String)expiration);
                    if (new Date().getTime() > expirationDate.getTime()) {
                        LOG.warn((Object)"Denying POST upload because included policy has expired.");
                        throw new InvalidPolicyDocumentException(expiration, "Expired policy: " + expiration);
                    }
                }
                ArrayList<String> policyItemNames = new ArrayList<String>();
                JSONArray conditions = (JSONArray)policyObject.get(ObjectStorageProperties.PolicyHeaders.conditions.toString());
                for (int i = 0; i < conditions.size(); ++i) {
                    JSONArray jsonArray;
                    Object policyItem = conditions.get(i);
                    if (policyItem instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)policyItem;
                        if (UploadPolicyChecker.exactMatch(jsonObject, formFields, policyItemNames)) continue;
                        LOG.warn((Object)"Denying POST upload because Policy verification failed due to mismatch of conditions");
                        throw new InvalidPolicyDocumentException(jsonObject.toString(), "Policy conditions not met");
                    }
                    if (!(policyItem instanceof JSONArray) || UploadPolicyChecker.partialMatch(jsonArray = (JSONArray)policyItem, formFields, policyItemNames)) continue;
                    LOG.warn((Object)"Denying POST upload because Policy verification failed due to mismatch of conditions");
                    throw new InvalidPolicyDocumentException(jsonArray.toString(), "Policy conditions not met");
                }
                Set<String> formFieldsKeys = formFields.keySet();
                for (String formKey : formFieldsKeys) {
                    if (formKey.startsWith("x-ignore-")) continue;
                    boolean fieldOkay = false;
                    for (ObjectStorageProperties.IgnoredFields field : ObjectStorageProperties.IgnoredFields.values()) {
                        if (!formKey.equals(field.toString())) continue;
                        fieldOkay = true;
                        break;
                    }
                    if (fieldOkay || policyItemNames.contains(formKey) || ObjectStorageProperties.FormField.isHttpField((String)formKey)) continue;
                    LOG.warn((Object)("Denying POST upload due to: All fields except those marked with x-ignore- should be in policy. Form Key: " + formKey));
                    throw new InvalidPolicyDocumentException(formKey, "All fields except those marked with x-ignore- should be in policy.");
                }
            }
            catch (S3Exception e) {
                throw e;
            }
            catch (Exception ex) {
                LOG.error((Object)"Denying POST upload due to: Unexpected exception during POST policy checks", (Throwable)ex);
                throw new InvalidPolicyDocumentException(policy, "Error processing the policy");
            }
        }
    }

    private static boolean exactMatch(JSONObject jsonObject, Map<String, String> formFields, List<String> policyItemNames) throws S3Exception {
        Iterator iterator = jsonObject.keys();
        String key = null;
        boolean returnValue = false;
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            try {
                if (jsonObject.get(key).equals(formFields.get(key).trim())) {
                    returnValue = true;
                    continue;
                }
                returnValue = false;
            }
            catch (Exception ex) {
                LOG.error((Object)"Unexpected error evaluating the policy for an exact match", (Throwable)ex);
                return false;
            }
        }
        if (!returnValue) {
            LOG.trace((Object)("POST upload policy exact match on " + key + " failed"));
        }
        return returnValue;
    }

    private static boolean partialMatch(JSONArray jsonArray, Map<String, String> formFields, List<String> policyItemNames) throws S3Exception {
        String key;
        boolean returnValue = false;
        if (jsonArray.size() != 3) {
            return false;
        }
        try {
            String condition = (String)jsonArray.get(0);
            key = (String)jsonArray.get(1);
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            String value = (String)jsonArray.get(2);
            if (condition.contains("eq")) {
                if (value.equals(formFields.get(key).trim())) {
                    returnValue = true;
                }
            } else if (condition.contains("starts-with")) {
                if (!formFields.containsKey(key)) {
                    return false;
                }
                if (formFields.get(key).trim().startsWith(value)) {
                    returnValue = true;
                }
            } else if (condition.equals("content-length-range")) {
                String[] rangeValues = value.split(",");
                if (rangeValues.length != 2) {
                    throw new InvalidPolicyDocumentException(value, "content-length-range value could not be parsed properly");
                }
                long lower = Long.valueOf(rangeValues[0]);
                long upper = Long.valueOf(rangeValues[1]);
                long size = Long.valueOf(formFields.get(ObjectStorageProperties.FormField.x_ignore_filecontentlength.toString()));
                returnValue = lower <= size && size <= upper;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Unexpected error evaluating the policy for a partial match", (Throwable)ex);
            return false;
        }
        if (!returnValue) {
            LOG.trace((Object)("POST upload policy partial match on " + key + " failed"));
        }
        return returnValue;
    }
}

