/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidAccessKeyIdException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidAddressingHeaderException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidSecurityException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.exceptions.s3.SignatureDoesNotMatchException;
import com.eucalyptus.objectstorage.pipeline.auth.ObjectStorageWrappedCredentials;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.login.LoginException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;

public class S3Authentication {
    private static final Logger LOG = Logger.getLogger(S3Authentication.class);

    static void authenticateVersion2(MappingHttpRequest httpRequest, Map<AuthorizationField, String> authMap) throws S3Exception {
        String verb = httpRequest.getMethod().getName();
        String date = S3Authentication.getDate(httpRequest);
        String addrString = S3Authentication.getS3AddressString(httpRequest, true);
        String content_md5 = httpRequest.getHeader("Content-MD5");
        content_md5 = content_md5 == null ? "" : content_md5;
        String content_type = httpRequest.getHeader("Content-Type");
        content_type = content_type == null ? "" : content_type;
        String securityToken = httpRequest.getHeader("x-amz-security-token");
        String canonicalizedAmzHeaders = S3Authentication.getCanonicalizedAmzHeaders(httpRequest, false);
        String data = verb + "\n" + content_md5 + "\n" + content_type + "\n" + date + "\n" + canonicalizedAmzHeaders + addrString;
        String accessKeyId = authMap.get((Object)AuthorizationField.AccessKeyId);
        String signature = authMap.get((Object)AuthorizationField.Signature);
        try {
            SecurityContext.getLoginContext((WrappedCredentials)new ObjectStorageWrappedCredentials(httpRequest.getCorrelationId(), data, accessKeyId, signature, securityToken)).login();
        }
        catch (LoginException ex) {
            if (ex.getMessage().contains("The AWS Access Key Id you provided does not exist in our records")) {
                throw new InvalidAccessKeyIdException(accessKeyId);
            }
            if (httpRequest.getUri().startsWith(((ObjectStorage)ComponentIds.lookup(ObjectStorage.class)).getServicePath(new String[0])) || httpRequest.getUri().startsWith("/services/Walrus")) {
                try {
                    String modifiedAddrString = S3Authentication.getS3AddressString(httpRequest, false);
                    data = verb + "\n" + content_md5 + "\n" + content_type + "\n" + date + "\n" + canonicalizedAmzHeaders + modifiedAddrString;
                    SecurityContext.getLoginContext((WrappedCredentials)new ObjectStorageWrappedCredentials(httpRequest.getCorrelationId(), data, accessKeyId, signature, securityToken)).login();
                }
                catch (S3Exception ex2) {
                    LOG.debug((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Authentication failed due to signature match issue:"), (Throwable)ex2);
                    throw ex2;
                }
                catch (Exception ex2) {
                    LOG.debug((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Authentication failed due to signature match issue:"), (Throwable)ex2);
                    throw new SignatureDoesNotMatchException(data);
                }
            }
            LOG.debug((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Authentication failed due to signature mismatch:"), (Throwable)ex);
            throw new SignatureDoesNotMatchException(data);
        }
        catch (Exception e) {
            LOG.warn((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Unexpected failure trying to authenticateVersion2 request"), (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    static String buildStringToSignFromHeaders(MappingHttpRequest httpRequest) throws Exception {
        String verb = httpRequest.getMethod().getName();
        String date = S3Authentication.getDate(httpRequest);
        String addrString = S3Authentication.getS3AddressString(httpRequest, true);
        String content_md5 = httpRequest.getHeader("Content-MD5");
        content_md5 = content_md5 == null ? "" : content_md5;
        String content_type = httpRequest.getHeader("Content-Type");
        content_type = content_type == null ? "" : content_type;
        String securityToken = httpRequest.getHeader("x-amz-security-token");
        String canonicalizedAmzHeaders = S3Authentication.getCanonicalizedAmzHeaders(httpRequest, false);
        return verb + "\n" + content_md5 + "\n" + content_type + "\n" + date + "\n" + canonicalizedAmzHeaders + addrString;
    }

    static String buildStringToSignFromQueryParams(MappingHttpRequest httpRequest) throws Exception {
        Map parameters = httpRequest.getParameters();
        String verb = httpRequest.getMethod().getName();
        String content_md5 = httpRequest.getHeader("Content-MD5");
        content_md5 = content_md5 == null ? "" : content_md5;
        String content_type = httpRequest.getHeader("Content-Type");
        content_type = content_type == null ? "" : content_type;
        String addrString = S3Authentication.getS3AddressString(httpRequest, true);
        String accesskeyid = (String)parameters.remove(SecurityParameter.AWSAccessKeyId.toString());
        String expires = (String)parameters.remove(SecurityParameter.Expires.toString());
        if (expires == null) {
            throw new InvalidSecurityException("Expiration parameter must be specified.");
        }
        String canonicalizedAmzHeaders = S3Authentication.getCanonicalizedAmzHeaders(httpRequest, true);
        return verb + "\n" + content_md5 + "\n" + content_type + "\n" + Long.parseLong(expires) + "\n" + canonicalizedAmzHeaders + addrString;
    }

    static void authenticateQueryString(MappingHttpRequest httpRequest) throws S3Exception {
        block10: {
            Map parameters = httpRequest.getParameters();
            String verb = httpRequest.getMethod().getName();
            String content_md5 = httpRequest.getHeader("Content-MD5");
            content_md5 = content_md5 == null ? "" : content_md5;
            String content_type = httpRequest.getHeader("Content-Type");
            content_type = content_type == null ? "" : content_type;
            String addrString = S3Authentication.getS3AddressString(httpRequest, true);
            String accessKeyId = (String)parameters.remove(SecurityParameter.AWSAccessKeyId.toString());
            try {
                String signature = (String)parameters.remove(SecurityParameter.Signature.toString());
                if (signature == null) {
                    throw new InvalidSecurityException("No signature found");
                }
                String expires = (String)parameters.remove(SecurityParameter.Expires.toString());
                if (expires == null) {
                    throw new InvalidSecurityException("Expiration parameter must be specified.");
                }
                String securityToken = (String)parameters.get("x-amz-security-token");
                if (S3Authentication.checkExpires(expires)) {
                    String canonicalizedAmzHeaders = S3Authentication.getCanonicalizedAmzHeaders(httpRequest, true);
                    String stringToSign = verb + "\n" + content_md5 + "\n" + content_type + "\n" + Long.parseLong(expires) + "\n" + canonicalizedAmzHeaders + addrString;
                    try {
                        SecurityContext.getLoginContext((WrappedCredentials)new ObjectStorageWrappedCredentials(httpRequest.getCorrelationId(), stringToSign, accessKeyId, signature, securityToken)).login();
                        break block10;
                    }
                    catch (Exception ex) {
                        if (httpRequest.getUri().startsWith(((ObjectStorage)ComponentIds.lookup(ObjectStorage.class)).getServicePath(new String[0])) || httpRequest.getUri().startsWith("/services/Walrus")) {
                            try {
                                String modifiedAddrString = S3Authentication.getS3AddressString(httpRequest, false);
                                stringToSign = verb + "\n" + content_md5 + "\n" + content_type + "\n" + Long.parseLong(expires) + "\n" + canonicalizedAmzHeaders + modifiedAddrString;
                                SecurityContext.getLoginContext((WrappedCredentials)new ObjectStorageWrappedCredentials(httpRequest.getCorrelationId(), stringToSign, accessKeyId, signature, securityToken)).login();
                                break block10;
                            }
                            catch (Exception ex2) {
                                LOG.error((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " authentication failed due to signature mismatch:"), (Throwable)ex2);
                                throw new SignatureDoesNotMatchException(stringToSign);
                            }
                        }
                        LOG.error((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " authentication failed due to signature mismatch:"), (Throwable)ex);
                        throw new SignatureDoesNotMatchException(stringToSign);
                    }
                }
                throw new AccessDeniedException("Cannot process request. Expired.");
            }
            catch (Exception ex) {
                throw new AccessDeniedException("Could not verify request " + ex.getMessage());
            }
        }
    }

    static boolean checkExpires(String expires) {
        Long expireTime = Long.parseLong(expires);
        Long currentTime = new Date().getTime() / 1000L;
        return currentTime <= expireTime;
    }

    static String getDate(MappingHttpRequest httpRequest) throws AccessDeniedException {
        String verifyDate;
        String date;
        if (httpRequest.containsHeader("x-amz-date")) {
            date = "";
            verifyDate = httpRequest.getHeader("x-amz-date");
        } else {
            verifyDate = date = httpRequest.getAndRemoveHeader(SecurityParameter.Date.toString());
            if (date == null || date.length() <= 0) {
                throw new AccessDeniedException("User authentication failed. Date must be specified.");
            }
        }
        try {
            Date dateToVerify = DateUtil.parseDate((String)verifyDate);
            Date currentDate = new Date();
            if (Math.abs(currentDate.getTime() - dateToVerify.getTime()) > 900000L) {
                LOG.error((Object)("Incoming ObjectStorage message is expired. Current date: " + currentDate.toString() + " Message's Verification Date: " + dateToVerify.toString()));
                throw new AccessDeniedException("Message expired. Sorry.");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot parse date: " + verifyDate));
            throw new AccessDeniedException("Unable to parse date.");
        }
        return date;
    }

    private static void processHeaderValue(String name, String value, Map<String, String> aggregatingMap) {
        String headerNameString = name.toLowerCase().trim();
        if (headerNameString.startsWith("x-amz-")) {
            value = value.trim();
            String[] parts = value.split("\n");
            value = "";
            for (String part : parts) {
                part = part.trim();
                value = value + part + " ";
            }
            value = value.trim();
            if (aggregatingMap.containsKey(headerNameString)) {
                String oldValue = aggregatingMap.remove(headerNameString);
                oldValue = oldValue + "," + value;
                aggregatingMap.put(headerNameString, oldValue);
            } else {
                aggregatingMap.put(headerNameString, value);
            }
        }
    }

    private static String getCanonicalizedAmzHeaders(MappingHttpRequest httpRequest, boolean includeQueryParams) {
        String result = "";
        Set headerNames = httpRequest.getHeaderNames();
        TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
        for (String headerName : headerNames) {
            String headerNameString = headerName.toLowerCase().trim();
            if (!headerNameString.startsWith("x-amz-")) continue;
            String value = httpRequest.getHeader(headerName).trim();
            String[] parts = value.split("\n");
            value = "";
            for (String part : parts) {
                part = part.trim();
                value = value + part + " ";
            }
            value = value.trim();
            if (amzHeaders.containsKey(headerNameString)) {
                String oldValue = amzHeaders.remove(headerNameString);
                oldValue = oldValue + "," + value;
                amzHeaders.put(headerNameString, oldValue);
                continue;
            }
            amzHeaders.put(headerNameString, value);
        }
        if (includeQueryParams) {
            for (String paramName : httpRequest.getParameters().keySet()) {
                S3Authentication.processHeaderValue(paramName, (String)httpRequest.getParameters().get(paramName), amzHeaders);
            }
        }
        for (String key : amzHeaders.keySet()) {
            String value = (String)amzHeaders.get(key);
            result = result + key + ":" + value + "\n";
        }
        return result;
    }

    static String[] getSigInfo(String auth_part) {
        int index = auth_part.lastIndexOf(" ");
        String sigString = auth_part.substring(index + 1);
        return sigString.split(":");
    }

    static String getS3AddressString(MappingHttpRequest httpRequest, boolean removeServicePath) throws S3Exception {
        try {
            String hostBucket;
            String addr = httpRequest.getUri();
            String targetHost = httpRequest.getHeader("Host");
            String osgServicePath = ((ObjectStorage)ComponentIds.lookup(ObjectStorage.class)).getServicePath(new String[0]);
            StringBuilder addrString = new StringBuilder();
            if (targetHost.contains(".objectstorage")) {
                hostBucket = targetHost.substring(0, targetHost.indexOf(".objectstorage"));
                if (hostBucket.length() == 0) {
                    throw new InvalidAddressingHeaderException("Invalid Host header: " + targetHost);
                }
                addrString.append("/" + hostBucket);
            } else if (targetHost.contains(".walrus")) {
                hostBucket = targetHost.substring(0, targetHost.indexOf(".walrus"));
                if (hostBucket.length() == 0) {
                    throw new InvalidAddressingHeaderException("Invalid Host header: " + targetHost);
                }
                addrString.append("/" + hostBucket);
            } else if (removeServicePath) {
                if (addr.startsWith(osgServicePath)) {
                    addr = addr.substring(osgServicePath.length(), addr.length());
                } else if (addr.startsWith("/services/Walrus")) {
                    addr = addr.substring("/services/Walrus".length(), addr.length());
                }
            }
            String key = addr.split("\\?", 2)[0];
            if (!Strings.isNullOrEmpty((String)key)) {
                addrString.append(key);
            } else {
                addrString.append("/");
            }
            ArrayList<String> canonicalSubresources = new ArrayList<String>();
            for (String queryParam : httpRequest.getParameters().keySet()) {
                try {
                    if (ObjectStorageProperties.SubResource.valueOf((String)queryParam) != null) {
                        canonicalSubresources.add(queryParam);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    if (ObjectStorageProperties.ResponseHeaderOverrides.fromString((String)queryParam) == null) continue;
                    canonicalSubresources.add(queryParam);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (canonicalSubresources.size() > 0) {
                Collections.sort(canonicalSubresources);
                addrString.append("?");
                for (String subResource : canonicalSubresources) {
                    String value = (String)httpRequest.getParameters().get(subResource);
                    addrString.append(subResource);
                    if (!Strings.isNullOrEmpty((String)value)) {
                        addrString.append("=").append(value);
                    }
                    addrString.append("&");
                }
                if (addrString.charAt(addrString.length() - 1) == '&') {
                    addrString.deleteCharAt(addrString.length() - 1);
                }
            }
            return addrString.toString();
        }
        catch (S3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected static enum AuthorizationField {
        Type,
        AccessKeyId,
        Signature;

    }

    public static enum SecurityParameter {
        AWSAccessKeyId,
        Timestamp,
        Expires,
        Signature,
        Authorization,
        Date,
        Content_MD5,
        Content_Type,
        SecurityToken;

    }
}

