/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.StackConfiguration;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;

public class ObjectStoragePUTLifecycleAndAclAggregatorHandler
extends HttpChunkAggregator {
    private static final int DEFAULT_MAX_CONTENT_LENGTH = StackConfiguration.CLIENT_HTTP_CHUNK_BUFFER_MAX;
    private static final long MAX_DECHUNKING_SIZE = 0x200000L;

    public ObjectStoragePUTLifecycleAndAclAggregatorHandler() {
        super(DEFAULT_MAX_CONTENT_LENGTH);
    }

    public ObjectStoragePUTLifecycleAndAclAggregatorHandler(int maxContentLength) {
        super(maxContentLength);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        MappingHttpRequest httpRequest;
        String contentLength;
        Object message = event.getMessage();
        if (message instanceof MappingHttpRequest && (contentLength = (httpRequest = (MappingHttpRequest)message).getHeader("Content-Length")) != null && !"".equals(contentLength)) {
            Long parsedContentLength = null;
            try {
                parsedContentLength = Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parsedContentLength != null && parsedContentLength <= 0x200000L) {
                super.messageReceived(ctx, event);
                return;
            }
        }
        if (message instanceof HttpChunk) {
            try {
                super.messageReceived(ctx, event);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        ctx.sendUpstream((ChannelEvent)event);
    }
}

