/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataRequestType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.ChannelBufferStreamingInputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;

public class ObjectStoragePUTAggregator
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private static final Logger LOG = Logger.getLogger(ObjectStoragePUTAggregator.class);
    protected static final ConcurrentHashMap<Channel, ChannelBufferStreamingInputStream> dataMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
        try {
            Logs.extreme().debug((Object)("Removing data map on channel disconnected event for channel: " + ctx.getChannel().getId()));
            dataMap.remove(ctx.getChannel());
        }
        catch (Throwable throwable) {
        }
        finally {
            super.channelDisconnected(ctx, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
        try {
            Logs.extreme().debug((Object)("Removing data map on channel closed event for channel: " + ctx.getChannel().getId()));
            dataMap.remove(ctx.getChannel());
        }
        catch (Throwable throwable) {
        }
        finally {
            super.channelClosed(ctx, evt);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            if (httpRequest.getMessage() instanceof ObjectStorageDataRequestType && httpRequest.isChunked()) {
                this.initializeNewPut(ctx, (ObjectStorageDataRequestType)httpRequest.getMessage());
            }
        } else if (event.getMessage() instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)event.getMessage();
            this.appendChunk(chunk.getContent(), ctx.getChannel());
            if (chunk.isLast()) {
                Logs.extreme().debug((Object)("Removing data map due to last chunk processed event for channel: " + ctx.getChannel().getId()));
                dataMap.remove(ctx.getChannel());
            }
        }
        ctx.sendUpstream((ChannelEvent)event);
    }

    protected void initializeNewPut(ChannelHandlerContext ctx, ObjectStorageDataRequestType request) throws IllegalStateException {
        Logs.extreme().debug((Object)("Adding entry to data map in PUT aggregator for channel: " + ctx.getChannel().getId()));
        ChannelBufferStreamingInputStream stream = request.getData();
        ChannelBufferStreamingInputStream foundStream = dataMap.putIfAbsent(ctx.getChannel(), stream);
        if (foundStream != null) {
            Logs.extreme().debug((Object)("Found existing entry in map for this channel. Streams should never cross. Throwing illegal state for channel: " + ctx.getChannel().getId()));
            throw new IllegalStateException("Duplicate messages for same PUT, cannot overwrite data buffer. Channel:" + ctx.getChannel().getId());
        }
    }

    protected void appendChunk(ChannelBuffer input, Channel channel) throws Exception {
        Logs.extreme().debug((Object)("Writing content data to stream for channel: " + channel.getId() + " Content length: " + input.readableBytes()));
        ChannelBufferStreamingInputStream stream = dataMap.get(channel);
        if (stream == null) {
            throw new IllegalStateException("received " + HttpChunk.class.getSimpleName() + " without " + HttpMessage.class.getSimpleName());
        }
        try {
            stream.putChunk(input);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void afterAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext arg0) throws Exception {
    }

    public void beforeAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext arg0) throws Exception {
    }
}

