/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.msgs.CopyObjectResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataGetResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageResponseType;
import com.eucalyptus.objectstorage.msgs.PostObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PutObjectResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketLifecycleResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketTaggingResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.UploadPartResponseType;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageOutboundHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(ObjectStorageOutboundHandler.class);

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        if (channelEvent instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)channelEvent);
        } else {
            ctx.sendUpstream(channelEvent);
        }
    }

    private void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            this.outgoingMessage(ctx, msgEvent);
        }
        ctx.sendDownstream(channelEvent);
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            if (msg instanceof PostObjectResponseType) {
                PostObjectResponseType postObjectResponse = (PostObjectResponseType)msg;
                String redirectUrl = postObjectResponse.getRedirectUrl();
                if (redirectUrl != null) {
                    httpResponse.addHeader("Location", (Object)redirectUrl);
                    httpResponse.setStatus(HttpResponseStatus.SEE_OTHER);
                    httpResponse.setMessage(null);
                } else {
                    Integer successCode = postObjectResponse.getSuccessCode();
                    if (successCode != null) {
                        if (successCode != 201) {
                            httpResponse.setMessage(null);
                            httpResponse.setStatus(new HttpResponseStatus(successCode.intValue(), "OK"));
                        } else {
                            httpResponse.setStatus(new HttpResponseStatus(successCode.intValue(), "Created"));
                        }
                    }
                }
                event.getFuture().addListener(ChannelFutureListener.CLOSE);
            } else if (msg instanceof CopyObjectResponseType) {
                CopyObjectResponseType copyResponse = (CopyObjectResponseType)msg;
                if (copyResponse.getVersionId() != null) {
                    httpResponse.addHeader("x-amz-version-id", (Object)copyResponse.getVersionId());
                }
                if (copyResponse.getCopySourceVersionId() != null) {
                    httpResponse.addHeader("x-amz-copy-source-version-id", (Object)copyResponse.getCopySourceVersionId());
                }
            } else if (msg instanceof CreateBucketResponseType) {
                httpResponse.setStatus(HttpResponseStatus.OK);
                this.removeResponseBody(msg, httpResponse);
                event.getFuture().addListener(ChannelFutureListener.CLOSE);
            } else if (msg instanceof ObjectStorageDataResponseType) {
                ObjectStorageDataResponseType response = (ObjectStorageDataResponseType)msg;
                if (response.getEtag() != null) {
                    httpResponse.setHeader("ETag", (Object)('\"' + response.getEtag() + '\"'));
                }
                if (response.getVersionId() != null) {
                    httpResponse.setHeader("x-amz-version-id", (Object)response.getVersionId());
                }
                if (msg instanceof ObjectStorageDataGetResponseType && response.getLastModified() != null) {
                    httpResponse.setHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)response.getLastModified()));
                }
                if (msg instanceof PutObjectResponseType || msg instanceof UploadPartResponseType) {
                    this.removeResponseBody(msg, httpResponse);
                }
            } else if (msg instanceof ObjectStorageResponseType && (msg instanceof SetBucketAccessControlPolicyResponseType || msg instanceof SetBucketLifecycleResponseType || msg instanceof SetBucketLoggingStatusResponseType || msg instanceof SetBucketVersioningStatusResponseType || msg instanceof SetObjectAccessControlPolicyResponseType || msg instanceof SetBucketTaggingResponseType)) {
                if (msg instanceof SetObjectAccessControlPolicyResponseType && ((SetObjectAccessControlPolicyResponseType)msg).getVersionId() != null) {
                    httpResponse.setHeader("x-amz-version-id", (Object)((SetObjectAccessControlPolicyResponseType)msg).getVersionId());
                }
                this.removeResponseBody(msg, httpResponse);
            }
        }
    }

    private void removeResponseBody(BaseMessage msg, MappingHttpResponse httpResponse) {
        httpResponse.setHeader("Date", (Object)DateFormatter.dateToHeaderFormattedString((Date)new Date()));
        httpResponse.setHeader("Content-Length", (Object)String.valueOf(0));
        if (msg.getCorrelationId() != null) {
            httpResponse.setHeader("x-amz-request-id", (Object)msg.getCorrelationId());
        }
        httpResponse.setMessage(null);
    }
}

