/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponse;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageHEADOutboundHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(ObjectStorageHEADOutboundHandler.class);

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            httpResponse.setHeader("Date", (Object)DateFormatter.dateToHeaderFormattedString((Date)new Date()));
            httpResponse.setHeader("x-amz-request-id", (Object)msg.getCorrelationId());
            if (msg instanceof ObjectStorageDataResponseType) {
                String contentLength;
                ObjectStorageDataResponseType headResponse = (ObjectStorageDataResponseType)msg;
                httpResponse.setHeader("ETag", (Object)("\"" + headResponse.getEtag() + "\""));
                String contentType = headResponse.getContentType();
                if (!Strings.isNullOrEmpty((String)contentType)) {
                    httpResponse.setHeader("Content-Type", (Object)contentType);
                }
                if (!Strings.isNullOrEmpty((String)(contentLength = String.valueOf(headResponse.getSize())))) {
                    httpResponse.setHeader("Content-Length", (Object)contentLength);
                }
                if (!Strings.isNullOrEmpty((String)headResponse.getVersionId()) && !"null".equals(((ObjectStorageDataResponseType)msg).getVersionId())) {
                    httpResponse.setHeader("x-amz-version-id", (Object)((ObjectStorageDataResponseType)msg).getVersionId());
                }
                for (MetaDataEntry m : headResponse.getMetaData()) {
                    httpResponse.addHeader("x-amz-meta-" + m.getName(), (Object)m.getValue());
                }
                Date lastModified = headResponse.getLastModified();
                if (lastModified != null) {
                    httpResponse.setHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)lastModified));
                }
                OSGUtil.addCopiedHeadersToResponse((HttpResponse)httpResponse, (ObjectStorageDataResponseType)headResponse);
            }
            httpResponse.setMessage(null);
        }
    }
}

