/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataGetResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.pipeline.handlers.ObjectStorageBasicOutboundHandler;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.common.ChunkedDataStream;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.server.MessageStatistics;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageGETOutboundHandler
extends ObjectStorageBasicOutboundHandler {
    private static Logger LOG = Logger.getLogger(ObjectStorageGETOutboundHandler.class);

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        try {
            MessageEvent msgEvent;
            if (channelEvent instanceof MessageEvent && (msgEvent = (MessageEvent)channelEvent).getMessage() != null) {
                Callable stat = MessageStatistics.startDownstream((Channel)ctx.getChannel(), (ChannelHandler)this);
                boolean isDone = this.handleMessage(ctx, msgEvent);
                stat.call();
                if (isDone) {
                    return;
                }
            }
            ctx.sendDownstream(channelEvent);
        }
        catch (Exception e) {
            throw new WebServicesException(e.getMessage(), HttpResponseStatus.BAD_REQUEST);
        }
    }

    public boolean handleMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        this.handleBasicOutgoingMessage(ctx, event);
        return this.handleOutgoingMessage(ctx, event);
    }

    protected boolean handleOutgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        MappingHttpResponse httpResponse;
        BaseMessage msg;
        if (event.getMessage() instanceof MappingHttpResponse && (msg = (BaseMessage)(httpResponse = (MappingHttpResponse)event.getMessage()).getMessage()) instanceof ObjectStorageDataGetResponseType) {
            ObjectStorageDataGetResponseType dataResponse = (ObjectStorageDataGetResponseType)msg;
            this.writeObjectStorageDataGetResponse(dataResponse, ctx);
            return true;
        }
        return false;
    }

    protected void writeObjectStorageDataGetResponse(final ObjectStorageDataGetResponseType response, final ChannelHandlerContext ctx) {
        Channel channel;
        DefaultHttpResponse httpResponse = this.createHttpResponse(response);
        if (!Strings.isNullOrEmpty((String)response.getCorrelationId())) {
            httpResponse.setHeader("x-amz-request-id", (Object)response.getCorrelationId());
        }
        if ((channel = ctx.getChannel()).isConnected()) {
            ChannelFuture writeFuture = Channels.future((Channel)ctx.getChannel());
            if (response.getDataInputStream() != null) {
                writeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        InputStream input = response.getDataInputStream();
                        final ChunkedDataStream dataStream = new ChunkedDataStream(new PushbackInputStream(input));
                        ChannelFuture bodyWriteFuture = Channels.future((Channel)future.getChannel());
                        bodyWriteFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                dataStream.close();
                                Contexts.clear((String)response.getCorrelationId());
                                ChannelFutureListener.CLOSE.operationComplete(future);
                            }
                        });
                        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)bodyWriteFuture, (Object)dataStream);
                    }
                });
            } else {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)httpResponse);
        }
    }

    protected DefaultHttpResponse createHttpResponse(ObjectStorageDataGetResponseType reply) {
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        long contentLength = reply.getSize();
        String contentType = reply.getContentType();
        String etag = reply.getEtag();
        String contentDisposition = reply.getContentDisposition();
        httpResponse.addHeader("Content-Type", (Object)(contentType != null ? contentType : "binary/octet-stream"));
        if (etag != null) {
            httpResponse.addHeader("ETag", (Object)("\"" + etag + "\""));
        }
        httpResponse.addHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)reply.getLastModified()));
        if (contentDisposition != null) {
            httpResponse.addHeader("Content-Disposition", (Object)contentDisposition);
        }
        httpResponse.addHeader("Content-Length", (Object)String.valueOf(contentLength));
        String versionId = reply.getVersionId();
        if (versionId != null && !"null".equals(versionId)) {
            httpResponse.addHeader("x-amz-version-id", (Object)versionId);
        }
        httpResponse.setHeader("Date", (Object)DateFormatter.dateToHeaderFormattedString((Date)new Date()));
        for (MetaDataEntry m : reply.getMetaData()) {
            httpResponse.addHeader("x-amz-meta-" + m.getName(), (Object)m.getValue());
        }
        OSGUtil.addCopiedHeadersToResponse((HttpResponse)httpResponse, (ObjectStorageDataResponseType)reply);
        if (reply.getByteRangeEnd() != null) {
            httpResponse.addHeader("Content-Range", (Object)(reply.getByteRangeStart() + "-" + reply.getByteRangeEnd() + "/" + reply.getSize()));
        }
        this.overrideHeaders((ObjectStorageDataResponseType)reply, httpResponse);
        return httpResponse;
    }

    private void overrideHeaders(ObjectStorageDataResponseType response, DefaultHttpResponse httpResponse) {
        Map overrides = response.getResponseHeaderOverrides();
        if (overrides == null || overrides.size() == 0) {
            return;
        }
        for (ObjectStorageProperties.ResponseHeaderOverrides elem : ObjectStorageProperties.ResponseHeaderOverrides.values()) {
            String elemString = elem.toString();
            if (!overrides.containsKey(elemString)) continue;
            httpResponse.setHeader((String)ObjectStorageProperties.RESPONSE_OVERRIDE_HTTP_HEADER_MAP.get(elemString), overrides.get(elemString));
        }
    }
}

