/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidAccessKeyIdException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidPolicyDocumentException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.exceptions.s3.SignatureDoesNotMatchException;
import com.eucalyptus.objectstorage.pipeline.auth.ObjectStorageWrappedCredentials;
import com.eucalyptus.objectstorage.pipeline.handlers.UploadPolicyChecker;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.base.Strings;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageFormPOSTAuthenticationHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(ObjectStorageFormPOSTAuthenticationHandler.class);

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        LOG.trace((Object)(((Object)((Object)this)).getClass().getSimpleName() + "[incoming]: " + channelEvent));
        try {
            if (channelEvent instanceof MessageEvent) {
                MessageEvent msgEvent = (MessageEvent)channelEvent;
                this.incomingMessage(channelHandlerContext, msgEvent);
            }
            channelHandlerContext.sendUpstream(channelEvent);
        }
        catch (S3Exception e) {
            LOG.trace((Object)"Caught exception in POST form authentication.", (Throwable)e);
            Channels.fireExceptionCaught((ChannelHandlerContext)channelHandlerContext, (Throwable)e);
        }
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            UploadPolicyChecker.checkPolicy(httpRequest.getFormFields());
            this.handle(httpRequest);
        }
    }

    public void handle(MappingHttpRequest httpRequest) throws S3Exception {
        String accessKey = (String)httpRequest.getFormFields().get(ObjectStorageProperties.FormField.AWSAccessKeyId.toString());
        String signature = (String)httpRequest.getFormFields().get(ObjectStorageProperties.FormField.Signature.toString());
        String policy = (String)httpRequest.getFormFields().get(ObjectStorageProperties.FormField.Policy.toString());
        String securityToken = (String)httpRequest.getFormFields().get(ObjectStorageProperties.FormField.x_amz_security_token.toString());
        if (!Strings.isNullOrEmpty((String)policy)) {
            if (Strings.isNullOrEmpty((String)signature)) {
                throw new InvalidPolicyDocumentException(httpRequest.getUri(), "Policy specified, but no signature field found.");
            }
            if (Strings.isNullOrEmpty((String)accessKey)) {
                throw new InvalidPolicyDocumentException(httpRequest.getUri(), "Policy specified, but no AWSAccessKeyId field found");
            }
            try {
                SecurityContext.getLoginContext((WrappedCredentials)new ObjectStorageWrappedCredentials(httpRequest.getCorrelationId(), policy, accessKey, signature, securityToken)).login();
            }
            catch (LoginException ex) {
                if (ex.getMessage().contains("The AWS Access Key Id you provided does not exist in our records")) {
                    throw new InvalidAccessKeyIdException(accessKey);
                }
                LOG.debug((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Authentication failed due to signature mismatch:"), (Throwable)ex);
                throw new SignatureDoesNotMatchException(signature);
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + httpRequest.getCorrelationId() + " Unexpected failure trying to authenticate request"), (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
        }
        try {
            Context ctx = Contexts.lookup((String)httpRequest.getCorrelationId());
            ctx.setUser(Principals.nobodyUser());
        }
        catch (NoSuchContextException e) {
            LOG.error((Object)"Could not find context for anonymous request. Returning internal error.", (Throwable)e);
            throw new InternalErrorException(httpRequest.getUri(), (Throwable)e);
        }
    }
}

