/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.msgs.ObjectStorageErrorMessageType;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

public abstract class ObjectStorageBasicOutboundHandler
extends MessageStackHandler {
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        this.handleBasicOutgoingMessage(ctx, event);
    }

    protected void handleBasicOutgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            ExceptionResponseType errorMessage;
            BaseMessage errMsg;
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            if (msg instanceof EucalyptusErrorMessageType) {
                EucalyptusErrorMessageType errorMessage2 = (EucalyptusErrorMessageType)msg;
                BaseMessage errMsg2 = OSGUtil.convertErrorMessage((EucalyptusErrorMessageType)errorMessage2);
                if (errMsg2 instanceof ObjectStorageErrorMessageType) {
                    ObjectStorageErrorMessageType walrusErrorMsg = (ObjectStorageErrorMessageType)errMsg2;
                    httpResponse.setStatus(walrusErrorMsg.getStatus());
                }
                httpResponse.setMessage((Object)errMsg2);
            } else if (msg instanceof ExceptionResponseType && (errMsg = OSGUtil.convertErrorMessage((ExceptionResponseType)(errorMessage = (ExceptionResponseType)msg))) instanceof ObjectStorageErrorMessageType) {
                ObjectStorageErrorMessageType walrusErrorMsg = (ObjectStorageErrorMessageType)errMsg;
                httpResponse.setStatus(walrusErrorMsg.getStatus());
            }
        }
    }
}

