/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.objectstorage.exceptions.s3.MissingSecurityHeaderException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.pipeline.handlers.S3Authentication;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.server.MessageStatistics;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

@ChannelPipelineCoverage(value="one")
public class ObjectStorageAuthenticationHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(ObjectStorageAuthenticationHandler.class);
    private static final String AWS_AUTH_TYPE = "AWS";
    protected static final String ISO_8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";

    private static void canonicalizeHeaders(MappingHttpRequest httpRequest) {
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        Object value = null;
        for (String header : httpRequest.getHeaderNames()) {
            headerMap.put(header, Joiner.on((char)',').join((Iterable)httpRequest.getHeaders(header)));
        }
        httpRequest.clearHeaders();
        for (String foundHeader : headerMap.keySet()) {
            httpRequest.addHeader(foundHeader, headerMap.get(foundHeader));
        }
    }

    private static void removeDuplicateHeaderValues(MappingHttpRequest httpRequest) {
        List hdrList = null;
        HashMap<String, List> fixedHeaders = new HashMap<String, List>();
        boolean foundDup = false;
        for (String string : httpRequest.getHeaderNames()) {
            hdrList = httpRequest.getHeaders(string);
            if (hdrList != null && hdrList.size() == 2 && ((String)hdrList.get(0)).equals(hdrList.get(1))) {
                foundDup = true;
                fixedHeaders.put(string, Lists.newArrayList((Object[])new String[]{(String)hdrList.get(0)}));
                continue;
            }
            fixedHeaders.put(string, hdrList);
        }
        if (foundDup) {
            LOG.debug((Object)("Found duplicate headers in: " + httpRequest.logMessage()));
            httpRequest.clearHeaders();
            for (Map.Entry entry : fixedHeaders.entrySet()) {
                for (String v : (List)entry.getValue()) {
                    httpRequest.addHeader((String)entry.getKey(), (Object)v);
                }
            }
        }
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            ObjectStorageAuthenticationHandler.removeDuplicateHeaderValues(httpRequest);
            ObjectStorageAuthenticationHandler.canonicalizeHeaders(httpRequest);
            this.handle(httpRequest);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        if (channelEvent instanceof MessageEvent) {
            try {
                MessageEvent msgEvent = (MessageEvent)channelEvent;
                Callable stat = MessageStatistics.startUpstream((Channel)ctx.getChannel(), (ChannelHandler)this);
                this.incomingMessage(ctx, msgEvent);
                stat.call();
                ctx.sendUpstream(channelEvent);
            }
            catch (Throwable e) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
            }
        } else {
            ctx.sendUpstream(channelEvent);
        }
    }

    public static Map<S3Authentication.AuthorizationField, String> processAuthorizationHeader(String authorization) throws AccessDeniedException {
        if (Strings.isNullOrEmpty((String)authorization)) {
            return null;
        }
        HashMap<S3Authentication.AuthorizationField, String> authMap = new HashMap<S3Authentication.AuthorizationField, String>();
        String[] components = authorization.split(" ");
        if (components.length < 2) {
            throw new AccessDeniedException("Invalid authorization header");
        }
        if (!AWS_AUTH_TYPE.equals(components[0]) || components.length != 2) {
            throw new AccessDeniedException("Invalid authorization header");
        }
        authMap.put(S3Authentication.AuthorizationField.Type, AWS_AUTH_TYPE);
        String[] signatureElements = components[1].split(":");
        authMap.put(S3Authentication.AuthorizationField.AccessKeyId, signatureElements[0]);
        authMap.put(S3Authentication.AuthorizationField.Signature, signatureElements[1]);
        return authMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(MappingHttpRequest httpRequest) throws S3Exception {
        Map parameters = httpRequest.getParameters();
        if (httpRequest.containsHeader(S3Authentication.SecurityParameter.Authorization.toString())) {
            String authHeader = httpRequest.getAndRemoveHeader(S3Authentication.SecurityParameter.Authorization.toString());
            Map<S3Authentication.AuthorizationField, String> authMap = ObjectStorageAuthenticationHandler.processAuthorizationHeader(authHeader);
            if (!AWS_AUTH_TYPE.equals(authMap.get((Object)S3Authentication.AuthorizationField.Type))) throw new MissingSecurityHeaderException("Malformed or unexpected format for Authentication header");
            S3Authentication.authenticateVersion2(httpRequest, authMap);
            return;
        }
        if (parameters.containsKey(S3Authentication.SecurityParameter.AWSAccessKeyId.toString())) {
            S3Authentication.authenticateQueryString(httpRequest);
            return;
        }
        try {
            Context ctx = Contexts.lookup((String)httpRequest.getCorrelationId());
            ctx.setUser(Principals.nobodyUser());
            return;
        }
        catch (NoSuchContextException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AccessDeniedException();
        }
    }
}

