/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.objectstorage.exceptions.s3.MalformedPOSTRequestException;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.records.Logs;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;

public class MultipartFormPartParser {
    private static Logger LOG = Logger.getLogger(MultipartFormPartParser.class);
    protected static final byte[] PART_HEADER_BOUNDARY_BYTES = new byte[]{13, 10, 13, 10};
    protected static final byte[] PART_LINE_DELIMITER_BYTES = new byte[]{13, 10};
    protected static final String PART_HEADER_BOUNDARY = "\r\n\r\n";
    protected static final String PART_LINE_DELIMITER = "\r\n";

    public static Map<String, Object> parseForm(String msgContentTypeHeader, long requestContentLength, ChannelBuffer content) throws Exception {
        HashMap formFields = Maps.newHashMap();
        String boundaryStr = MultipartFormPartParser.getFormBoundary(msgContentTypeHeader);
        byte[] boundaryBytes = (boundaryStr + PART_LINE_DELIMITER).getBytes("UTF-8");
        byte[] finalBoundaryBytes = (boundaryStr + "--" + PART_LINE_DELIMITER).getBytes("UTF-8");
        formFields.put(ObjectStorageProperties.FormField.x_ignore_formboundary.toString(), boundaryBytes);
        MultipartFormPartParser.processFormParts(boundaryBytes, finalBoundaryBytes, formFields, content, requestContentLength);
        return formFields;
    }

    protected static String getFormBoundary(String contentTypeHeader) throws Exception {
        if (contentTypeHeader.startsWith("multipart/form-data")) {
            String boundary = MultipartFormPartParser.getFormFieldKeyName(contentTypeHeader, "boundary");
            boundary = "--" + boundary;
            return boundary;
        }
        throw new MalformedPOSTRequestException("Content-Type not multipart/form-data");
    }

    protected static void processFormParts(byte[] boundaryBytes, byte[] finalBoundaryBytes, Map formFields, ChannelBuffer buffer, long fullContentLength) throws Exception {
        PartIterator iter = new PartIterator(boundaryBytes, finalBoundaryBytes, buffer);
        int offset = 0;
        while (iter.hasNext()) {
            ChannelBuffer partSlice = iter.next();
            partSlice.markReaderIndex();
            if (partSlice.readableBytes() > boundaryBytes.length) {
                int headerEnd = OSGUtil.findFirstMatchInBuffer((ChannelBuffer)partSlice, (int)0, (byte[])PART_HEADER_BOUNDARY_BYTES);
                if (headerEnd == -1) {
                    throw new MalformedPOSTRequestException("Invalid form part starting at byte offset: " + offset);
                }
                String partHeader = MultipartFormPartParser.getMessageString(partSlice.slice(0, headerEnd += PART_HEADER_BOUNDARY_BYTES.length)).trim();
                Map<String, String> keyMap = MultipartFormPartParser.parseFormPartHeaders(partHeader);
                String key = keyMap.get("name");
                if (Strings.isNullOrEmpty((String)key)) {
                    throw new MalformedPOSTRequestException("Invalid part name null: " + partHeader);
                }
                if (ObjectStorageProperties.FormField.file.toString().equals(key)) {
                    formFields.put(key, keyMap.get("filename"));
                    String contentType = keyMap.get("Content-Type");
                    formFields.put(ObjectStorageProperties.FormField.Content_Type.toString(), contentType);
                    MultipartFormPartParser.getFirstChunk(formFields, partSlice, offset, fullContentLength, boundaryBytes, finalBoundaryBytes);
                } else {
                    formFields.put(key, MultipartFormPartParser.getMessageString(partSlice.slice(headerEnd, partSlice.readableBytes() - headerEnd - boundaryBytes.length)).trim());
                }
            }
            partSlice.resetReaderIndex();
            offset += partSlice.readableBytes();
        }
    }

    protected static void getFirstChunk(Map formFields, ChannelBuffer buffer, int startingOffset, long contentLength, byte[] boundary, byte[] finalBoundary) throws Exception {
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        int index = MultipartFormPartParser.getLastIndex(read, PART_HEADER_BOUNDARY_BYTES);
        if (index > -1) {
            int firstIndex = index + 1;
            long fileContentLength = contentLength - (long)startingOffset - (long)firstIndex - (long)finalBoundary.length - (long)PART_LINE_DELIMITER_BYTES.length;
            int lastIndex = (int)((long)firstIndex + fileContentLength);
            if (lastIndex > read.length) {
                lastIndex = read.length;
            } else {
                index = MultipartFormPartParser.getFirstIndex(read, firstIndex, finalBoundary);
                if (index < 0) {
                    index = MultipartFormPartParser.getFirstIndex(read, firstIndex, boundary);
                }
                if (index > firstIndex) {
                    lastIndex = index - PART_LINE_DELIMITER_BYTES.length;
                    fileContentLength = lastIndex - firstIndex;
                }
            }
            ChannelBuffer firstBuffer = buffer.slice(firstIndex, lastIndex - firstIndex);
            Logs.extreme().debug((Object)("Setting first buffer chunk with size: " + firstBuffer.readableBytes()));
            formFields.put(ObjectStorageProperties.FormField.x_ignore_firstdatachunk.toString(), firstBuffer);
            formFields.put(ObjectStorageProperties.FormField.x_ignore_filecontentlength.toString(), fileContentLength);
        }
        buffer.resetReaderIndex();
    }

    protected static Map<String, String> getFormField(String message, String key) throws Exception {
        HashMap<String, String> keymap = new HashMap<String, String>();
        String[] parts = message.split(";");
        if (parts.length >= 2 && parts[1].contains(key)) {
            String keystring = parts[1].substring(parts[1].indexOf(61) + 1);
            if (parts.length == 2) {
                String[] keyparts = keystring.split(PART_HEADER_BOUNDARY);
                String keyName = keyparts[0];
                keyName = keyName.replaceAll("\"", "");
                String value = keyparts[1].replaceAll(PART_LINE_DELIMITER, "");
                keymap.put(keyName, value);
            } else {
                String keyName = keystring.trim();
                keyName = keyName.replaceAll("\"", "");
                String valuestring = parts[2].substring(parts[2].indexOf(61) + 1, parts[2].indexOf(PART_LINE_DELIMITER)).trim();
                String value = valuestring.replaceAll("\"", "");
                keymap.put(keyName, value);
            }
        }
        return keymap;
    }

    protected static Map<String, String> parseFormPartHeaders(String fieldHeaderLine) throws MalformedPOSTRequestException {
        if (!fieldHeaderLine.startsWith("Content-Disposition")) {
            throw new MalformedPOSTRequestException("Invalid form encoding on line: " + fieldHeaderLine);
        }
        HashMap headers = Maps.newHashMap();
        String[] lines = fieldHeaderLine.split(PART_LINE_DELIMITER);
        if (lines.length > 0) {
            for (String line : lines) {
                String[] values;
                line = line.trim();
                for (String value : values = line.split(";")) {
                    String[] params = (value = value.trim()).split("=");
                    if (params.length == 2) {
                        headers.put(params[0].trim(), params[1].trim().replaceAll("\"", ""));
                        continue;
                    }
                    params = value.split(":");
                    if (params.length == 2) {
                        headers.put(params[0].trim(), params[1].trim());
                        continue;
                    }
                    throw new MalformedPOSTRequestException("Unexpected form field content: " + value);
                }
            }
        }
        return headers;
    }

    protected static String getFormFieldKeyName(String message, String key) throws Exception {
        String[] parts = message.split(";");
        if (parts.length > 1 && parts[1].contains(key + "=")) {
            String[] keyparts = parts[1].split("=", 2);
            if (keyparts.length < 2) {
                throw new MalformedPOSTRequestException("Invalid form field entry: " + parts[1].substring(0, Math.min(128, parts[1].length())));
            }
            return keyparts[1].replaceAll("\"", "").trim();
        }
        throw new MalformedPOSTRequestException("Invalid form field entry: " + message.substring(0, Math.min(128, message.length())));
    }

    protected static String getMessageString(ChannelBuffer buffer) throws UnsupportedEncodingException {
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        buffer.resetReaderIndex();
        return new String(read, "UTF-8");
    }

    protected static int getFirstIndex(byte[] bytes, int sourceIndex, byte[] bytesToCompare) {
        int firstIndex = -1;
        if (bytes.length - sourceIndex < bytesToCompare.length) {
            return firstIndex;
        }
        for (int i = sourceIndex; i < bytes.length; ++i) {
            for (int j = 0; j < bytesToCompare.length && i + j < bytes.length; ++j) {
                if (bytes[i + j] != bytesToCompare[j]) {
                    firstIndex = -1;
                    break;
                }
                firstIndex = i;
            }
            if (firstIndex == -1) continue;
            return firstIndex;
        }
        return firstIndex;
    }

    protected static int getLastIndex(byte[] bytes, byte[] bytesToCompare) {
        int lastIndex = -1;
        if (bytes.length < bytesToCompare.length) {
            return lastIndex;
        }
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = 0; j < bytesToCompare.length && i + j < bytes.length; ++j) {
                if (bytes[i + j] != bytesToCompare[j]) {
                    lastIndex = -1;
                    break;
                }
                lastIndex = i + j;
            }
            if (lastIndex == -1) continue;
            return lastIndex;
        }
        return lastIndex;
    }

    static class PartIterator
    implements Iterator<ChannelBuffer> {
        byte[] boundary;
        byte[] finalBoundary;
        ChannelBuffer buffer;
        int currentIndex;
        int totalSize;

        public PartIterator(byte[] boundaryBytes, byte[] finalBoundaryBytes, ChannelBuffer content) {
            this.boundary = boundaryBytes;
            this.finalBoundary = finalBoundaryBytes;
            this.buffer = content;
            this.currentIndex = 0;
            this.totalSize = content.readableBytes();
        }

        @Override
        public boolean hasNext() {
            return this.nextPartLength() > 0;
        }

        private int nextPartLength() {
            int nextFound = OSGUtil.findFirstMatchInBuffer((ChannelBuffer)this.buffer, (int)this.currentIndex, (byte[])this.boundary) + this.boundary.length;
            if (nextFound < this.boundary.length && (nextFound = OSGUtil.findFirstMatchInBuffer((ChannelBuffer)this.buffer, (int)this.currentIndex, (byte[])this.finalBoundary) + this.finalBoundary.length) < this.finalBoundary.length) {
                nextFound = -1;
            }
            if (nextFound > 0) {
                return nextFound - this.currentIndex;
            }
            return this.totalSize - this.currentIndex;
        }

        @Override
        public ChannelBuffer next() {
            int partLength = this.nextPartLength();
            if (partLength > 0) {
                ChannelBuffer slice = this.buffer.slice(this.currentIndex, partLength);
                this.currentIndex += partLength;
                return slice;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

