/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.exceptions.s3.MissingContentLengthException;
import com.google.common.base.Strings;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;

public class HttpThresholdBufferingAggregator {
    private static Logger LOG = Logger.getLogger(HttpThresholdBufferingAggregator.class);
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private int maxBufferingSize;
    private volatile AggregatedMessageEvent currentEvent;

    public HttpThresholdBufferingAggregator() {
        this.maxBufferingSize = 131072;
    }

    public HttpThresholdBufferingAggregator(int bufferSize) {
        this.maxBufferingSize = bufferSize;
    }

    public AggregatedMessageEvent poll() {
        if (this.currentEvent != null && (this.currentEvent.isLastReceived() || this.currentEvent.getCurrentAggregatedSize() >= (long)this.maxBufferingSize)) {
            LOG.trace((Object)("Poll returning event: " + this.currentEvent.toString() + " data: " + this.currentEvent.getAggregatedContentBuffer().toString()));
            return this.currentEvent;
        }
        LOG.trace((Object)"Poll returning null");
        return null;
    }

    public void hardReset() {
        LOG.trace((Object)"HardReset invoked");
        this.currentEvent = null;
    }

    public boolean offer(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest && this.currentEvent == null) {
            return this.offerRequest(event);
        }
        if (event.getMessage() instanceof DefaultHttpChunk && this.currentEvent != null) {
            return this.offerChunk((DefaultHttpChunk)event.getMessage());
        }
        return false;
    }

    protected boolean offerRequest(MessageEvent event) throws Exception {
        if (!(event.getMessage() instanceof MappingHttpRequest) || this.currentEvent != null) {
            return false;
        }
        MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
        if (Strings.isNullOrEmpty((String)httpRequest.getHeader("Content-Length"))) {
            throw new MissingContentLengthException();
        }
        try {
            long l = Long.parseLong(httpRequest.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Client specified content-length in invalid format, not a integer", (Throwable)e);
            throw new MissingContentLengthException("Content-Length not valid integer");
        }
        if (this.currentEvent == null && httpRequest.isChunked() && httpRequest.getContent().readableBytes() < this.maxBufferingSize) {
            this.currentEvent = new AggregatedMessageEvent(event, httpRequest.getContent());
            return true;
        }
        return false;
    }

    protected boolean offerChunk(DefaultHttpChunk httpChunk) throws Exception {
        if (this.currentEvent == null || this.currentEvent.getCurrentAggregatedSize() > (long)this.maxBufferingSize) {
            return false;
        }
        this.currentEvent.addContentBuffer(httpChunk.getContent(), httpChunk.isLast());
        return true;
    }

    public static class AggregatedMessageEvent {
        private MessageEvent messageEvent;
        private ArrayList<ChannelBuffer> contentBuffers;
        private boolean lastReceived;

        public AggregatedMessageEvent(MessageEvent initial, ChannelBuffer initialContent) {
            this.messageEvent = initial;
            this.lastReceived = false;
            this.contentBuffers = new ArrayList(3);
            this.contentBuffers.add(initialContent);
        }

        public MessageEvent getMessageEvent() {
            return this.messageEvent;
        }

        public ChannelBuffer getAggregatedContentBuffer() {
            return ChannelBuffers.copiedBuffer((ChannelBuffer[])this.contentBuffers.toArray(new ChannelBuffer[this.contentBuffers.size()]));
        }

        public void addContentBuffer(ChannelBuffer nextContentBuffer, boolean isLast) {
            this.contentBuffers.add(nextContentBuffer);
            this.lastReceived = isLast;
        }

        public int getAggregationCount() {
            return this.contentBuffers.size();
        }

        public long getCurrentAggregatedSize() {
            long size = 0L;
            for (ChannelBuffer b : this.contentBuffers) {
                size += (long)b.readableBytes();
            }
            return size;
        }

        public boolean isLastReceived() {
            return this.lastReceived;
        }
    }
}

