/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.MissingContentLengthException;
import com.eucalyptus.objectstorage.pipeline.handlers.HttpThresholdBufferingAggregator;
import com.eucalyptus.objectstorage.pipeline.handlers.MultipartFormPartParser;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

@ChannelPipelineCoverage(value="one")
public class FormPOSTMultipartDecoder
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(FormPOSTMultipartDecoder.class);
    private static final int S3_FORM_BUFFER_SIZE = 25600;
    private HttpThresholdBufferingAggregator aggregator = new HttpThresholdBufferingAggregator(25600);

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        LOG.trace((Object)LogUtil.dumpObject((Object)channelEvent));
        try {
            if (channelEvent instanceof MessageEvent) {
                MessageEvent msgEvent = (MessageEvent)channelEvent;
                this.incomingMessage(channelHandlerContext, msgEvent);
            } else {
                channelHandlerContext.sendUpstream(channelEvent);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Caught exception in POST form authentication.", (Throwable)e);
            Channels.fireExceptionCaught((ChannelHandlerContext)channelHandlerContext, (Throwable)e);
        }
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        MappingHttpRequest upstreamRequest = null;
        ChannelBuffer content = null;
        MessageEvent upstreamEvent = event;
        if (this.aggregator.offer(event)) {
            HttpThresholdBufferingAggregator.AggregatedMessageEvent result = this.aggregator.poll();
            if (result == null) {
                return;
            }
            this.aggregator.hardReset();
            if (result.getMessageEvent() == null || result.getMessageEvent().getMessage() == null) {
                throw new InternalErrorException("Unexpected state in message stack");
            }
            upstreamRequest = (MappingHttpRequest)result.getMessageEvent().getMessage();
            content = result.getAggregatedContentBuffer();
            upstreamEvent = result.getMessageEvent();
        } else if (event.getMessage() instanceof MappingHttpRequest) {
            upstreamRequest = (MappingHttpRequest)event.getMessage();
            content = upstreamRequest.getContent();
        }
        if (upstreamRequest != null && content != null) {
            this.handleFormMessage(upstreamRequest, content);
        }
        ctx.sendUpstream((ChannelEvent)upstreamEvent);
    }

    protected void handleFormMessage(MappingHttpRequest httpRequest, ChannelBuffer contentBuffer) throws Exception {
        long contentLength;
        Map formFields = httpRequest.getFormFields();
        try {
            contentLength = Long.parseLong(httpRequest.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            throw new MissingContentLengthException(httpRequest.getHeader("Content-Length"));
        }
        formFields.put(ObjectStorageProperties.FormField.bucket.toString(), FormPOSTMultipartDecoder.getBucketName(httpRequest));
        formFields.putAll(MultipartFormPartParser.parseForm(httpRequest.getHeader("Content-Type"), contentLength, contentBuffer));
    }

    protected static String getBucketName(MappingHttpRequest httpRequest) {
        String operationPath = httpRequest.getServicePath().replaceFirst(((ObjectStorage)ComponentIds.lookup(ObjectStorage.class)).getServicePath(new String[0]).toLowerCase(), "");
        String[] target = OSGUtil.getTarget((String)operationPath);
        String bucket = null;
        bucket = target != null && target.length >= 1 ? target[0] : httpRequest.getHeader("Host").split(".objectstorage", 2)[0];
        return bucket;
    }
}

