/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.handlers;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedPOSTRequestException;
import com.eucalyptus.objectstorage.pipeline.handlers.MultipartFormPartParser;
import com.eucalyptus.objectstorage.pipeline.handlers.ObjectStoragePUTAggregator;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.LogUtil;
import com.google.common.primitives.Bytes;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

public class FormPOSTFilteringAggregator
extends ObjectStoragePUTAggregator {
    private static final Logger LOG = Logger.getLogger(FormPOSTFilteringAggregator.class);
    private byte[] boundaryBytes;
    private OSGUtil.ByteMatcherBeginningIndexFinder boundaryFinder;
    private long bytesSent;
    private ChannelBuffer lastBufferedChunk;
    private int trailingBytesFound = 0;
    private boolean truncateRemaining;

    protected void setupBoundary(byte[] boundary) throws Exception {
        Logs.extreme().debug((Object)("Initialized boundary for form field filtering: '" + new String(boundary) + "'"));
        this.boundaryBytes = Bytes.concat((byte[][])new byte[][]{MultipartFormPartParser.PART_LINE_DELIMITER_BYTES, boundary});
        this.truncateRemaining = false;
        this.boundaryFinder = new OSGUtil.ByteMatcherBeginningIndexFinder(this.boundaryBytes);
        this.bytesSent = 0L;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        Logs.extreme().debug((Object)LogUtil.dumpObject((Object)event));
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            byte[] boundary = (byte[])httpRequest.getFormFields().get(ObjectStorageProperties.FormField.x_ignore_formboundary.toString());
            if (boundary == null) {
                LOG.error((Object)"No boundary found in the form. Cannot filter content. Failing POST form upload");
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new InternalErrorException("Error processing POST form content"));
                return;
            }
            this.setupBoundary(boundary);
        }
        Logs.extreme().debug((Object)"Sending event to PUT aggregator");
        super.messageReceived(ctx, event);
    }

    protected ChannelBuffer scanForFormBoundary(ChannelBuffer data) throws Exception {
        if (this.truncateRemaining) {
            this.trailingBytesFound += data.readableBytes();
            return ChannelBuffers.wrappedBuffer((byte[])new byte[0]);
        }
        ChannelBuffer dataToScan = data;
        if (this.lastBufferedChunk != null) {
            dataToScan = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this.lastBufferedChunk, data});
        }
        int lfIndex = 0;
        int endOffset = -1;
        int bufferSize = dataToScan.readableBytes();
        do {
            if ((lfIndex = dataToScan.indexOf(lfIndex, dataToScan.readableBytes(), ChannelBufferIndexFinder.CR)) >= 0) {
                if (lfIndex + this.boundaryBytes.length > bufferSize) {
                    this.lastBufferedChunk = dataToScan.copy(lfIndex, bufferSize - lfIndex);
                    endOffset = lfIndex;
                    continue;
                }
                endOffset = dataToScan.indexOf(lfIndex, lfIndex + this.boundaryBytes.length, (ChannelBufferIndexFinder)this.boundaryFinder);
                if (endOffset >= lfIndex) {
                    this.lastBufferedChunk = null;
                    this.truncateRemaining = true;
                    this.trailingBytesFound = bufferSize - endOffset;
                    if (this.trailingBytesFound <= this.boundaryBytes.length + 4) continue;
                    this.lastBufferedChunk = null;
                    throw new MalformedPOSTRequestException("Must not have any trailing form parts after file content");
                }
                ++lfIndex;
                endOffset = -1;
                continue;
            }
            this.lastBufferedChunk = null;
            endOffset = bufferSize;
        } while (endOffset < 0);
        if (endOffset == 0) {
            return ChannelBuffers.wrappedBuffer((byte[])new byte[0]);
        }
        if (endOffset == -1 || endOffset == dataToScan.readableBytes()) {
            return dataToScan;
        }
        return ChannelBuffers.copiedBuffer((ChannelBuffer)dataToScan.slice(0, endOffset));
    }

    @Override
    protected void appendChunk(ChannelBuffer input, Channel channel) throws Exception {
        ChannelBuffer data = this.scanForFormBoundary(input);
        this.bytesSent += (long)data.readableBytes();
        super.appendChunk(data, channel);
    }
}

