/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.binding;

import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.binding.HttpEmbedded;
import com.eucalyptus.binding.HttpParameterMapping;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.objectstorage.ObjectStorageBucketLogger;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidArgumentException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidTagErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedACLErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedPOSTRequestException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedXMLException;
import com.eucalyptus.objectstorage.exceptions.s3.MethodNotAllowedException;
import com.eucalyptus.objectstorage.exceptions.s3.NotImplementedException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataGetRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.pipeline.ObjectStorageRESTPipeline;
import com.eucalyptus.objectstorage.pipeline.handlers.S3Authentication;
import com.eucalyptus.objectstorage.util.AclUtils;
import com.eucalyptus.objectstorage.util.OSGUtil;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.records.Logs;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.BucketTag;
import com.eucalyptus.storage.msgs.s3.BucketTagSet;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Expiration;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.storage.msgs.s3.LifecycleConfiguration;
import com.eucalyptus.storage.msgs.s3.LifecycleRule;
import com.eucalyptus.storage.msgs.s3.LoggingEnabled;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.storage.msgs.s3.Part;
import com.eucalyptus.storage.msgs.s3.TaggingConfiguration;
import com.eucalyptus.storage.msgs.s3.TargetGrants;
import com.eucalyptus.storage.msgs.s3.Transition;
import com.eucalyptus.util.ChannelBufferStreamingInputStream;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.XMLParser;
import com.eucalyptus.ws.handlers.RestfulMarshallingHandler;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import groovy.lang.GroovyObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.w3c.dom.Node;

public abstract class ObjectStorageRESTBinding
extends RestfulMarshallingHandler {
    protected static Logger LOG = Logger.getLogger(ObjectStorageRESTBinding.class);
    protected static final String SERVICE = "service";
    protected static final String BUCKET = "bucket";
    protected static final String OBJECT = "object";
    protected Map<String, String> operationMap;
    protected Map<String, String> unsupportedOperationMap;
    protected String key;
    private static final Ordering<String> STRING_COMPARATOR = Ordering.natural();
    protected List<String> responseHeadersForStoring = Collections.unmodifiableList(STRING_COMPARATOR.sortedCopy((Iterable)Lists.newArrayList((Object[])new String[]{"Cache-Control", "Content-Disposition", "Content-Encoding", "Content-Length", "Content-Type", "Expires"})));

    public ObjectStorageRESTBinding() {
        super("http://s3.amazonaws.com/doc/2006-03-01");
        this.operationMap = this.populateOperationMap();
        this.unsupportedOperationMap = this.populateUnsupportedOperationMap();
    }

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        if (Logs.isExtrrreeeme()) {
            Logs.extreme().trace((Object)LogUtil.dumpObject((Object)channelEvent));
        }
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            try {
                this.incomingMessage(channelHandlerContext, msgEvent);
            }
            catch (Exception e) {
                Logs.extreme().trace((Object)"Error binding request", (Throwable)e);
                Channels.fireExceptionCaught((ChannelHandlerContext)channelHandlerContext, (Throwable)e);
                return;
            }
        }
        channelHandlerContext.sendUpstream(channelEvent);
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            BaseMessage msg = (BaseMessage)this.bind(httpRequest);
            httpRequest.setMessage((Object)msg);
            if (msg instanceof ObjectStorageDataGetRequestType) {
                ObjectStorageDataGetRequestType getObject = (ObjectStorageDataGetRequestType)msg;
                getObject.setChannel(ctx.getChannel());
            }
            if (msg instanceof ObjectStorageDataRequestType) {
                ObjectStorageDataRequestType request;
                String expect = httpRequest.getHeader("Expect");
                if (expect != null && expect.toLowerCase().equals("100-continue")) {
                    request = (ObjectStorageDataRequestType)msg;
                    request.setExpectHeader(true);
                }
                request = (ObjectStorageDataRequestType)msg;
                request.setIsChunked(httpRequest.isChunked());
                this.handleData(request, httpRequest.getContent());
            }
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            Binding binding = !(msg instanceof EucalyptusErrorMessageType) && !(msg instanceof ExceptionResponseType) ? BindingManager.getBinding((String)super.getNamespace()) : BindingManager.getDefaultBinding();
            if (msg != null) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byteOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>".getBytes("UTF-8"));
                binding.toStream((OutputStream)byteOut, (Object)msg);
                byte[] req = byteOut.toByteArray();
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])req);
                httpResponse.setHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
                httpResponse.setHeader("Content-Type", (Object)"application/xml");
                httpResponse.setHeader("Date", (Object)DateFormatter.dateToHeaderFormattedString((Date)new Date()));
                httpResponse.setHeader("x-amz-request-id", (Object)msg.getCorrelationId());
                httpResponse.setContent(buffer);
            }
        }
    }

    public void handleData(ObjectStorageDataRequestType dataRequest, ChannelBuffer content) {
        ChannelBufferStreamingInputStream stream = new ChannelBufferStreamingInputStream(content);
        dataRequest.setData(stream);
    }

    protected abstract Map<String, String> populateOperationMap();

    protected abstract Map<String, String> populateUnsupportedOperationMap();

    public Object bind(MappingHttpRequest httpRequest) throws Exception {
        GroovyObject groovyMsg;
        Map<String, String> fieldMap;
        HashMap bindingArguments = new HashMap();
        String operationName = this.getOperation(httpRequest, bindingArguments);
        if (operationName == null) {
            throw new MethodNotAllowedException(httpRequest.getMethod().toString() + " " + httpRequest.getUri());
        }
        Map params = httpRequest.getParameters();
        try {
            Class<?> targetType = ClassLoader.getSystemClassLoader().loadClass("com.eucalyptus.objectstorage.msgs.".concat(operationName).concat("Type"));
            if (!GroovyObject.class.isAssignableFrom(targetType)) {
                throw new Exception();
            }
            fieldMap = this.buildFieldMap(targetType);
            groovyMsg = (GroovyObject)targetType.newInstance();
        }
        catch (Exception e) {
            throw new BindingException("Failed to construct message of type " + operationName);
        }
        this.addLogData((BaseMessage)groovyMsg, bindingArguments);
        List<String> failedMappings = this.populateObject(groovyMsg, fieldMap, params);
        this.populateObjectFromBindingMap(groovyMsg, fieldMap, httpRequest, bindingArguments);
        User user = Contexts.lookup((String)httpRequest.getCorrelationId()).getUser();
        this.setRequiredParams(groovyMsg, user);
        if (!params.isEmpty()) {
            params.clear();
        }
        if (!failedMappings.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Failed to bind the following fields:\n");
            for (String string : failedMappings) {
                errMsg.append(string).append('\n');
            }
            for (Map.Entry entry : params.entrySet()) {
                errMsg.append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append('\n');
            }
            throw new BindingException(errMsg.toString());
        }
        Logs.extreme().trace((Object)groovyMsg.toString());
        try {
            Binding binding = BindingManager.getDefaultBinding();
            OMElement msg = binding.toOM((Object)groovyMsg);
        }
        catch (RuntimeException e) {
            throw new BindingException("Failed to build a valid message: " + e.getMessage());
        }
        return groovyMsg;
    }

    protected void addLogData(BaseMessage eucaMsg, Map bindingArguments) {
        String operation;
        if (eucaMsg instanceof ObjectStorageRequestType && (operation = (String)bindingArguments.remove("Operation")) != null) {
            ObjectStorageRequestType request = (ObjectStorageRequestType)eucaMsg;
            BucketLogData logData = ObjectStorageBucketLogger.getInstance().makeLogEntry(UUID.randomUUID().toString());
            logData.setOperation("REST." + operation);
            request.setLogData(logData);
        }
    }

    protected void setRequiredParams(GroovyObject msg, User user) throws Exception {
        msg.setProperty("timeStamp", (Object)new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getOperation(MappingHttpRequest httpRequest, Map operationParams) throws Exception {
        String locationConstraint;
        String unsupportedOp;
        String bucket;
        String[] target = null;
        String path = this.getOperationPath(httpRequest);
        boolean objectstorageInternalOperation = false;
        String targetHost = httpRequest.getHeader("Host");
        if (targetHost.contains(".objectstorage")) {
            bucket = targetHost.substring(0, targetHost.indexOf(".objectstorage"));
            path = "/" + bucket + path;
        } else if (targetHost.contains(".walrus")) {
            bucket = targetHost.substring(0, targetHost.indexOf(".walrus"));
            path = "/" + bucket + path;
        }
        if (path.length() > 0) {
            target = OSGUtil.getTarget((String)path);
        }
        String verb = httpRequest.getMethod().getName();
        String operationKey = "";
        Map params = httpRequest.getParameters();
        String operationName = null;
        long contentLength = 0L;
        String contentLengthString = httpRequest.getHeader("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        if (target == null) {
            operationKey = SERVICE + verb;
        } else if (target.length == 1) {
            if (!target[0].equals("")) {
                operationKey = BUCKET + verb;
                operationParams.put("Bucket", target[0]);
                operationParams.put("Operation", verb.toUpperCase() + "." + "BUCKET");
                if (verb.equals(ObjectStorageProperties.HTTPVerb.POST.toString())) {
                    String successActionRedirect;
                    Map formFields = httpRequest.getFormFields();
                    String objectKey = null;
                    String file = (String)formFields.get(ObjectStorageProperties.FormField.file.toString());
                    if (formFields.containsKey(ObjectStorageProperties.FormField.key.toString())) {
                        objectKey = (String)formFields.get(ObjectStorageProperties.FormField.key.toString());
                        objectKey = objectKey.replaceAll("\\$\\{filename\\}", file);
                        operationParams.put("Key", objectKey);
                    }
                    if (formFields.containsKey(ObjectStorageProperties.FormField.acl.toString())) {
                        String acl = (String)formFields.get(ObjectStorageProperties.FormField.acl.toString());
                        httpRequest.addHeader("x-amz-acl", (Object)acl);
                    }
                    if (formFields.containsKey(ObjectStorageProperties.FormField.redirect.toString())) {
                        successActionRedirect = (String)formFields.get(ObjectStorageProperties.FormField.redirect.toString());
                        operationParams.put("SuccessActionRedirect", successActionRedirect);
                    }
                    if (formFields.containsKey(ObjectStorageProperties.FormField.success_action_redirect.toString())) {
                        successActionRedirect = (String)formFields.get(ObjectStorageProperties.FormField.success_action_redirect.toString());
                        operationParams.put("SuccessActionRedirect", successActionRedirect);
                    }
                    if (formFields.containsKey(ObjectStorageProperties.FormField.success_action_status.toString())) {
                        Integer successActionStatus = Integer.parseInt((String)formFields.get(ObjectStorageProperties.FormField.success_action_status.toString()));
                        if (successActionStatus == 200 || successActionStatus == 201) {
                            operationParams.put("SuccessActionStatus", successActionStatus);
                        } else {
                            operationParams.put("SuccessActionStatus", 204);
                        }
                    } else {
                        operationParams.put("SuccessActionStatus", 204);
                    }
                    if (formFields.get(ObjectStorageProperties.FormField.Content_Type.toString()) != null) {
                        operationParams.put("ContentType", formFields.get(ObjectStorageProperties.FormField.Content_Type.toString()));
                    }
                    if (formFields.get(ObjectStorageProperties.FormField.x_ignore_filecontentlength.toString()) == null) {
                        throw new MalformedPOSTRequestException("Could not calculate upload content length from request");
                    }
                    operationParams.put("ContentLength", Long.valueOf((Long)formFields.get(ObjectStorageProperties.FormField.x_ignore_filecontentlength.toString())));
                    this.key = target[0] + "." + objectKey;
                    ChannelBuffer buffer = (ChannelBuffer)formFields.get(ObjectStorageProperties.FormField.x_ignore_firstdatachunk.toString());
                    if (buffer == null) {
                        throw new MalformedPOSTRequestException("No upload content found");
                    }
                } else if (ObjectStorageProperties.HTTPVerb.PUT.toString().equals(verb)) {
                    if (params.containsKey(ObjectStorageProperties.BucketParameter.logging.toString())) {
                        this.getTargetBucketParams(operationParams, httpRequest);
                    } else if (params.containsKey(ObjectStorageProperties.BucketParameter.versioning.toString())) {
                        this.getVersioningStatus(operationParams, httpRequest);
                    }
                }
            } else {
                operationKey = SERVICE + verb;
            }
        } else {
            operationKey = OBJECT + verb;
            String objectKey = target[1];
            try {
                objectKey = OSGUtil.URLdecode((String)objectKey);
            }
            catch (UnsupportedEncodingException e) {
                throw new BindingException("Unable to get key: " + e.getMessage());
            }
            operationParams.put("Bucket", target[0]);
            operationParams.put("Key", objectKey);
            operationParams.put("Operation", verb.toUpperCase() + "." + "OBJECT");
            if (!params.containsKey(ObjectStorageProperties.BucketParameter.acl.toString())) {
                if (verb.equals(ObjectStorageProperties.HTTPVerb.PUT.toString())) {
                    if (httpRequest.containsHeader("x-amz-copy-source".toString())) {
                        String copySource = httpRequest.getHeader("x-amz-copy-source".toString());
                        try {
                            copySource = OSGUtil.URLdecode((String)copySource);
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new BindingException("Unable to decode copy source: " + copySource);
                        }
                        String[] sourceParts = copySource.split("\\?");
                        if (sourceParts.length > 1) {
                            operationParams.put("SourceVersionId", sourceParts[1].replaceFirst("versionId=", "").trim());
                        }
                        copySource = sourceParts[0];
                        String[] sourceTarget = OSGUtil.getTarget((String)copySource);
                        String sourceObjectKey = "";
                        if (sourceTarget == null || sourceTarget.length <= 1) throw new BindingException("Malformed COPY request");
                        sourceObjectKey = sourceTarget[1];
                        operationParams.put("SourceBucket", sourceTarget[0]);
                        operationParams.put("SourceObject", sourceObjectKey);
                        operationParams.put("DestinationBucket", operationParams.remove("Bucket"));
                        operationParams.put("DestinationObject", operationParams.remove("Key"));
                        String metaDataDirective = httpRequest.getHeader("x-amz-metadata-directive".toString());
                        if (metaDataDirective != null) {
                            operationParams.put("MetadataDirective", metaDataDirective);
                        }
                        operationKey = operationKey + "x-amz-copy-source".toString();
                        Set headerNames = httpRequest.getHeaderNames();
                        for (String key : headerNames) {
                            if (!key.startsWith("x-amz-")) continue;
                            String stripped = key.replaceFirst("x-amz-", "");
                            for (ObjectStorageProperties.CopyHeaders header : ObjectStorageProperties.CopyHeaders.values()) {
                                if (!stripped.replaceAll("-", "").equals(header.toString().toLowerCase())) continue;
                                String value = httpRequest.getHeader(key);
                                this.parseExtendedHeaders(operationParams, header.toString(), value);
                            }
                        }
                    } else {
                        String contentMD5;
                        String contentDisposition;
                        this.key = target[0] + "." + objectKey;
                        String contentType = httpRequest.getHeader("Content-Type");
                        if (contentType != null) {
                            operationParams.put("ContentType", contentType);
                        }
                        if ((contentDisposition = httpRequest.getHeader("Content-Disposition")) != null) {
                            operationParams.put("ContentDisposition", contentDisposition);
                        }
                        if ((contentMD5 = httpRequest.getHeader("Content-MD5")) != null) {
                            operationParams.put("ContentMD5", contentMD5);
                        }
                        if (contentLengthString != null) {
                            operationParams.put("ContentLength", new Long(contentLength).toString());
                        }
                    }
                    this.copyHeadersForStoring(operationParams, httpRequest);
                } else if (verb.equals(ObjectStorageProperties.HTTPVerb.GET.toString())) {
                    if (!objectstorageInternalOperation) {
                        if (params.containsKey("torrent")) {
                            operationParams.put("GetTorrent", Boolean.TRUE);
                        } else if (!params.containsKey("uploadId")) {
                            operationParams.put("InlineData", Boolean.FALSE);
                            operationParams.put("GetMetaData", Boolean.TRUE);
                        }
                        Set headerNames = httpRequest.getHeaderNames();
                        boolean isExtendedGet = false;
                        for (Object key : headerNames) {
                            for (ObjectStorageProperties.ExtendedGetHeaders header : ObjectStorageProperties.ExtendedGetHeaders.values()) {
                                if (!((String)key).replaceAll("-", "").equals(header.toString())) continue;
                                String value = httpRequest.getHeader((String)key);
                                isExtendedGet = true;
                                this.parseExtendedHeaders(operationParams, header.toString(), value);
                            }
                        }
                        if (isExtendedGet) {
                            operationKey = operationKey + "extended";
                            operationParams.put("ReturnCompleteObjectOnConditionFailure", Boolean.FALSE);
                        }
                    }
                    if (params.containsKey(ObjectStorageProperties.GetOptionalParameters.IsCompressed.toString())) {
                        Boolean isCompressed = Boolean.parseBoolean((String)params.remove(ObjectStorageProperties.GetOptionalParameters.IsCompressed.toString()));
                        operationParams.put("IsCompressed", isCompressed);
                    }
                    HashMap responseHeaderOverrides = Maps.newHashMap();
                    for (String paramName : params.keySet()) {
                        String paramValue;
                        if (paramName == null || "".equals(paramName) || !paramName.startsWith("response-") || (paramValue = (String)params.get(paramName)) == null || "".equals(paramValue)) continue;
                        responseHeaderOverrides.put(paramName, params.get(paramName));
                    }
                    if (responseHeaderOverrides.size() > 0) {
                        operationParams.put("ResponseHeaderOverrides", responseHeaderOverrides);
                    }
                } else if (verb.equals(ObjectStorageProperties.HTTPVerb.POST.toString()) && params.containsKey("uploadId")) {
                    operationParams.put("Parts", this.getPartsList(httpRequest));
                }
            }
            if (params.containsKey(ObjectStorageProperties.ObjectParameter.versionId.toString()) && !verb.equals(ObjectStorageProperties.HTTPVerb.DELETE.toString())) {
                operationParams.put("VersionId", params.remove(ObjectStorageProperties.ObjectParameter.versionId.toString()));
            }
        }
        if (verb.equals(ObjectStorageProperties.HTTPVerb.PUT.toString()) && params.containsKey(ObjectStorageProperties.BucketParameter.acl.toString())) {
            operationParams.put("AccessControlPolicy", this.getAccessControlPolicy(httpRequest));
        }
        if (verb.equals(ObjectStorageProperties.HTTPVerb.PUT.toString()) && params.containsKey(ObjectStorageProperties.BucketParameter.lifecycle.toString())) {
            operationParams.put("lifecycleConfiguration", this.getLifecycle(httpRequest));
        }
        if (verb.equals(ObjectStorageProperties.HTTPVerb.PUT.toString()) && params.containsKey(ObjectStorageProperties.BucketParameter.tagging.toString())) {
            operationParams.put("taggingConfiguration", this.getTagging(httpRequest));
        }
        ArrayList paramsToRemove = new ArrayList();
        boolean addMore = true;
        for (Object key : params.keySet()) {
            String value;
            String keyString = key.toString();
            boolean dontIncludeParam = false;
            for (S3Authentication.SecurityParameter securityParam : S3Authentication.SecurityParameter.values()) {
                if (!keyString.equals(securityParam.toString().toLowerCase())) continue;
                dontIncludeParam = true;
                break;
            }
            if (!dontIncludeParam) {
                value = (String)params.get(key);
                if (value != null) {
                    String[] keyStringParts = keyString.split("-");
                    if (keyStringParts.length > 1) {
                        keyString = "";
                        for (int i = 0; i < keyStringParts.length; ++i) {
                            keyString = keyString + this.toUpperFirst(keyStringParts[i]);
                        }
                    } else {
                        keyString = this.toUpperFirst(keyString);
                    }
                }
                dontIncludeParam = true;
                if (operationKey.startsWith(SERVICE)) {
                    for (ObjectStorageProperties.ServiceParameter serviceParameter : ObjectStorageProperties.ServiceParameter.values()) {
                        if (!keyString.toLowerCase().equals(serviceParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                } else if (operationKey.startsWith(BUCKET)) {
                    for (ObjectStorageProperties.BucketParameter bucketParameter : ObjectStorageProperties.BucketParameter.values()) {
                        if (!keyString.toLowerCase().equals(bucketParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                } else if (operationKey.startsWith(OBJECT)) {
                    for (ObjectStorageProperties.ObjectParameter objectParameter : ObjectStorageProperties.ObjectParameter.values()) {
                        if (!keyString.toLowerCase().equals(objectParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                }
                if (dontIncludeParam) {
                    paramsToRemove.add(key);
                }
            }
            if (dontIncludeParam) continue;
            value = (String)params.get(key);
            if (value != null) {
                operationParams.put(keyString, value);
            }
            for (ObjectStorageProperties.SubResource subResource : ObjectStorageProperties.SubResource.values()) {
                if (!keyString.toLowerCase().equals(subResource.toString().toLowerCase())) continue;
                operationKey = operationKey + keyString.toLowerCase();
            }
            paramsToRemove.add(key);
        }
        for (Object key : paramsToRemove) {
            params.remove(key);
        }
        if (!objectstorageInternalOperation) {
            operationName = this.operationMap.get(operationKey);
        }
        if (operationName == null && (unsupportedOp = this.unsupportedOperationMap.get(operationKey)) != null) {
            String resourceType = null;
            String resource = null;
            if (target.length < 2) {
                resourceType = BUCKET;
                resource = target[0];
            } else {
                resourceType = OBJECT;
                String delimiter = new String();
                for (int i = 1; i < target.length; ++i) {
                    resource = resource + delimiter + target[i];
                    delimiter = "/";
                }
            }
            NotImplementedException e = new NotImplementedException();
            e.setResource(resource);
            e.setResourceType(resourceType);
            e.setMessage(unsupportedOp + " is not implemented");
            throw e;
        }
        if (!"CreateBucket".equals(operationName) || (locationConstraint = this.getLocationConstraint(httpRequest)) == null) return operationName;
        operationParams.put("LocationConstraint", locationConstraint);
        return operationName;
    }

    protected void copyHeadersForStoring(Map operationParams, MappingHttpRequest httpRequest) {
        HashMap headersToStore = Maps.newHashMap();
        List headersInRequest = httpRequest.getHeaders();
        for (Map.Entry entry : headersInRequest) {
            int foundIdx = Collections.binarySearch(this.responseHeadersForStoring, entry.getKey(), STRING_COMPARATOR);
            if (foundIdx < 0) continue;
            headersToStore.put(entry.getKey(), entry.getValue());
        }
        if (headersToStore != null && headersToStore.size() > 0) {
            operationParams.put("copiedHeaders", headersToStore);
        }
    }

    protected void getTargetBucketParams(Map operationParams, MappingHttpRequest httpRequest) throws S3Exception, BindingException {
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            try {
                XMLParser xmlParser = new XMLParser(message);
                String targetBucket = xmlParser.getValue("//TargetBucket");
                if (targetBucket == null || targetBucket.length() == 0) {
                    return;
                }
                String targetPrefix = xmlParser.getValue("//TargetPrefix");
                ArrayList<Grant> grants = new ArrayList<Grant>();
                List permissions = xmlParser.getValues("//TargetGrants/Grant/Permission");
                if (permissions == null) {
                    throw new MalformedACLErrorException("/TargetGrants/Grant/Permission");
                }
                DTMNodeList grantees = xmlParser.getNodes("//TargetGrants/Grant/Grantee");
                if (grantees == null) {
                    throw new MalformedACLErrorException("//TargetGrants/Grant/Grantee");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String id = xmlParser.getValue(grantees.item(i), "ID");
                    if (id.length() > 0) {
                        String canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new MalformedACLErrorException("ACL group URI");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
                TargetGrants targetGrants = new TargetGrants(grants);
                LoggingEnabled loggingEnabled = new LoggingEnabled(targetBucket, targetPrefix, new TargetGrants(grants));
                operationParams.put("LoggingEnabled", loggingEnabled);
            }
            catch (S3Exception e) {
                throw e;
            }
            catch (Exception ex) {
                MalformedXMLException malEx = new MalformedXMLException("//TargetBucket");
                malEx.initCause((Throwable)ex);
                throw malEx;
            }
        }
    }

    protected void getVersioningStatus(Map operationParams, MappingHttpRequest httpRequest) throws S3Exception, BindingException {
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            try {
                XMLParser xmlParser = new XMLParser(message);
                String status = xmlParser.getValue("//Status");
                if (status == null || status.length() == 0) {
                    return;
                }
                operationParams.put("VersioningStatus", status);
            }
            catch (Exception ex) {
                MalformedXMLException malEx = new MalformedXMLException(message);
                malEx.initCause((Throwable)ex);
                throw malEx;
            }
        }
    }

    protected void parseExtendedHeaders(Map operationParams, String headerString, String value) throws BindingException {
        if (headerString.equals(ObjectStorageProperties.ExtendedGetHeaders.Range.toString())) {
            Matcher matcher = ObjectStorageProperties.RANGE_HEADER_PATTERN.matcher(value);
            if (matcher.matches()) {
                if (matcher.groupCount() > 0) {
                    Long start = null;
                    Long end = null;
                    boolean parseError = false;
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        String position = matcher.group(i);
                        if (!StringUtils.isNotBlank((String)position)) continue;
                        try {
                            if (i == 1) {
                                start = Long.parseLong(position);
                                continue;
                            }
                            end = Long.parseLong(position);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            LOG.debug((Object)("Cannot parse string \"" + position + "\" to long "));
                            parseError = true;
                            break;
                        }
                    }
                    if (!parseError) {
                        if (start != null) {
                            operationParams.put(ObjectStorageProperties.ExtendedHeaderRangeTypes.ByteRangeStart.toString(), start);
                        }
                        if (end != null) {
                            operationParams.put(ObjectStorageProperties.ExtendedHeaderRangeTypes.ByteRangeEnd.toString(), end);
                        }
                    } else {
                        LOG.debug((Object)("Dropping the Range header since its value: " + value + " cannot be parsed"));
                    }
                } else {
                    LOG.debug((Object)("Dropping the Range header since its value: " + value + " does not contain any matching groups against the pattern: " + ObjectStorageProperties.RANGE_HEADER_PATTERN.toString()));
                }
            } else {
                LOG.debug((Object)("Dropping the Range header since its value: " + value + " does not match pattern: " + ObjectStorageProperties.RANGE_HEADER_PATTERN.toString()));
            }
        } else if (ObjectStorageProperties.ExtendedHeaderDateTypes.contains((String)headerString)) {
            try {
                ArrayList<String> dateFormats = new ArrayList<String>();
                dateFormats.add("EEE, dd MMM yyyy HH:mm:ss zzz");
                operationParams.put(headerString, DateUtil.parseDate((String)value, dateFormats));
            }
            catch (Exception ex) {
                try {
                    operationParams.put(headerString, DateUtils.parseIso8601DateTime((String)value));
                }
                catch (ParseException e) {
                    throw new BindingException("Error parsing date: " + value, (Throwable)e);
                }
            }
        } else {
            operationParams.put(headerString, value);
        }
    }

    protected AccessControlPolicy getAccessControlPolicy(MappingHttpRequest httpRequest) throws S3Exception, BindingException {
        AccessControlPolicy accessControlPolicy = new AccessControlPolicy();
        AccessControlList accessControlList = new AccessControlList();
        ArrayList<Grant> grants = new ArrayList<Grant>();
        String aclString = "";
        try {
            aclString = this.getMessageString(httpRequest);
            if (aclString.length() > 0) {
                XMLParser xmlParser = new XMLParser(aclString);
                String ownerId = xmlParser.getValue("//Owner/ID");
                String displayName = xmlParser.getValue("//Owner/DisplayName");
                CanonicalUser canonicalUser = new CanonicalUser(ownerId, displayName);
                accessControlPolicy.setOwner(canonicalUser);
                List permissions = xmlParser.getValues("//AccessControlList/Grant/Permission");
                if (permissions == null) {
                    throw new MalformedACLErrorException("//AccessControlList/Grant/Permission");
                }
                DTMNodeList grantees = xmlParser.getNodes("//AccessControlList/Grant/Grantee");
                if (grantees == null) {
                    throw new MalformedACLErrorException("//AccessControlList/Grant/Grantee");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String canonicalUserName;
                    String id = xmlParser.getValue(grantees.item(i), "ID");
                    if (id.length() > 0) {
                        canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    if (!"".equals(xmlParser.getValue(grantees.item(i), "EmailAddress"))) {
                        canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        String email = xmlParser.getValue(grantees.item(i), "EmailAddress");
                        grantee.setEmailAddress(email);
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new MalformedACLErrorException("Group-URI");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
            }
        }
        catch (S3Exception e) {
            throw e;
        }
        catch (Exception ex) {
            throw new MalformedACLErrorException(aclString);
        }
        accessControlList.setGrants(grants);
        accessControlPolicy.setAccessControlList(accessControlList);
        return accessControlPolicy;
    }

    protected AccessControlList getAccessControlList(MappingHttpRequest httpRequest) throws S3Exception, BindingException {
        AccessControlList accessControlList = new AccessControlList();
        ArrayList<Grant> grants = new ArrayList<Grant>();
        String aclString = "";
        try {
            aclString = this.getMessageString(httpRequest);
            if (aclString.length() > 0) {
                XMLParser xmlParser = new XMLParser(aclString);
                String ownerId = xmlParser.getValue("//Owner/ID");
                String displayName = xmlParser.getValue("//Owner/DisplayName");
                List permissions = xmlParser.getValues("/AccessControlList/Grant/Permission");
                if (permissions == null) {
                    throw new MalformedACLErrorException("/AccessControlList/Grant/Permission");
                }
                DTMNodeList grantees = xmlParser.getNodes("/AccessControlList/Grant/Grantee");
                if (grantees == null) {
                    throw new MalformedACLErrorException("/AccessControlList/Grant/Grantee");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                    if (canonicalUserName.length() > 0) {
                        String id = xmlParser.getValue(grantees.item(i), "ID");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new MalformedACLErrorException("Group-URI");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
            }
        }
        catch (S3Exception e) {
            throw e;
        }
        catch (Exception ex) {
            throw new MalformedACLErrorException("Unable to parse access control list: " + aclString);
        }
        accessControlList.setGrants(grants);
        return accessControlList;
    }

    private ArrayList<Part> getPartsList(MappingHttpRequest httpRequest) throws BindingException {
        ArrayList<Part> partList = new ArrayList<Part>();
        try {
            String partsString = this.getMessageString(httpRequest);
            if (partsString.length() > 0) {
                XMLParser xmlParser = new XMLParser(partsString);
                DTMNodeList partNodes = xmlParser.getNodes("/CompleteMultipartUpload/Part");
                if (partNodes == null) {
                    throw new BindingException("Malformed part list");
                }
                for (int i = 0; i < partNodes.getLength(); ++i) {
                    Part part = new Part(Integer.valueOf(Integer.parseInt(xmlParser.getValue(partNodes.item(i), "PartNumber"))), xmlParser.getValue(partNodes.item(i), "ETag"));
                    partList.add(part);
                }
            }
        }
        catch (Exception ex) {
            throw new BindingException("Unable to parse part list " + ex.getMessage());
        }
        return partList;
    }

    protected String getOperationPath(MappingHttpRequest httpRequest) {
        for (String pathCandidate : ObjectStorageRESTPipeline.getServicePaths()) {
            if (!httpRequest.getServicePath().startsWith(pathCandidate)) continue;
            String opPath = httpRequest.getServicePath().replaceFirst(pathCandidate, "");
            if (!Strings.isNullOrEmpty((String)opPath) && !opPath.startsWith("/")) break;
            return opPath;
        }
        return httpRequest.getServicePath();
    }

    protected String getLocationConstraint(MappingHttpRequest httpRequest) throws S3Exception {
        String locationConstraint = null;
        try {
            String bucketConfiguration = this.getMessageString(httpRequest);
            if (bucketConfiguration.length() > 0) {
                XMLParser xmlParser = new XMLParser(bucketConfiguration);
                locationConstraint = xmlParser.getValue("/CreateBucketConfiguration/LocationConstraint");
            }
        }
        catch (Exception ex) {
            MalformedXMLException malEx = new MalformedXMLException("/CreateBucketConfiguration/LocationConstraint");
            malEx.initCause((Throwable)ex);
            throw malEx;
        }
        return locationConstraint;
    }

    protected List<String> populateObject(GroovyObject obj, Map<String, String> paramFieldMap, Map<String, String> params) {
        ArrayList<String> failedMappings = new ArrayList<String>();
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            try {
                if (!obj.getClass().getDeclaredField(e.getValue()).getType().equals(ArrayList.class)) continue;
                failedMappings.addAll(this.populateObjectList(obj, e, params, params.size()));
            }
            catch (NoSuchFieldException e1) {
                failedMappings.add(e.getKey());
            }
        }
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            if (!params.containsKey(e.getKey()) || this.populateObjectField(obj, e, params)) continue;
            failedMappings.add(e.getKey());
        }
        return failedMappings;
    }

    protected void populateObjectFromBindingMap(GroovyObject obj, Map<String, String> paramFieldMap, MappingHttpRequest httpRequest, Map bindingMap) throws S3Exception, BindingException {
        ObjectStorageRESTBinding.processHeaderGrants(obj, paramFieldMap, bindingMap, httpRequest);
        String metaDataString = paramFieldMap.remove("MetaData");
        if (metaDataString != null) {
            Set headerNames = httpRequest.getHeaderNames();
            ArrayList<MetaDataEntry> metaData = new ArrayList<MetaDataEntry>();
            for (String key : headerNames) {
                if (!key.toLowerCase().startsWith("x-amz-meta-")) continue;
                MetaDataEntry metaDataEntry = new MetaDataEntry();
                metaDataEntry.setName(key.substring("x-amz-meta-".length()));
                metaDataEntry.setValue(httpRequest.getHeader(key));
                metaData.add(metaDataEntry);
            }
            obj.setProperty(metaDataString, metaData);
        }
        for (String key : bindingMap.keySet()) {
            obj.setProperty(key.substring(0, 1).toLowerCase().concat(key.substring(1)), bindingMap.get(key));
        }
    }

    protected boolean populateObjectField(GroovyObject obj, Map.Entry<String, String> paramFieldPair, Map<String, String> params) {
        try {
            Class<?> declaredType = obj.getClass().getDeclaredField(paramFieldPair.getValue()).getType();
            if (declaredType.equals(String.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)params.remove(paramFieldPair.getKey()));
            } else if (declaredType.getName().equals("int")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Integer.parseInt(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Integer.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Integer(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.getName().equals("boolean")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Boolean.parseBoolean(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Boolean.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Boolean(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.getName().equals("long")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Long.parseLong(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Long.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Long(params.remove(paramFieldPair.getKey())));
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e1) {
            return false;
        }
    }

    protected List<String> populateObjectList(GroovyObject obj, Map.Entry<String, String> paramFieldPair, Map<String, String> params, int paramSize) {
        ArrayList<String> failedMappings;
        block12: {
            failedMappings = new ArrayList<String>();
            try {
                Field declaredField = obj.getClass().getDeclaredField(paramFieldPair.getValue());
                ArrayList theList = (ArrayList)obj.getProperty(paramFieldPair.getValue());
                Class genericType = (Class)((ParameterizedType)declaredField.getGenericType()).getActualTypeArguments()[0];
                if (String.class.equals((Object)genericType)) {
                    if (params.containsKey(paramFieldPair.getKey())) {
                        theList.add(params.remove(paramFieldPair.getKey()));
                    } else {
                        ArrayList keys = Lists.newArrayList(params.keySet());
                        for (String k : keys) {
                            if (!k.matches(paramFieldPair.getKey() + "\\.\\d*")) continue;
                            theList.add(params.remove(k));
                        }
                    }
                    break block12;
                }
                if (!declaredField.isAnnotationPresent(HttpEmbedded.class)) break block12;
                HttpEmbedded annoteEmbedded = declaredField.getAnnotation(HttpEmbedded.class);
                if (annoteEmbedded.multiple()) {
                    String prefix = paramFieldPair.getKey();
                    ArrayList<String> embeddedListFieldNames = new ArrayList<String>();
                    for (String actualParameterName : params.keySet()) {
                        if (!actualParameterName.matches(prefix + ".1.*")) continue;
                        embeddedListFieldNames.add(actualParameterName.replaceAll(prefix + ".1.", ""));
                    }
                    for (int i = 0; i < paramSize + 1; ++i) {
                        boolean foundAll = true;
                        HashMap<String, String> embeddedParams = new HashMap<String, String>();
                        for (String fieldName : embeddedListFieldNames) {
                            String paramName = prefix + "." + i + "." + fieldName;
                            if (!params.containsKey(paramName)) {
                                failedMappings.add("Mismatched embedded field: " + paramName);
                                foundAll = false;
                                continue;
                            }
                            embeddedParams.put(fieldName, params.get(paramName));
                        }
                        if (foundAll) {
                            failedMappings.addAll(this.populateEmbedded(genericType, embeddedParams, theList));
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                failedMappings.addAll(this.populateEmbedded(genericType, params, theList));
            }
            catch (Exception e1) {
                failedMappings.add(paramFieldPair.getKey());
            }
        }
        return failedMappings;
    }

    protected List<String> populateEmbedded(Class genericType, Map<String, String> params, ArrayList theList) throws InstantiationException, IllegalAccessException {
        GroovyObject embedded = (GroovyObject)genericType.newInstance();
        Map<String, String> embeddedFields = this.buildFieldMap(genericType);
        int startSize = params.size();
        List<String> embeddedFailures = this.populateObject(embedded, embeddedFields, params);
        if (embeddedFailures.isEmpty() && params.size() - startSize != 0) {
            theList.add(embedded);
        }
        return embeddedFailures;
    }

    protected Map<String, String> buildFieldMap(Class targetType) {
        Field[] fields;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Field f : fields = targetType.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            if (f.isAnnotationPresent(HttpParameterMapping.class)) {
                for (String parameter : f.getAnnotation(HttpParameterMapping.class).parameter()) {
                    fieldMap.put(parameter, f.getName());
                }
                fieldMap.put(f.getName().substring(0, 1).toUpperCase().concat(f.getName().substring(1)), f.getName());
                continue;
            }
            fieldMap.put(f.getName().substring(0, 1).toUpperCase().concat(f.getName().substring(1)), f.getName());
        }
        return fieldMap;
    }

    protected static void validateCannedAcl(String cannedAcl) throws InvalidArgumentException {
        if (!AclUtils.isValidCannedAcl((String)cannedAcl)) {
            throw new InvalidArgumentException(cannedAcl);
        }
    }

    protected static void addAccessControlList(GroovyObject obj, Map<String, String> paramFieldMap, Map bindingMap, String cannedACLString) throws S3Exception {
        ArrayList grants;
        AccessControlList accessControlList;
        if (bindingMap.containsKey("AccessControlPolicy")) {
            AccessControlPolicy accessControlPolicy = (AccessControlPolicy)bindingMap.get("AccessControlPolicy");
            accessControlList = accessControlPolicy.getAccessControlList();
            grants = accessControlList.getGrants();
        } else {
            accessControlList = new AccessControlList();
            grants = new ArrayList();
        }
        ObjectStorageRESTBinding.validateCannedAcl(cannedACLString);
        CanonicalUser aws = new CanonicalUser();
        aws.setDisplayName("");
        Grant grant = new Grant(new Grantee(aws), cannedACLString);
        grants.add(grant);
        accessControlList.setGrants(grants);
        String acl = paramFieldMap.remove("AccessControlList");
        if (acl != null) {
            obj.setProperty(acl, (Object)accessControlList);
        }
    }

    protected static void processHeaderGrants(GroovyObject obj, Map<String, String> paramFieldMap, Map bindingMap, MappingHttpRequest httpRequest) throws S3Exception {
        if (paramFieldMap.containsKey("AccessControlList") || paramFieldMap.containsKey("AccessControlPolicy")) {
            ArrayList<Grant> grants = new ArrayList<Grant>();
            String cannedACLString = httpRequest.getAndRemoveHeader("x-amz-acl");
            if (!Strings.isNullOrEmpty((String)cannedACLString)) {
                ObjectStorageRESTBinding.validateCannedAcl(cannedACLString);
                grants.add(new Grant(new Grantee(new CanonicalUser("", "")), cannedACLString));
            }
            for (Map.Entry mapEntry : ObjectStorageProperties.HEADER_PERMISSION_MAP.entrySet()) {
                String grantsString = httpRequest.getAndRemoveHeader(((ObjectStorageProperties.X_AMZ_GRANT)mapEntry.getKey()).toString());
                String[] grantsArray = null;
                if (!StringUtils.isNotBlank((String)grantsString) || (grantsArray = grantsString.split(",")) == null || grantsArray.length <= 0) continue;
                for (int i = 0; i < grantsArray.length; ++i) {
                    String[] grantIdentityArray = grantsArray[0].split("=");
                    if (grantIdentityArray != null && grantIdentityArray.length == 2) {
                        switch (grantIdentityArray[0]) {
                            case "emailAddress": {
                                grants.add(new Grant(new Grantee(StringUtils.strip((String)grantIdentityArray[1], (String)"'\"")), ((ObjectStorageProperties.Permission)mapEntry.getValue()).toString()));
                                break;
                            }
                            case "id": {
                                grants.add(new Grant(new Grantee(new CanonicalUser(StringUtils.strip((String)grantIdentityArray[1], (String)"'\""), "")), ((ObjectStorageProperties.Permission)mapEntry.getValue()).toString()));
                                break;
                            }
                            case "uri": {
                                grants.add(new Grant(new Grantee(new Group(StringUtils.strip((String)grantIdentityArray[1], (String)"'\""))), ((ObjectStorageProperties.Permission)mapEntry.getValue()).toString()));
                                break;
                            }
                            default: {
                                throw new InvalidArgumentException(((ObjectStorageProperties.X_AMZ_GRANT)mapEntry.getKey()).toString(), "Argument format not recognized: " + grantIdentityArray[0] + ". Valid types are emailAddress, id or url");
                            }
                        }
                        continue;
                    }
                    throw new InvalidArgumentException(((ObjectStorageProperties.X_AMZ_GRANT)mapEntry.getKey()).toString(), "Argument format not recognized: " + grantsArray[0] + ". Valid format for grantee is 'type=value' where type is emailAddress, id or url");
                }
            }
            if (!grants.isEmpty()) {
                if (paramFieldMap.containsKey("AccessControlList")) {
                    AccessControlList accessControlList;
                    if (bindingMap.containsKey("AccessControlList")) {
                        accessControlList = (AccessControlList)bindingMap.get("AccessControlList");
                    } else {
                        accessControlList = new AccessControlList();
                        bindingMap.put("AccessControlList", accessControlList);
                    }
                    accessControlList.getGrants().addAll(grants);
                } else {
                    AccessControlPolicy accessControlPolicy;
                    if (bindingMap.containsKey("AccessControlPolicy")) {
                        accessControlPolicy = (AccessControlPolicy)bindingMap.get("AccessControlPolicy");
                    } else {
                        accessControlPolicy = new AccessControlPolicy(new CanonicalUser("", ""), new AccessControlList());
                        bindingMap.put("AccessControlPolicy", accessControlPolicy);
                    }
                    accessControlPolicy.getAccessControlList().getGrants().addAll(grants);
                }
            }
        }
    }

    protected String toUpperFirst(String string) {
        return string.substring(0, 1).toUpperCase().concat(string.substring(1));
    }

    protected String getMessageString(MappingHttpRequest httpRequest) {
        ChannelBuffer buffer = httpRequest.getContent();
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        return new String(read);
    }

    private TaggingConfiguration getTagging(MappingHttpRequest httpRequest) throws S3Exception {
        TaggingConfiguration taggingConfiguration = new TaggingConfiguration();
        BucketTagSet tagSet = new BucketTagSet();
        tagSet.setBucketTags(new ArrayList());
        taggingConfiguration.setBucketTagSet(tagSet);
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            XMLParser xmlParser = new XMLParser(message);
            DTMNodeList bucketTagSets = xmlParser.getNodes("//Tagging/TagSet");
            if (bucketTagSets == null || bucketTagSets.getLength() != 1) {
                throw new MalformedXMLException("/Tagging/TagSet");
            }
            bucketTagSets = xmlParser.getNodes("//Tagging/TagSet/Tag");
            for (int i = 0; i < bucketTagSets.getLength(); ++i) {
                taggingConfiguration.getBucketTagSet().getBucketTags().add(this.extractBucketTag(xmlParser, bucketTagSets.item(i)));
            }
        }
        return taggingConfiguration;
    }

    private BucketTag extractBucketTag(XMLParser parser, Node node) throws InvalidTagErrorException {
        String value;
        BucketTag bucketTag = new BucketTag();
        String key = parser.getValue(node, "Key");
        if (this.isInValidTagSet(key, value = parser.getValue(node, "Value"))) {
            throw new InvalidTagErrorException();
        }
        bucketTag.setKey(key);
        bucketTag.setValue(value);
        return bucketTag;
    }

    private boolean isInValidTagSet(String key, String value) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\s+-=._:]+");
        if (key == null || key.equals("") || value == null || value.equals("")) {
            return true;
        }
        if (key.equals(" ") || key.charAt(0) == ' ' || value.charAt(0) == ' ' || value.equals(" ")) {
            return true;
        }
        if (key.length() > 128 || value.length() > 256) {
            return true;
        }
        return !pattern.matcher(key).matches() || !pattern.matcher(value).matches();
    }

    private LifecycleConfiguration getLifecycle(MappingHttpRequest httpRequest) throws S3Exception {
        LifecycleConfiguration lifecycleConfigurationType = new LifecycleConfiguration();
        lifecycleConfigurationType.setRules(new ArrayList());
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            try {
                XMLParser xmlParser = new XMLParser(message);
                DTMNodeList rules = xmlParser.getNodes("//LifecycleConfiguration/Rule");
                if (rules == null) {
                    throw new MalformedXMLException("/LifecycleConfiguration/Rule");
                }
                for (int idx = 0; idx < rules.getLength(); ++idx) {
                    lifecycleConfigurationType.getRules().add(this.extractLifecycleRule(xmlParser, rules.item(idx)));
                }
            }
            catch (S3Exception e) {
                throw e;
            }
            catch (Exception ex) {
                MalformedXMLException e = new MalformedXMLException("/LifecycleConfiguration");
                ex.initCause(ex);
                throw e;
            }
        }
        return lifecycleConfigurationType;
    }

    private LifecycleRule extractLifecycleRule(XMLParser parser, Node node) throws S3Exception {
        LifecycleRule lifecycleRule = new LifecycleRule();
        String id = parser.getValue(node, "ID");
        String prefix = parser.getValue(node, "Prefix");
        String status = parser.getValue(node, "Status");
        lifecycleRule.setId(id);
        lifecycleRule.setPrefix(prefix);
        lifecycleRule.setStatus(status);
        try {
            Transition transition = null;
            String transitionDays = parser.getValue(node, "Transition/Days");
            String transitionDate = parser.getValue(node, "Transition/Date");
            if (transitionDays != null && !transitionDays.equals("") || transitionDate != null && !transitionDate.equals("")) {
                String storageClass = parser.getValue(node, "Transition/StorageClass");
                if (transitionDays != null && !transitionDays.equals("")) {
                    transition = new Transition();
                    Integer transitionDaysInt = new Integer(Integer.parseInt(transitionDays));
                    transition.setCreationDelayDays(transitionDaysInt.intValue());
                } else if (transitionDate != null && !transitionDate.equals("")) {
                    transition = new Transition();
                    Date transitionDateAsDate = Iso8601DateParser.parse((String)transitionDate);
                    transition.setEffectiveDate(transitionDateAsDate);
                }
                if (transition != null) {
                    transition.setDestinationClass(storageClass);
                }
            }
            if (transition != null) {
                lifecycleRule.setTransition(transition);
            }
            Expiration expiration = null;
            String expirationDays = parser.getValue(node, "Expiration/Days");
            String expirationDate = parser.getValue(node, "Expiration/Date");
            if (expirationDays != null && !expirationDays.equals("") || expirationDate != null && !expirationDate.equals("")) {
                if (expirationDays != null && !expirationDays.equals("")) {
                    expiration = new Expiration();
                    Integer expirationDaysInt = new Integer(Integer.parseInt(expirationDays));
                    expiration.setCreationDelayDays(expirationDaysInt.intValue());
                } else if (expirationDate != null && !expirationDate.equals("")) {
                    expiration = new Expiration();
                    Date expirationDateAsDate = Iso8601DateParser.parse((String)expirationDate);
                    expiration.setEffectiveDate(expirationDateAsDate);
                }
            }
            if (expiration != null) {
                lifecycleRule.setExpiration(expiration);
            }
        }
        catch (ParseException e) {
            MalformedXMLException ex = new MalformedXMLException("Expiration|Transition Date");
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (Exception ex) {
            MalformedXMLException e = new MalformedXMLException("LifecycleRule");
            ex.initCause(ex);
            throw e;
        }
        return lifecycleRule;
    }
}

