/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.binding;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataRequestType;
import com.eucalyptus.objectstorage.pipeline.binding.ObjectStorageRESTBinding;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.util.LogUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class ObjectStorageFormPOSTBinding
extends ObjectStorageRESTBinding {
    private static Logger LOG = Logger.getLogger(ObjectStorageFormPOSTBinding.class);

    @Override
    protected Map<String, String> populateOperationMap() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("bucket" + HttpMethod.POST.toString(), "PostObject");
        return newMap;
    }

    @Override
    protected Map<String, String> populateUnsupportedOperationMap() {
        HashMap<String, String> opsMap = new HashMap<String, String>();
        return opsMap;
    }

    @Override
    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        LOG.trace((Object)LogUtil.dumpObject((Object)channelEvent));
        UpstreamMessageEvent firstChunkEvent = null;
        DefaultHttpChunk firstChunk = null;
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            try {
                MappingHttpRequest request;
                if (msgEvent.getMessage() instanceof MappingHttpRequest && (request = (MappingHttpRequest)msgEvent.getMessage()).getFormFields() != null && request.getFormFields().get(ObjectStorageProperties.FormField.x_ignore_firstdatachunk.toString()) != null) {
                    firstChunk = new DefaultHttpChunk((ChannelBuffer)request.getFormFields().get(ObjectStorageProperties.FormField.x_ignore_firstdatachunk.toString()));
                    if (request.isChunked()) {
                        firstChunkEvent = new UpstreamMessageEvent(channelHandlerContext.getChannel(), (Object)firstChunk, msgEvent.getRemoteAddress());
                    }
                }
                this.incomingMessage(channelHandlerContext, msgEvent);
                if (firstChunkEvent == null && firstChunk != null && msgEvent.getMessage() instanceof MappingHttpRequest && ((MappingHttpRequest)msgEvent.getMessage()).getMessage() instanceof ObjectStorageDataRequestType) {
                    ObjectStorageDataRequestType dataReq = (ObjectStorageDataRequestType)((MappingHttpRequest)msgEvent.getMessage()).getMessage();
                    this.handleData(dataReq, firstChunk.getContent());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error in POST multipart form binding", (Throwable)e);
                Channels.fireExceptionCaught((ChannelHandlerContext)channelHandlerContext, (Throwable)e);
                return;
            }
        }
        channelHandlerContext.sendUpstream(channelEvent);
        if (firstChunkEvent != null) {
            LOG.trace((Object)("Dispatching follow-up chunk directly after initial request. Size: " + firstChunk.getContent().readableBytes()));
            channelHandlerContext.sendUpstream(firstChunkEvent);
        }
    }
}

