/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline.auth;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.api.BaseLoginModule;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidAccessKeyIdException;
import com.eucalyptus.objectstorage.pipeline.auth.ObjectStorageWrappedCredentials;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;

public class ObjectStorageLoginModule
extends BaseLoginModule<ObjectStorageWrappedCredentials> {
    private static Logger LOG = Logger.getLogger(ObjectStorageLoginModule.class);

    public boolean accepts() {
        return super.getCallbackHandler() instanceof ObjectStorageWrappedCredentials;
    }

    public boolean authenticate(ObjectStorageWrappedCredentials credentials) throws Exception {
        AccessKey key;
        String signature = credentials.getSignature().replaceAll("=", "");
        try {
            key = AccessKeys.lookupAccessKey((String)credentials.getQueryId(), (String)credentials.getSecurityToken());
        }
        catch (AuthException e) {
            throw new InvalidAccessKeyIdException(credentials.getQueryId());
        }
        if (!key.isActive().booleanValue()) {
            throw new InvalidAccessKeyIdException(credentials.getQueryId());
        }
        User user = key.getUser();
        String queryKey = key.getSecretKey();
        String authSig = this.checkSignature(queryKey, (String)credentials.getLoginData());
        if (authSig.equals(signature)) {
            super.setCredential((Object)credentials.getQueryId());
            super.setPrincipal(user);
            return true;
        }
        return false;
    }

    public void reset() {
    }

    protected String checkSignature(String queryKey, String subject) throws AuthenticationException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(queryKey.getBytes("UTF-8"), Hmac.HmacSHA1.toString());
            Mac mac = Mac.getInstance(Hmac.HmacSHA1.toString());
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(subject.getBytes("UTF-8"));
            return new String(Base64.encode((byte[])rawHmac)).replaceAll("=", "");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }
}

