/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.xbill.DNS.Name;

public abstract class ObjectStorageRESTPipeline
extends FilteredPipeline {
    private static Logger LOG = Logger.getLogger(ObjectStorageRESTPipeline.class);
    private static final Splitter hostSplitter = Splitter.on((char)':').limit(2);
    private static final Set<String> servicePaths = Sets.newHashSet((Object[])new String[]{((ObjectStorage)ComponentIds.lookup(ObjectStorage.class)).getServicePath(new String[0]), "/services/Walrus"});

    public static Set<String> getServicePaths() {
        return servicePaths;
    }

    public boolean checkAccepts(HttpRequest message) {
        String uriPath = message.getUri();
        uriPath = uriPath == null ? "" : uriPath;
        String hostHeader = message.getHeader("Host");
        hostHeader = hostHeader == null ? "" : hostHeader;
        return !ObjectStorageRESTPipeline.isSoapRequest(message) && (this.isObjectStorageHostName(hostHeader) || this.isObjectStorageServicePathRequest(uriPath, hostHeader));
    }

    private static boolean isSoapRequest(HttpRequest message) {
        return message.getHeaderNames().contains("SOAPAction");
    }

    private boolean isObjectStorageServicePathRequest(final String uriPath, String hostHeader) {
        Predicate<String> matchUriPredicate = new Predicate<String>(){

            public boolean apply(@Nullable String s) {
                return ObjectStorageRESTPipeline.this.checkServicePathUri(uriPath, s);
            }
        };
        return !this.isObjectStorageHostName(hostHeader) && Iterators.any(servicePaths.iterator(), (Predicate)matchUriPredicate);
    }

    private boolean checkServicePathUri(String uriPath, String servicePath) {
        String tmpUri = uriPath;
        if (!tmpUri.endsWith("/")) {
            tmpUri = tmpUri + "/";
        }
        return tmpUri.startsWith(servicePath + "/");
    }

    private boolean isObjectStorageHostName(String hostHeader) {
        return this.resolvesByHost(hostHeader) || this.maybeBucketHostedStyle(hostHeader);
    }

    private boolean maybeBucketHostedStyle(String fullHostHeader) {
        try {
            return DomainNames.absolute((Name)Name.fromString((String)((String)Iterables.getFirst((Iterable)hostSplitter.split((CharSequence)fullHostHeader), (Object)fullHostHeader)))).subdomain(DomainNames.externalSubdomain(ObjectStorage.class)) || DomainNames.absolute((Name)Name.fromString((String)((String)Iterables.getFirst((Iterable)hostSplitter.split((CharSequence)fullHostHeader), (Object)fullHostHeader)))).subdomain(Name.fromString((String)("walrus." + DomainNames.externalSubdomain().toString())));
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing domain name from hostname: " + fullHostHeader), (Throwable)e);
            return false;
        }
    }
}

