/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline;

import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.pipeline.ObjectStorageRESTPipeline;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageChunkedPUTLifecycleAndAclAggregatorStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStoragePUTAggregatorStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStoragePUTBindingStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStoragePUTOutboundStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageRESTExceptionStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageUserAuthenticationStage;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=ObjectStorage.class)
public class ObjectStoragePUTPipeline
extends ObjectStorageRESTPipeline {
    private static Logger LOG = Logger.getLogger(ObjectStoragePUTPipeline.class);
    private final UnrollableStage auth = new ObjectStorageUserAuthenticationStage();
    private final UnrollableStage chunkedLCorACL = new ObjectStorageChunkedPUTLifecycleAndAclAggregatorStage();
    private final UnrollableStage bind = new ObjectStoragePUTBindingStage();
    private final UnrollableStage aggr = new ObjectStoragePUTAggregatorStage();
    private final UnrollableStage out = new ObjectStoragePUTOutboundStage();
    private final UnrollableStage exHandler = new ObjectStorageRESTExceptionStage();

    @Override
    public boolean checkAccepts(HttpRequest message) {
        if (super.checkAccepts(message) && message.getMethod().getName().equals(ObjectStorageProperties.HTTPVerb.PUT.toString())) {
            return true;
        }
        if (super.checkAccepts(message) && message.getMethod().getName().equals(ObjectStorageProperties.HTTPVerb.POST.toString())) {
            String contentType = message.getHeader("Content-Type");
            return contentType == null || !contentType.startsWith("multipart/form-data;");
        }
        return false;
    }

    public String getName() {
        return "objectstorage-put";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.chunkedLCorACL.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.aggr.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        this.exHandler.unrollStage(pipeline);
        return pipeline;
    }
}

