/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline;

import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.pipeline.ObjectStorageRESTPipeline;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageOPTIONSBindingStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageOPTIONSOutboundStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageUserAuthenticationStage;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=ObjectStorage.class)
public class ObjectStorageOPTIONSPipeline
extends ObjectStorageRESTPipeline {
    private static Logger LOG = Logger.getLogger(ObjectStorageOPTIONSPipeline.class);
    private final UnrollableStage auth = new ObjectStorageUserAuthenticationStage();
    private final UnrollableStage bind = new ObjectStorageOPTIONSBindingStage();
    private final UnrollableStage out = new ObjectStorageOPTIONSOutboundStage();

    @Override
    public boolean checkAccepts(HttpRequest message) {
        return super.checkAccepts(message) && message.getMethod().getName().equals(ObjectStorageProperties.HTTPVerb.OPTIONS.toString());
    }

    public String getName() {
        return "objectstorage-options";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        return pipeline;
    }
}

