/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline;

import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.pipeline.ObjectStorageRESTPipeline;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageHEADBindingStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageHEADOutboundStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageRESTExceptionStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageUserAuthenticationStage;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=ObjectStorage.class)
public class ObjectStorageHEADPipeline
extends ObjectStorageRESTPipeline {
    private static Logger LOG = Logger.getLogger(ObjectStorageHEADPipeline.class);
    private final UnrollableStage auth = new ObjectStorageUserAuthenticationStage();
    private final UnrollableStage bind = new ObjectStorageHEADBindingStage();
    private final UnrollableStage out = new ObjectStorageHEADOutboundStage();
    private final UnrollableStage exHandler = new ObjectStorageRESTExceptionStage();

    @Override
    public boolean checkAccepts(HttpRequest message) {
        return super.checkAccepts(message) && message.getMethod().getName().equals(ObjectStorageProperties.HTTPVerb.HEAD.toString());
    }

    public String getName() {
        return "objectstorage-head";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        this.exHandler.unrollStage(pipeline);
        return pipeline;
    }
}

