/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.pipeline;

import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.pipeline.ObjectStorageRESTPipeline;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageFormPOSTAggregatorStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageFormPOSTBindingStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageFormPOSTOutboundStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageFormPOSTUserAuthenticationStage;
import com.eucalyptus.objectstorage.pipeline.stages.ObjectStorageRESTExceptionStage;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=ObjectStorage.class)
public class ObjectStorageFormPOSTPipeline
extends ObjectStorageRESTPipeline {
    private static Logger LOG = Logger.getLogger(ObjectStorageFormPOSTPipeline.class);
    private final UnrollableStage auth = new ObjectStorageFormPOSTUserAuthenticationStage();
    private final UnrollableStage bind = new ObjectStorageFormPOSTBindingStage();
    private final UnrollableStage aggr = new ObjectStorageFormPOSTAggregatorStage();
    private final UnrollableStage out = new ObjectStorageFormPOSTOutboundStage();
    private final UnrollableStage exHandler = new ObjectStorageRESTExceptionStage();

    @Override
    public boolean checkAccepts(HttpRequest message) {
        if (super.checkAccepts(message) && message.getMethod().getName().equals(ObjectStorageProperties.HTTPVerb.POST.toString())) {
            String contentType = message.getHeader("Content-Type");
            return contentType != null && contentType.startsWith("multipart/form-data;");
        }
        return false;
    }

    public String getName() {
        return "objectstorage-post-multipart-form";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.aggr.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        this.exHandler.unrollStage(pipeline);
        return pipeline;
    }
}

