/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageInternalException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ObjectStateTransitions {
    private static final Logger LOG = Logger.getLogger(ObjectStateTransitions.class);
    static final Function<ObjectEntity, ObjectEntity> TRANSITION_TO_CREATING = new Function<ObjectEntity, ObjectEntity>(){

        @Nullable
        public ObjectEntity apply(@Nullable ObjectEntity initializedObject) {
            Bucket extantBucket;
            if (initializedObject == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                extantBucket = (Bucket)Entities.uniqueResult((Object)new Bucket().withUuid(initializedObject.getBucket().getBucketUuid()));
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(e);
            }
            catch (TransactionException e) {
                throw new MetadataOperationFailureException(e);
            }
            if (extantBucket == null) {
                throw new NoSuchEntityException(initializedObject.getBucket().getBucketUuid());
            }
            if (initializedObject.getState() != null && !ObjectState.creating.equals((Object)initializedObject.getState())) {
                throw new IllegalResourceStateException(initializedObject.getResourceFullName(), null, ObjectState.creating.toString(), ((ObjectState)initializedObject.getState()).toString());
            }
            if (extantBucket == null || !BucketState.extant.equals((Object)extantBucket.getState())) {
                throw new IllegalResourceStateException(extantBucket.getBucketUuid(), null, BucketState.extant.toString(), ((BucketState)extantBucket.getState()).toString());
            }
            initializedObject.setBucket(extantBucket);
            initializedObject.setState((Enum)ObjectState.creating);
            initializedObject.updateCreationExpiration();
            return (ObjectEntity)Entities.persist((Object)initializedObject);
        }
    };
    static final Function<ObjectEntity, ObjectEntity> TRANSITION_TO_EXTANT = new Function<ObjectEntity, ObjectEntity>(){

        @Nullable
        public ObjectEntity apply(@Nullable ObjectEntity entity) {
            if (entity == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                ObjectEntity updatingEntity = (ObjectEntity)Entities.uniqueResult((Object)new ObjectEntity().withUuid(entity.getObjectUuid()));
                if (!ObjectState.deleting.equals((Object)entity.getState())) {
                    updatingEntity.setState((Enum)ObjectState.extant);
                    updatingEntity.setCreationExpiration(null);
                    updatingEntity.setObjectModifiedTimestamp(entity.getObjectModifiedTimestamp());
                    updatingEntity.setIsLatest(Boolean.valueOf(true));
                    updatingEntity.seteTag(entity.geteTag());
                    updatingEntity.setSize(entity.getSize());
                    updatingEntity.setStoredHeaders(entity.getStoredHeaders());
                    if (ObjectState.mpu_pending.equals((Object)updatingEntity.getLastState())) {
                        MpuPartMetadataManagers.getInstance().removeParts(updatingEntity.getBucket(), updatingEntity.getUploadId());
                    }
                } else {
                    throw new IllegalResourceStateException("Cannot transition to extant from non-creating state", null, ObjectState.creating.toString(), ((ObjectState)entity.getState()).toString());
                }
                ObjectMetadataManagers.getInstance().cleanupInvalidObjects(updatingEntity.getBucket(), updatingEntity.getObjectKey());
                return updatingEntity;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(entity.getObjectUuid());
            }
            catch (ObjectStorageInternalException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot update state of object " + entity.getObjectUuid()), (Throwable)e);
                throw new MetadataOperationFailureException(e);
            }
        }
    };
    static final Function<ObjectEntity, ObjectEntity> TRANSITION_TO_MPU_PENDING = new Function<ObjectEntity, ObjectEntity>(){

        @Nullable
        public ObjectEntity apply(@Nullable ObjectEntity entity) {
            if (entity == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                ObjectEntity updatingEntity = (ObjectEntity)Entities.uniqueResult((Object)new ObjectEntity().withUuid(entity.getObjectUuid()));
                if (!ObjectState.creating.equals((Object)updatingEntity.getState())) {
                    throw new IllegalResourceStateException("Cannot transition to mpu-pending from non-creating state", null, ObjectState.creating.toString(), ((ObjectState)entity.getState()).toString());
                }
                updatingEntity.setState((Enum)ObjectState.mpu_pending);
                updatingEntity.setCreationExpiration(null);
                updatingEntity.setObjectModifiedTimestamp(entity.getObjectModifiedTimestamp());
                updatingEntity.setUploadId(entity.getUploadId());
                return updatingEntity;
            }
            catch (ObjectStorageInternalException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot update state of object " + entity.getObjectUuid()), (Throwable)e);
                throw new MetadataOperationFailureException(e);
            }
        }
    };
    static final Function<ObjectEntity, ObjectEntity> TRANSITION_TO_DELETING = new Function<ObjectEntity, ObjectEntity>(){

        @Nullable
        public ObjectEntity apply(@Nullable ObjectEntity objectToUpdate) {
            if (objectToUpdate == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                ObjectEntity entity = !Entities.isPersistent((Object)objectToUpdate) ? (ObjectEntity)Entities.uniqueResult((Object)new ObjectEntity().withUuid(objectToUpdate.getObjectUuid())) : objectToUpdate;
                entity.setState((Enum)ObjectState.deleting);
                entity.setIsLatest(Boolean.FALSE);
                return entity;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(objectToUpdate.getObjectUuid());
            }
            catch (Exception e) {
                throw new MetadataOperationFailureException(e);
            }
        }
    };
    static final Predicate<ObjectEntity> TRANSITION_TO_DELETED = new Predicate<ObjectEntity>(){

        @Nullable
        public boolean apply(@Nullable ObjectEntity objectToUpdate) {
            if (objectToUpdate == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                ObjectEntity entity = !Entities.isPersistent((Object)objectToUpdate) ? (ObjectEntity)Entities.uniqueResult((Object)new ObjectEntity().withUuid(objectToUpdate.getObjectUuid())) : objectToUpdate;
                if (!ObjectState.deleting.equals((Object)objectToUpdate.getState())) {
                    throw new IllegalResourceStateException("Entity not in deleting state. Only valid transition to deleted is from deleting.", null, ObjectState.deleting.toString(), ((ObjectState)objectToUpdate.getState()).toString());
                }
                Entities.delete((Object)entity);
                return true;
            }
            catch (ObjectStorageInternalException e) {
                throw e;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(objectToUpdate.getObjectUuid());
            }
            catch (Exception e) {
                throw new MetadataOperationFailureException(e);
            }
        }
    };
}

