/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.PaginatedResult;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;

public interface ObjectMetadataManager {
    public void start() throws Exception;

    public void stop() throws Exception;

    public ObjectEntity lookupObject(Bucket var1, String var2, String var3) throws NoSuchElementException;

    public ObjectEntity lookupUpload(Bucket var1, String var2, String var3) throws Exception;

    public List<ObjectEntity> lookupObjectsInState(Bucket var1, String var2, String var3, ObjectState var4) throws Exception;

    public List<ObjectEntity> lookupObjectVersions(Bucket var1, String var2, int var3) throws Exception;

    public ObjectEntity initiateCreation(ObjectEntity var1) throws Exception;

    public ObjectEntity finalizeCreation(ObjectEntity var1, Date var2, String var3) throws MetadataOperationFailureException;

    public ObjectEntity finalizeMultipartInit(ObjectEntity var1, Date var2, String var3) throws MetadataOperationFailureException;

    public PaginatedResult<ObjectEntity> listUploads(Bucket var1, int var2, String var3, String var4, String var5, String var6) throws Exception;

    public PaginatedResult<ObjectEntity> listPaginated(Bucket var1, int var2, String var3, String var4, String var5) throws Exception;

    public PaginatedResult<ObjectEntity> listVersionsPaginated(Bucket var1, int var2, String var3, String var4, String var5, String var6, boolean var7) throws Exception;

    public void delete(ObjectEntity var1) throws IllegalResourceStateException, MetadataOperationFailureException;

    public ObjectEntity generateAndPersistDeleteMarker(ObjectEntity var1, AccessControlPolicy var2, User var3) throws MetadataOperationFailureException;

    public ObjectEntity transitionObjectToState(ObjectEntity var1, ObjectState var2) throws IllegalResourceStateException, MetadataOperationFailureException;

    public ObjectEntity makeLatest(ObjectEntity var1) throws Exception;

    public ObjectEntity setAcp(ObjectEntity var1, AccessControlPolicy var2) throws Exception;

    public void flushUploads(Bucket var1) throws Exception;

    public void cleanupAllNullVersionedObjectRecords(Bucket var1, String var2) throws Exception;

    public List<ObjectEntity> lookupFailedObjects() throws Exception;

    public long getTotalSize(Bucket var1) throws Exception;

    public List<ObjectEntity> lookupObjectsForReaping(Bucket var1, String var2, Date var3);

    public void cleanupInvalidObjects(Bucket var1, String var2) throws Exception;

    public long countValid(Bucket var1) throws Exception;

    public ObjectEntity updateCreationTimeout(ObjectEntity var1) throws Exception;
}

