/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.PartEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageInternalException;
import com.google.common.base.Function;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class MpuPartStateTransitions {
    private static final Logger LOG = Logger.getLogger(MpuPartStateTransitions.class);
    static final Function<PartEntity, PartEntity> TRANSITION_TO_CREATING = new Function<PartEntity, PartEntity>(){

        @Nullable
        public PartEntity apply(@Nullable PartEntity initializedObject) {
            Bucket extantBucket;
            if (initializedObject == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                extantBucket = (Bucket)Entities.uniqueResult((Object)new Bucket().withUuid(initializedObject.getBucket().getBucketUuid()));
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(e);
            }
            catch (TransactionException e) {
                throw new MetadataOperationFailureException(e);
            }
            if (extantBucket == null) {
                throw new NoSuchEntityException(initializedObject.getBucket().getBucketUuid());
            }
            if (initializedObject.getState() != null && !ObjectState.creating.equals((Object)initializedObject.getState())) {
                throw new IllegalResourceStateException(initializedObject.getResourceFullName(), null, ObjectState.creating.toString(), ((ObjectState)initializedObject.getState()).toString());
            }
            if (extantBucket == null || !BucketState.extant.equals((Object)extantBucket.getState())) {
                throw new IllegalResourceStateException(extantBucket.getBucketUuid(), null, BucketState.extant.toString(), ((BucketState)extantBucket.getState()).toString());
            }
            initializedObject.setBucket(extantBucket);
            initializedObject.setState((Enum)ObjectState.creating);
            initializedObject.updateCreationExpiration();
            return (PartEntity)Entities.persist((Object)initializedObject);
        }
    };
    static final Function<PartEntity, PartEntity> TRANSITION_TO_EXTANT = new Function<PartEntity, PartEntity>(){

        @Nullable
        public PartEntity apply(@Nullable PartEntity entity) {
            if (entity == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                PartEntity updatingEntity = (PartEntity)Entities.uniqueResult((Object)new PartEntity().withUuid(entity.getPartUuid()));
                if (ObjectState.deleting.equals((Object)entity.getState())) {
                    throw new IllegalResourceStateException("Cannot transition to extant from non-creating state", null, ObjectState.creating.toString(), ((ObjectState)entity.getState()).toString());
                }
                updatingEntity.setState((Enum)ObjectState.extant);
                updatingEntity.setCreationExpiration(null);
                updatingEntity.setObjectModifiedTimestamp(entity.getObjectModifiedTimestamp());
                updatingEntity.setIsLatest(Boolean.valueOf(true));
                updatingEntity.seteTag(entity.geteTag());
                updatingEntity.setSize(entity.getSize());
                MpuPartMetadataManagers.getInstance().cleanupInvalidParts(entity.getBucket(), entity.getObjectKey(), entity.getUploadId(), entity.getPartNumber());
                return updatingEntity;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(entity.getPartUuid());
            }
            catch (ObjectStorageInternalException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot update state of object " + entity.getPartUuid()), (Throwable)e);
                throw new MetadataOperationFailureException(e);
            }
        }
    };
    static final Function<PartEntity, PartEntity> TRANSITION_TO_DELETING = new Function<PartEntity, PartEntity>(){

        @Nullable
        public PartEntity apply(@Nullable PartEntity objectToUpdate) {
            if (objectToUpdate == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                PartEntity entity = !Entities.isPersistent((Object)objectToUpdate) ? (PartEntity)Entities.uniqueResult((Object)new PartEntity().withUuid(objectToUpdate.getPartUuid())) : objectToUpdate;
                entity.setState((Enum)ObjectState.deleting);
                return entity;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(objectToUpdate.getPartUuid());
            }
            catch (Exception e) {
                throw new MetadataOperationFailureException(e);
            }
        }
    };
}

