/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.PaginatedResult;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageInternalException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchKeyException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.metadata.ObjectMetadataManager;
import com.eucalyptus.objectstorage.metadata.ObjectStateTransitions;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DbObjectMetadataManagerImpl
implements ObjectMetadataManager {
    private static final Logger LOG = Logger.getLogger(DbObjectMetadataManagerImpl.class);
    private static final Predicate<ObjectEntity> SET_LATEST_PREDICATE = new Predicate<ObjectEntity>(){

        public boolean apply(ObjectEntity example) {
            block6: {
                try {
                    example.setIsLatest(Boolean.valueOf(true));
                    example = example.withState(ObjectState.extant);
                    Criteria search = Entities.createCriteria(ObjectEntity.class);
                    search.add((Criterion)Example.create((Object)example)).addOrder(Order.desc((String)"objectModifiedTimestamp"));
                    search = DbObjectMetadataManagerImpl.getSearchByBucket(search, example.getBucket());
                    List results = search.list();
                    if (results == null || results.size() <= 1) break block6;
                    try {
                        for (ObjectEntity obj : results.subList(1, results.size())) {
                            obj.setIsLatest(Boolean.valueOf(false));
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                }
                catch (NoSuchElementException search) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error consolidating Object records for " + example.getResourceFullName()), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    };

    @Override
    public void start() throws Exception {
        LOG.trace((Object)"Starting DbObjectMetadataManager");
    }

    @Override
    public void stop() throws Exception {
        LOG.trace((Object)"Stopping DbObjectMetadataManager");
    }

    @Override
    public ObjectEntity initiateCreation(@Nonnull ObjectEntity objectToCreate) throws Exception {
        return this.transitionObjectToState(objectToCreate, ObjectState.creating);
    }

    @Override
    public ObjectEntity finalizeCreation(ObjectEntity objectToUpdate, Date updateTimestamp, String eTag) throws MetadataOperationFailureException {
        objectToUpdate.setObjectModifiedTimestamp(updateTimestamp);
        objectToUpdate.seteTag(eTag);
        objectToUpdate.setIsLatest(Boolean.valueOf(true));
        return this.transitionObjectToState(objectToUpdate, ObjectState.extant);
    }

    @Override
    public ObjectEntity finalizeMultipartInit(ObjectEntity objectToUpdate, Date updateTimestamp, String uploadId) throws MetadataOperationFailureException {
        objectToUpdate.setObjectModifiedTimestamp(updateTimestamp);
        objectToUpdate.setUploadId(uploadId);
        objectToUpdate.setIsLatest(Boolean.valueOf(false));
        return this.transitionObjectToState(objectToUpdate, ObjectState.mpu_pending);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ObjectEntity> lookupObjectsInState(@Nullable Bucket bucket, String objectKey, String versionId, ObjectState state) throws Exception {
        try (TransactionResource db = Entities.transactionFor(ObjectEntity.class);){
            Criteria search = Entities.createCriteria(ObjectEntity.class).add((Criterion)Example.create((Object)new ObjectEntity(bucket, objectKey, versionId).withState(state)));
            search.addOrder(Order.desc((String)"objectModifiedTimestamp"));
            if (bucket != null) {
                search = DbObjectMetadataManagerImpl.getSearchByBucket(search, bucket);
            }
            List results = search.list();
            db.commit();
            List list = results;
            return list;
        }
        catch (NoSuchElementException e) {
            return new ArrayList<ObjectEntity>(0);
        }
        catch (Exception e) {
            LOG.error((Object)("Error fetching pending write records for object " + (bucket == null ? "" : bucket.getBucketName()) + "/" + objectKey + "?versionId=" + versionId));
            throw e;
        }
    }

    @Override
    public List<ObjectEntity> lookupObjectsForReaping(Bucket bucket, String objectKeyPrefix, Date age) {
        List results;
        try (TransactionResource tran = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity example = new ObjectEntity().withState(ObjectState.extant).withBucket(bucket);
            Criteria search = Entities.createCriteria(ObjectEntity.class).add((Criterion)Example.create((Object)example));
            search.add((Criterion)Restrictions.and((Criterion)Restrictions.like((String)"objectKey", (String)objectKeyPrefix, (MatchMode)MatchMode.START), (Criterion)Restrictions.lt((String)"creationTimestamp", (Object)age)));
            search = DbObjectMetadataManagerImpl.getSearchByBucket(search, bucket);
            results = search.list();
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("exception caught while retrieving objects prefix with " + objectKeyPrefix + " from bucket " + bucket.getBucketName() + ", error message - " + ex.getMessage()));
            return Collections.EMPTY_LIST;
        }
        return results;
    }

    protected static Criteria getSearchByBucket(@Nonnull Criteria baseCriteria, @Nullable Bucket bucket) {
        if (bucket != null) {
            return baseCriteria.createCriteria("bucket").add((Criterion)Restrictions.eq((String)"naturalId", (Object)bucket.getNaturalId()));
        }
        return baseCriteria;
    }

    @Override
    public void cleanupInvalidObjects(Bucket bucket, String objectKey) throws Exception {
        ObjectEntity searchExample = new ObjectEntity(bucket, objectKey, null);
        Predicate<ObjectEntity> repairPredicate = new Predicate<ObjectEntity>(){

            public boolean apply(ObjectEntity example) {
                try {
                    ObjectEntity searchExample = new ObjectEntity().withKey(example.getObjectKey()).withBucket(example.getBucket()).withState(ObjectState.extant);
                    Criteria searchCriteria = Entities.createCriteria(ObjectEntity.class);
                    searchCriteria.add((Criterion)Example.create((Object)searchExample));
                    searchCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"versionId", (Object)"null"), (Criterion)Restrictions.eq((String)"isLatest", (Object)Boolean.TRUE)));
                    searchCriteria.addOrder(Order.desc((String)"objectModifiedTimestamp"));
                    searchCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(searchCriteria, example.getBucket());
                    List results = searchCriteria.list();
                    if (results.size() <= 1) {
                        return true;
                    }
                    ObjectEntity latest = (ObjectEntity)results.get(0);
                    latest.setIsLatest(Boolean.TRUE);
                    for (ObjectEntity obj : results.subList(1, results.size())) {
                        LOG.trace((Object)("Marking object " + obj.getObjectUuid() + " as no longer latest version"));
                        obj.setIsLatest(Boolean.FALSE);
                        if (latest.getVersionId() == null || !"null".equals(latest.getVersionId()) || obj.getVersionId() == null || !"null".equals(obj.getVersionId())) continue;
                        DbObjectMetadataManagerImpl.this.transitionObjectToState(obj, ObjectState.deleting);
                    }
                }
                catch (NoSuchElementException searchExample) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error consolidationg Object records for " + example.getBucket().getBucketName() + "/" + example.getObjectKey()));
                    return false;
                }
                return true;
            }
        };
        try {
            Entities.asTransaction((Predicate)repairPredicate).apply((Object)searchExample);
        }
        catch (Throwable f) {
            LOG.error((Object)"Error in version/null repair", f);
        }
    }

    @Override
    public void cleanupAllNullVersionedObjectRecords(final Bucket bucket, String objectKey) throws Exception {
        ObjectEntity searchExample = new ObjectEntity(bucket, objectKey, null);
        Predicate<ObjectEntity> repairPredicate = new Predicate<ObjectEntity>(){

            public boolean apply(ObjectEntity example) {
                try {
                    ObjectEntity searchExample = new ObjectEntity().withKey(example.getObjectKey()).withBucket(example.getBucket()).withState(ObjectState.extant).withVersionId("null");
                    Criteria searchCriteria = Entities.createCriteria(ObjectEntity.class);
                    searchCriteria.add((Criterion)Example.create((Object)searchExample));
                    searchCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(searchCriteria, bucket);
                    for (ObjectEntity obj : searchCriteria.list()) {
                        LOG.trace((Object)("Marking object " + obj.getObjectUuid() + " as no longer latest version"));
                        obj.setIsLatest(Boolean.valueOf(false));
                        obj = DbObjectMetadataManagerImpl.this.transitionObjectToState(obj, ObjectState.deleting);
                    }
                }
                catch (NoSuchElementException searchExample) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error consolidationg Object records for " + example.getBucket().getBucketName() + "/" + example.getObjectKey()));
                    return false;
                }
                return true;
            }
        };
        try {
            Entities.asTransaction((Predicate)repairPredicate).apply((Object)searchExample);
        }
        catch (Throwable f) {
            LOG.error((Object)"Error in version/null repair", f);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ObjectEntity> lookupFailedObjects() throws MetadataOperationFailureException {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity searchExample = new ObjectEntity().withState(ObjectState.creating);
            Criteria search = Entities.createCriteria(ObjectEntity.class);
            List results = search.add((Criterion)Example.create((Object)searchExample)).add((Criterion)Restrictions.lt((String)"creationExpiration", (Object)System.currentTimeMillis())).list();
            trans.commit();
            List list = results;
            return list;
        }
        catch (NoSuchElementException e) {
            return new ArrayList<ObjectEntity>(0);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error fetching failed or deleted object records");
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectEntity lookupObject(Bucket bucket, String objectKey, String versionId) throws NoSuchElementException, MetadataOperationFailureException {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity searchExample = new ObjectEntity().withBucket(bucket).withKey(objectKey).withState(ObjectState.extant);
            if (Strings.isNullOrEmpty((String)versionId)) {
                searchExample.setIsLatest(Boolean.valueOf(true));
            } else {
                searchExample = searchExample.withVersionId(versionId);
            }
            Criteria search = Entities.createCriteria(ObjectEntity.class).add((Criterion)Example.create((Object)searchExample)).addOrder(Order.desc((String)"objectModifiedTimestamp")).setMaxResults(1);
            search = DbObjectMetadataManagerImpl.getSearchByBucket(search, bucket);
            List results = search.list();
            if (results == null) throw new NoSuchElementException();
            if (results.size() < 1) {
                throw new NoSuchElementException();
            }
            if (results.size() > 1) {
                // empty if block
            }
            trans.commit();
            ObjectEntity objectEntity = (ObjectEntity)results.get(0);
            return objectEntity;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting object entity for " + bucket.getBucketName() + "/" + objectKey + "?version=" + versionId), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectEntity generateAndPersistDeleteMarker(@Nonnull ObjectEntity currentObject, @Nonnull AccessControlPolicy acp, @Nonnull User owningUser) throws MetadataOperationFailureException {
        ObjectEntity deleteMarker = currentObject.generateNewDeleteMarkerFrom();
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            deleteMarker.setOwnerCanonicalId(owningUser.getAccount().getCanonicalId());
            deleteMarker.setOwnerDisplayName(owningUser.getAccount().getName());
            deleteMarker.setOwnerIamUserDisplayName(owningUser.getName());
            deleteMarker.setOwnerIamUserId(owningUser.getUserId());
            deleteMarker.setAcl(acp);
            ObjectEntity persistedDeleteMarker = (ObjectEntity)Entities.persist((Object)deleteMarker);
            persistedDeleteMarker = ObjectMetadataManagers.getInstance().transitionObjectToState(persistedDeleteMarker, ObjectState.extant);
            trans.commit();
            ObjectEntity objectEntity = persistedDeleteMarker;
            return objectEntity;
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to persist the delete marker " + deleteMarker.getObjectUuid()));
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public void delete(@Nonnull ObjectEntity objectToDelete) throws IllegalResourceStateException, MetadataOperationFailureException {
        try {
            if (objectToDelete.getIsDeleteMarker().booleanValue()) {
                Transactions.delete((Object)objectToDelete);
                return;
            }
            boolean success = Entities.asTransaction(ObjectEntity.class, ObjectStateTransitions.TRANSITION_TO_DELETED).apply((Object)objectToDelete);
            if (!success) {
                throw new MetadataOperationFailureException("Delete operation returned false");
            }
        }
        catch (IllegalResourceStateException | MetadataOperationFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public void flushUploads(Bucket bucket) throws Exception {
        EntityTransaction db = Entities.get(ObjectEntity.class);
        try {
            Criteria search = Entities.createCriteria(ObjectEntity.class);
            ObjectEntity searchExample = new ObjectEntity().withBucket(bucket).withState(ObjectState.mpu_pending);
            search.add((Criterion)Example.create((Object)searchExample));
            search = DbObjectMetadataManagerImpl.getSearchByBucket(search, bucket);
            List uploads = search.list();
            for (ObjectEntity e : uploads) {
                Entities.delete((Object)e);
            }
            db.commit();
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
        finally {
            if (db != null && db.isActive()) {
                db.rollback();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectEntity lookupUpload(Bucket bucket, String objectKey, String uploadId) throws NoSuchElementException, MetadataOperationFailureException {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity searchExample = new ObjectEntity().withBucket(bucket).withKey(objectKey).withUploadId(uploadId).withState(ObjectState.mpu_pending);
            Criteria searchUploadId = Entities.createCriteria(ObjectEntity.class).add((Criterion)Example.create((Object)searchExample));
            searchUploadId = DbObjectMetadataManagerImpl.getSearchByBucket(searchUploadId, bucket);
            List results = searchUploadId.list();
            trans.commit();
            if (results == null) throw new NoSuchElementException();
            if (results.isEmpty()) {
                throw new NoSuchElementException();
            }
            ObjectEntity objectEntity = (ObjectEntity)results.get(0);
            return objectEntity;
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting object entity for " + bucket.getBucketName() + "/" + objectKey + "?uploadId=" + uploadId), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PaginatedResult<ObjectEntity> listUploads(Bucket bucket, int maxUploads, String prefix, String delimiter, String keyMarker, String uploadIdMarker) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            PaginatedResult<ObjectEntity> result = new PaginatedResult<ObjectEntity>();
            HashSet<String> commonPrefixes = new HashSet<String>();
            if (maxUploads < 0) throw new IllegalArgumentException("max uploads must be positive integer");
            int queryStrideSize = maxUploads + 1;
            ObjectEntity searchObj = new ObjectEntity();
            searchObj.withBucket(bucket);
            searchObj.withState(ObjectState.mpu_pending);
            Criteria objCriteria = Entities.createCriteria(ObjectEntity.class);
            objCriteria.setReadOnly(true);
            objCriteria.setFetchSize(queryStrideSize);
            objCriteria.add((Criterion)Example.create((Object)searchObj));
            objCriteria.addOrder(Order.asc((String)"objectKey"));
            objCriteria.addOrder(Order.asc((String)"uploadId"));
            objCriteria.setMaxResults(queryStrideSize);
            if (!Strings.isNullOrEmpty((String)keyMarker)) {
                if (!Strings.isNullOrEmpty((String)uploadIdMarker)) {
                    objCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"objectKey", (Object)keyMarker), (Criterion)Restrictions.gt((String)"uploadId", (Object)uploadIdMarker)), (Criterion)Restrictions.gt((String)"objectKey", (Object)keyMarker)));
                } else {
                    objCriteria.add((Criterion)Restrictions.gt((String)"objectKey", (Object)keyMarker));
                    uploadIdMarker = "";
                }
            } else {
                keyMarker = "";
                uploadIdMarker = "";
            }
            if (!Strings.isNullOrEmpty((String)prefix)) {
                objCriteria.add((Criterion)Restrictions.like((String)"objectKey", (String)prefix, (MatchMode)MatchMode.START));
            } else {
                prefix = "";
            }
            objCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(objCriteria, bucket);
            if (Strings.isNullOrEmpty((String)delimiter)) {
                delimiter = "";
            }
            List objectInfos = null;
            int resultKeyCount = 0;
            String[] parts = null;
            String prefixString = null;
            boolean useDelimiter = !Strings.isNullOrEmpty((String)delimiter);
            int pages = 0;
            block11: do {
                parts = null;
                prefixString = null;
                objCriteria.setFirstResult(pages++ * queryStrideSize);
                objectInfos = objCriteria.list();
                if (objectInfos == null) break;
                for (ObjectEntity objectRecord : objectInfos) {
                    if (useDelimiter && (parts = objectRecord.getObjectKey().substring(prefix.length()).split(delimiter, 2)).length > 1) {
                        prefixString = prefix + parts[0] + delimiter;
                        if (prefixString.equals(keyMarker) || commonPrefixes.contains(prefixString)) continue;
                        if (resultKeyCount == maxUploads) {
                            result.setIsTruncated(true);
                            ++resultKeyCount;
                            continue block11;
                        }
                        commonPrefixes.add(prefixString);
                        result.setLastEntry(prefixString);
                        ++resultKeyCount;
                        continue;
                    }
                    if (resultKeyCount == maxUploads) {
                        result.setIsTruncated(true);
                        ++resultKeyCount;
                        continue block11;
                    }
                    result.getEntityList().add(objectRecord);
                    result.setLastEntry(objectRecord);
                    ++resultKeyCount;
                }
            } while ((resultKeyCount > maxUploads || objectInfos.size() > maxUploads) && resultKeyCount <= maxUploads);
            if (commonPrefixes != null) {
                result.getCommonPrefixes().addAll(commonPrefixes);
                Collections.sort(result.getCommonPrefixes());
            }
            PaginatedResult<ObjectEntity> paginatedResult = result;
            return paginatedResult;
        }
        catch (Exception e) {
            LOG.error((Object)("Error generating paginated multipart upload list for bucket " + bucket.getBucketName()), (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectEntity setAcp(ObjectEntity object, AccessControlPolicy acp) throws S3Exception, TransactionException {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity extantEntity = (ObjectEntity)Entities.merge((Object)object);
            extantEntity.setAcl(acp);
            trans.commit();
            ObjectEntity objectEntity = extantEntity;
            return objectEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Error setting ACP on backend for object: " + object.getResourceFullName()));
            throw new InternalErrorException(object.getResourceFullName() + "?versionId=" + object.getVersionId());
        }
    }

    @Override
    public PaginatedResult<ObjectEntity> listPaginated(Bucket bucket, int maxKeys, String prefix, String delimiter, String startKey) throws Exception {
        return this.listVersionsPaginated(bucket, maxKeys, prefix, delimiter, startKey, null, true);
    }

    @Override
    public List<ObjectEntity> lookupObjectVersions(Bucket bucket, String objectKey, int numResults) throws Exception {
        ObjectEntity searchObj = new ObjectEntity().withBucket(bucket).withState(ObjectState.extant).withKey(objectKey);
        List objectInfos = null;
        try (TransactionResource tran = Entities.transactionFor(ObjectEntity.class);){
            Criteria objCriteria = Entities.createCriteria(ObjectEntity.class);
            objCriteria.setMaxResults(numResults);
            objCriteria.setReadOnly(true);
            objCriteria.add((Criterion)Example.create((Object)searchObj));
            objCriteria.addOrder(Order.desc((String)"objectModifiedTimestamp"));
            objCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(objCriteria, bucket);
            objectInfos = objCriteria.list();
            tran.commit();
        }
        catch (Exception ex) {
            LOG.warn((Object)("exception caught while retrieving all versions of object " + objectKey + " in bucket " + bucket.getBucketName()));
            throw ex;
        }
        return objectInfos;
    }

    @Override
    public ObjectEntity makeLatest(ObjectEntity entity) throws Exception {
        ObjectEntity retrieved = null;
        try (TransactionResource tran = Entities.transactionFor(ObjectEntity.class);){
            retrieved = this.lookupObject(entity.getBucket(), entity.getObjectKey(), entity.getVersionId());
            retrieved.setIsLatest(Boolean.TRUE);
            Entities.mergeDirect((Object)retrieved);
            tran.commit();
        }
        catch (Exception ex) {
            LOG.warn((Object)"while attempting to set isLatest = true on the newest remaining object version, an exception was encountered: ", (Throwable)ex);
            throw ex;
        }
        return retrieved;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectEntity makeNotLatest(ObjectEntity entity) throws Exception {
        try (TransactionResource tran = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity retrieved = (ObjectEntity)Entities.merge((Object)entity);
            retrieved.setIsLatest(Boolean.FALSE);
            tran.commit();
            ObjectEntity objectEntity = retrieved;
            return objectEntity;
        }
        catch (Exception ex) {
            LOG.warn((Object)"while attempting to set isLatest = true on the newest remaining object version, an exception was encountered: ", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public PaginatedResult<ObjectEntity> listVersionsPaginated(Bucket bucket, int maxEntries, String prefix, String delimiter, String fromKeyMarker, String fromVersionId, boolean latestOnly) throws Exception {
        EntityTransaction db = Entities.get(ObjectEntity.class);
        try {
            PaginatedResult<ObjectEntity> result = new PaginatedResult<ObjectEntity>();
            HashSet<String> commonPrefixes = new HashSet<String>();
            if (maxEntries >= 0) {
                int queryStrideSize = maxEntries + 1;
                ObjectEntity searchObj = new ObjectEntity().withBucket(bucket).withState(ObjectState.extant);
                if (latestOnly) {
                    searchObj.setIsLatest(Boolean.valueOf(true));
                    searchObj.setIsDeleteMarker(Boolean.valueOf(false));
                }
                Criteria objCriteria = Entities.createCriteria(ObjectEntity.class);
                objCriteria.setReadOnly(true);
                objCriteria.setFetchSize(queryStrideSize);
                objCriteria.add((Criterion)Example.create((Object)searchObj));
                objCriteria.addOrder(Order.asc((String)"objectKey"));
                objCriteria.addOrder(Order.desc((String)"objectModifiedTimestamp"));
                objCriteria.setMaxResults(queryStrideSize);
                if (!Strings.isNullOrEmpty((String)fromKeyMarker)) {
                    if (!Strings.isNullOrEmpty((String)fromVersionId)) {
                        ObjectEntity searchObject = new ObjectEntity(bucket, fromKeyMarker, fromVersionId);
                        ObjectEntity matchingObject = null;
                        try {
                            matchingObject = (ObjectEntity)Entities.uniqueResult((Object)searchObject);
                            if (matchingObject == null || matchingObject.getObjectModifiedTimestamp() == null) {
                                throw new NoSuchKeyException(bucket.getBucketName() + "/" + fromKeyMarker + "?versionId=" + fromVersionId);
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("No matching object found for key-marker=" + fromKeyMarker + " and version-id-marker=" + fromVersionId));
                            throw new NoSuchKeyException(bucket.getBucketName() + "/" + fromKeyMarker + "?versionId=" + fromVersionId);
                        }
                        objCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"objectKey", (Object)fromKeyMarker), (Criterion)Restrictions.lt((String)"objectModifiedTimestamp", (Object)matchingObject.getObjectModifiedTimestamp())), (Criterion)Restrictions.gt((String)"objectKey", (Object)fromKeyMarker)));
                    } else {
                        objCriteria.add((Criterion)Restrictions.gt((String)"objectKey", (Object)fromKeyMarker));
                    }
                }
                if (!Strings.isNullOrEmpty((String)prefix)) {
                    objCriteria.add((Criterion)Restrictions.like((String)"objectKey", (String)prefix, (MatchMode)MatchMode.START));
                } else {
                    prefix = "";
                }
                objCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(objCriteria, bucket);
                if (Strings.isNullOrEmpty((String)delimiter)) {
                    delimiter = "";
                }
                List objectInfos = null;
                int resultKeyCount = 0;
                String[] parts = null;
                String prefixString = null;
                boolean useDelimiter = !Strings.isNullOrEmpty((String)delimiter);
                int pages = 0;
                block7: do {
                    parts = null;
                    prefixString = null;
                    objCriteria.setFirstResult(pages++ * queryStrideSize);
                    objectInfos = objCriteria.list();
                    if (objectInfos == null) break;
                    for (ObjectEntity objectRecord : objectInfos) {
                        if (useDelimiter && (parts = objectRecord.getObjectKey().substring(prefix.length()).split(delimiter, 2)).length > 1) {
                            prefixString = prefix + parts[0] + delimiter;
                            if (prefixString.equals(fromKeyMarker) || commonPrefixes.contains(prefixString)) continue;
                            if (resultKeyCount == maxEntries) {
                                result.setIsTruncated(true);
                                ++resultKeyCount;
                                continue block7;
                            }
                            commonPrefixes.add(prefixString);
                            result.setLastEntry(prefixString);
                            ++resultKeyCount;
                            continue;
                        }
                        if (resultKeyCount == maxEntries) {
                            result.setIsTruncated(true);
                            ++resultKeyCount;
                            continue block7;
                        }
                        result.getEntityList().add(objectRecord);
                        result.setLastEntry(objectRecord);
                        ++resultKeyCount;
                    }
                } while ((resultKeyCount > maxEntries || objectInfos.size() > maxEntries) && resultKeyCount <= maxEntries);
                if (commonPrefixes != null) {
                    result.getCommonPrefixes().addAll(commonPrefixes);
                    Collections.sort(result.getCommonPrefixes());
                }
            } else {
                throw new IllegalArgumentException("MaxKeys must be positive integer");
            }
            PaginatedResult<ObjectEntity> paginatedResult = result;
            return paginatedResult;
        }
        catch (Exception e) {
            LOG.error((Object)("Error generating paginated object list of bucket " + bucket.getBucketName()), (Throwable)e);
            throw e;
        }
        finally {
            db.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countValid(Bucket bucket) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            Criteria queryCriteria = Entities.createCriteria(ObjectEntity.class).add((Criterion)Restrictions.eq((String)"state", (Object)ObjectState.extant)).setProjection(Projections.rowCount());
            queryCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(queryCriteria, bucket);
            queryCriteria.setReadOnly(true);
            Number count = (Number)queryCriteria.uniqueResult();
            trans.commit();
            long l = count.longValue();
            return l;
        }
        catch (Throwable e) {
            LOG.error((Object)("Error getting object count for bucket " + bucket.getBucketName()), e);
            throw new Exception(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTotalSize(Bucket bucket) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            Criteria queryCriteria = Entities.createCriteria(ObjectEntity.class).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"state", (Object)ObjectState.creating), (Criterion)Restrictions.eq((String)"state", (Object)ObjectState.extant))).setProjection((Projection)Projections.sum((String)"size"));
            if (bucket != null) {
                queryCriteria = DbObjectMetadataManagerImpl.getSearchByBucket(queryCriteria, bucket);
            }
            queryCriteria.setReadOnly(true);
            Number count = (Number)queryCriteria.uniqueResult();
            long l = count == null ? 0L : count.longValue();
            return l;
        }
        catch (Throwable e) {
            LOG.error((Object)("Error getting object total size for " + (bucket == null ? "all buckets" : "bucket " + bucket.getBucketName())), e);
            throw new Exception(e);
        }
    }

    @Override
    public ObjectEntity transitionObjectToState(@Nonnull ObjectEntity entity, @Nonnull ObjectState destState) throws IllegalResourceStateException, MetadataOperationFailureException {
        Function<ObjectEntity, ObjectEntity> transitionFunction;
        switch (destState) {
            case creating: {
                transitionFunction = ObjectStateTransitions.TRANSITION_TO_CREATING;
                break;
            }
            case extant: {
                transitionFunction = ObjectStateTransitions.TRANSITION_TO_EXTANT;
                break;
            }
            case mpu_pending: {
                transitionFunction = ObjectStateTransitions.TRANSITION_TO_MPU_PENDING;
                break;
            }
            case deleting: {
                transitionFunction = ObjectStateTransitions.TRANSITION_TO_DELETING;
                break;
            }
            default: {
                LOG.error((Object)("Unexpected destination state: " + destState));
                throw new IllegalArgumentException();
            }
        }
        try {
            ObjectEntity result = (ObjectEntity)Entities.asTransaction(ObjectEntity.class, transitionFunction).apply((Object)entity);
            return result;
        }
        catch (ObjectStorageInternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectEntity updateCreationTimeout(ObjectEntity entity) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(ObjectEntity.class);){
            ObjectEntity mergedEntity = (ObjectEntity)Entities.merge((Object)entity);
            if (ObjectState.creating.equals((Object)mergedEntity.getState())) {
                mergedEntity.updateCreationExpiration();
            }
            Entities.flush((Object)mergedEntity);
            trans.commit();
            ObjectEntity objectEntity = mergedEntity;
            return objectEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Error updating progress timeout for object " + entity.getObjectUuid()));
            throw e;
        }
    }
}

