/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.PaginatedResult;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.PartEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageInternalException;
import com.eucalyptus.objectstorage.exceptions.s3.EntityTooSmallException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidArgumentException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidPartException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidPartOrderException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.metadata.MpuPartMetadataManager;
import com.eucalyptus.objectstorage.metadata.MpuPartStateTransitions;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.Part;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DbMpuPartMetadataManagerImpl
implements MpuPartMetadataManager {
    private static final Logger LOG = Logger.getLogger(DbMpuPartMetadataManagerImpl.class);
    private static final Predicate<PartEntity> SET_LATEST_PREDICATE = new Predicate<PartEntity>(){

        public boolean apply(PartEntity example) {
            block6: {
                try {
                    example.setIsLatest(Boolean.valueOf(true));
                    example = example.withState(ObjectState.extant);
                    Criteria search = Entities.createCriteria(PartEntity.class);
                    search.add((Criterion)Example.create((Object)example)).addOrder(Order.desc((String)"objectModifiedTimestamp"));
                    search = DbMpuPartMetadataManagerImpl.getSearchByBucket(search, example.getBucket());
                    List results = search.list();
                    if (results == null || results.size() <= 1) break block6;
                    try {
                        for (PartEntity obj : results.subList(1, results.size())) {
                            obj.setIsLatest(Boolean.valueOf(false));
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                }
                catch (NoSuchElementException search) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error consolidating Object records for " + example.getResourceFullName()), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    };
    private static final Comparator timestampComparator = new Comparator<PartEntity>(){

        @Override
        public int compare(PartEntity objectEntity, PartEntity objectEntity2) {
            return objectEntity2.getObjectModifiedTimestamp().compareTo(objectEntity.getObjectModifiedTimestamp());
        }
    };

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public PartEntity initiatePartCreation(@Nonnull PartEntity objectToCreate) throws Exception {
        return this.transitionPartToState(objectToCreate, ObjectState.creating);
    }

    @Override
    public PartEntity finalizeCreation(PartEntity objectToUpdate, Date updateTimestamp, String eTag) throws MetadataOperationFailureException {
        objectToUpdate.setObjectModifiedTimestamp(updateTimestamp);
        objectToUpdate.seteTag(eTag);
        objectToUpdate.setIsLatest(Boolean.valueOf(true));
        return this.transitionPartToState(objectToUpdate, ObjectState.extant);
    }

    protected static Criteria getSearchByBucket(@Nonnull Criteria baseCriteria, @Nullable Bucket bucket) {
        if (bucket != null) {
            return baseCriteria.createCriteria("bucket").add((Criterion)Restrictions.eq((String)"naturalId", (Object)bucket.getNaturalId()));
        }
        return baseCriteria;
    }

    @Override
    public void cleanupInvalidParts(Bucket bucket, String objectKey, String uploadId, int partNumber) throws Exception {
        PartEntity searchExample = new PartEntity(bucket, objectKey, uploadId).withPartNumber(partNumber);
        Predicate<PartEntity> repairPredicate = new Predicate<PartEntity>(){

            public boolean apply(PartEntity example) {
                try {
                    PartEntity searchExample = new PartEntity().withKey(example.getObjectKey()).withBucket(example.getBucket()).withState(ObjectState.extant).withUploadId(example.getUploadId()).withPartNumber(example.getPartNumber().intValue());
                    Criteria searchCriteria = Entities.createCriteria(PartEntity.class);
                    searchCriteria.add((Criterion)Example.create((Object)searchExample)).addOrder(Order.desc((String)"objectModifiedTimestamp"));
                    searchCriteria = DbMpuPartMetadataManagerImpl.getSearchByBucket(searchCriteria, example.getBucket());
                    List results = searchCriteria.list();
                    if (results.size() <= 1) {
                        return true;
                    }
                    ((PartEntity)results.get(0)).setIsLatest(Boolean.valueOf(true));
                    for (PartEntity obj : results.subList(1, results.size())) {
                        LOG.trace((Object)("Marking mpu part " + obj.getPartUuid() + " as no longer latest version and for cleanup"));
                        obj.setIsLatest(Boolean.valueOf(false));
                        obj = DbMpuPartMetadataManagerImpl.this.transitionPartToState(obj, ObjectState.deleting);
                    }
                }
                catch (NoSuchElementException searchExample) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Error consolidating PartEntity records for " + example.getBucket().getBucketName() + "/" + example.getObjectKey() + " uploadId = " + example.getUploadId() + " partNumber = " + example.getPartNumber()));
                    return false;
                }
                return true;
            }
        };
        try {
            Entities.asTransaction((Predicate)repairPredicate).apply((Object)searchExample);
        }
        catch (Throwable f) {
            LOG.error((Object)"Error in version/null repair", f);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PartEntity> lookupFailedParts() throws MetadataOperationFailureException {
        try (TransactionResource trans = Entities.transactionFor(PartEntity.class);){
            PartEntity searchExample = new PartEntity().withState(ObjectState.creating);
            Criteria search = Entities.createCriteria(PartEntity.class);
            List results = search.add((Criterion)Example.create((Object)searchExample)).add((Criterion)Restrictions.lt((String)"creationExpiration", (Object)System.currentTimeMillis())).list();
            trans.commit();
            List list = results;
            return list;
        }
        catch (NoSuchElementException e) {
            return new ArrayList<PartEntity>(0);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error fetching failed or deleted object records");
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public void delete(@Nonnull PartEntity objectToDelete) throws IllegalResourceStateException, MetadataOperationFailureException {
        try {
            Transactions.delete((Object)objectToDelete);
        }
        catch (IllegalResourceStateException | MetadataOperationFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartEntity> lookupPartsInState(Bucket searchBucket, String searchKey, String uploadId, ObjectState state) throws Exception {
        EntityTransaction db = Entities.get(PartEntity.class);
        try {
            Criteria search = Entities.createCriteria(PartEntity.class);
            PartEntity searchExample = new PartEntity().withBucket(searchBucket).withKey(searchKey).withUploadId(uploadId).withState(state);
            search.add((Criterion)Example.create((Object)searchExample));
            if (searchBucket != null) {
                search = DbMpuPartMetadataManagerImpl.getSearchByBucket(search, searchBucket);
            }
            List results = search.list();
            db.commit();
            List list = results;
            return list;
        }
        finally {
            if (db != null && db.isActive()) {
                db.rollback();
            }
        }
    }

    @Override
    public void removeParts(Bucket bucket, String uploadId) throws Exception {
        Predicate<String> removePredicate = new Predicate<String>(){

            public boolean apply(String uploadId) {
                try (TransactionResource db = Entities.transactionFor(PartEntity.class);){
                    PartEntity searchExample = new PartEntity().withUploadId(uploadId).withState(ObjectState.extant);
                    long size = ((Number)Objects.firstNonNull((Object)((Number)Entities.createCriteria(PartEntity.class).add((Criterion)Example.create((Object)searchExample)).setProjection((Projection)Projections.sum((String)"size")).setReadOnly(true).uniqueResult()), (Object)0)).longValue();
                    Entities.deleteAllMatching(PartEntity.class, (String)"where part_number IS NOT NULL and upload_id=:uploadId", Collections.singletonMap("uploadId", uploadId));
                    db.commit();
                }
                catch (Exception e) {
                    LOG.trace((Object)"Error finalizing part-removal transaction. Will retry.", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return true;
            }
        };
        Entities.asTransaction(PartEntity.class, (Predicate)removePredicate).apply((Object)uploadId);
    }

    @Override
    public void flushAllParts(Bucket bucket) throws Exception {
        try (TransactionResource db = Entities.transactionFor(PartEntity.class);){
            Criteria search = Entities.createCriteria(PartEntity.class);
            PartEntity searchExample = new PartEntity().withBucket(bucket);
            search.add((Criterion)Example.create((Object)searchExample));
            search = DbMpuPartMetadataManagerImpl.getSearchByBucket(search, bucket);
            List uploads = search.list();
            for (PartEntity e : uploads) {
                Entities.delete((Object)e);
            }
            db.commit();
        }
    }

    @Override
    public PartEntity transitionPartToState(@Nonnull PartEntity entity, @Nonnull ObjectState destState) throws IllegalResourceStateException, MetadataOperationFailureException {
        Function<PartEntity, PartEntity> transitionFunction;
        switch (destState) {
            case creating: {
                transitionFunction = MpuPartStateTransitions.TRANSITION_TO_CREATING;
                break;
            }
            case extant: {
                transitionFunction = MpuPartStateTransitions.TRANSITION_TO_EXTANT;
                break;
            }
            case deleting: {
                transitionFunction = MpuPartStateTransitions.TRANSITION_TO_DELETING;
                break;
            }
            default: {
                LOG.error((Object)("Unexpected destination state: " + destState));
                throw new IllegalArgumentException();
            }
        }
        try {
            return (PartEntity)Entities.asTransaction(PartEntity.class, transitionFunction).apply((Object)entity);
        }
        catch (ObjectStorageInternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PartEntity updateCreationTimeout(PartEntity entity) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(PartEntity.class);){
            PartEntity mergedEntity = (PartEntity)Entities.merge((Object)entity);
            if (ObjectState.creating.equals((Object)mergedEntity.getState())) {
                mergedEntity.updateCreationExpiration();
            }
            Entities.flush((Object)mergedEntity);
            trans.commit();
            PartEntity partEntity = mergedEntity;
            return partEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Error updating progress timeout for object " + entity.getPartUuid()));
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap<Integer, PartEntity> getParts(Bucket bucket, String objectKey, String uploadId) throws Exception {
        HashMap<Integer, PartEntity> parts = new HashMap<Integer, PartEntity>();
        try (TransactionResource trans = Entities.transactionFor(PartEntity.class);){
            Criteria search = Entities.createCriteria(PartEntity.class);
            PartEntity searchExample = new PartEntity(bucket, objectKey, uploadId).withState(ObjectState.extant);
            search.add((Criterion)Example.create((Object)searchExample));
            search = DbMpuPartMetadataManagerImpl.getSearchByBucket(search, bucket);
            List results = search.list();
            trans.commit();
            for (PartEntity result : results) {
                parts.put(result.getPartNumber(), result);
            }
            HashMap<Integer, PartEntity> hashMap = parts;
            return hashMap;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error looking up parts for MPU id : " + uploadId));
            throw e;
        }
    }

    private void doConsolidateParts(Bucket bucket, String objectKey, String uploadId, Integer partNumber) {
        PartEntity searchExample = new PartEntity(bucket, objectKey, uploadId).withPartNumber(partNumber.intValue());
        searchExample = searchExample.withState(ObjectState.extant);
        Predicate<PartEntity> repairPredicate = new Predicate<PartEntity>(){

            public boolean apply(PartEntity example) {
                block6: {
                    try {
                        Criteria search = Entities.createCriteria(PartEntity.class);
                        List results = search.add((Criterion)Example.create((Object)example)).addOrder(Order.desc((String)"objectModifiedTimestamp")).list();
                        if (results == null || results.size() <= 0) break block6;
                        try {
                            for (PartEntity partEntity : results.subList(1, results.size())) {
                                LOG.trace((Object)("Marking part " + partEntity.getBucket().getBucketName() + " uploadId: " + partEntity.getUploadId() + " partNumber: " + partEntity.getPartNumber() + " for deletion because it is not latest."));
                                MpuPartMetadataManagers.getInstance().transitionPartToState(partEntity, ObjectState.deleting);
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        }
                    }
                    catch (NoSuchElementException search) {
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error consolidationg Part records for " + example.getBucket().getBucketName() + " uploadId: " + example.getUploadId() + " partNumber: " + example.getPartNumber()));
                        return false;
                    }
                }
                return true;
            }
        };
        try {
            Entities.asTransaction((Predicate)repairPredicate).apply((Object)searchExample);
        }
        catch (Throwable f) {
            LOG.error((Object)"Error in part repair", f);
        }
    }

    @Override
    public long processPartListAndGetSize(List<Part> partsInManifest, HashMap<Integer, PartEntity> availableParts) throws S3Exception {
        int lastPartNumber = 0;
        long objectSize = 0L;
        int numPartsProcessed = 0;
        for (Part partInManifest : partsInManifest) {
            Integer partNumber = partInManifest.getPartNumber();
            if (partNumber < ObjectStorageProperties.MIN_PART_NUMBER || partNumber > ObjectStorageProperties.MAX_PART_NUMBER) {
                throw new InvalidArgumentException("PartNumber", "Part number must be an integer between " + ObjectStorageProperties.MIN_PART_NUMBER + " and " + ObjectStorageProperties.MAX_PART_NUMBER + ", inclusive");
            }
            if (partNumber <= lastPartNumber) {
                throw new InvalidPartOrderException("partNumber: " + partNumber);
            }
            PartEntity actualPart = availableParts.get(partNumber);
            if (actualPart == null) {
                throw new InvalidPartException("partNumber: " + partNumber);
            }
            long actualPartSize = actualPart.getSize();
            if (++numPartsProcessed < partsInManifest.size() && actualPartSize < ObjectStorageProperties.MPU_PART_MIN_SIZE) {
                throw new EntityTooSmallException("uploadId: " + actualPart.getUploadId() + " partNumber: " + partNumber);
            }
            objectSize += actualPartSize;
            lastPartNumber = partNumber;
        }
        return objectSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTotalSize(Bucket bucket) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(PartEntity.class);){
            Criteria queryCriteria = Entities.createCriteria(PartEntity.class).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"state", (Object)ObjectState.creating), (Criterion)Restrictions.eq((String)"state", (Object)ObjectState.extant))).setProjection((Projection)Projections.sum((String)"size"));
            if (bucket != null) {
                queryCriteria = DbMpuPartMetadataManagerImpl.getSearchByBucket(queryCriteria, bucket);
            }
            queryCriteria.setReadOnly(true);
            Number count = (Number)queryCriteria.uniqueResult();
            long l = count == null ? 0L : count.longValue();
            return l;
        }
        catch (Throwable e) {
            LOG.error((Object)("Error getting part total size for bucket " + bucket.getBucketName()), e);
            throw new Exception(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PaginatedResult<PartEntity> listPartsForUpload(Bucket bucket, String objectKey, String uploadId, int partNumberMarker, int maxParts) throws Exception {
        EntityTransaction db = Entities.get(PartEntity.class);
        try {
            PaginatedResult<PartEntity> result = new PaginatedResult<PartEntity>();
            HashSet commonPrefixes = new HashSet();
            if (maxParts < 0) throw new IllegalArgumentException("MaxKeys must be positive integer");
            int queryStrideSize = maxParts + 1;
            PartEntity searchPart = new PartEntity(bucket, objectKey, uploadId).withState(ObjectState.extant);
            Criteria objCriteria = Entities.createCriteria(PartEntity.class);
            objCriteria.setReadOnly(true);
            objCriteria.setFetchSize(queryStrideSize);
            objCriteria.add((Criterion)Example.create((Object)searchPart));
            objCriteria.addOrder(Order.asc((String)"partNumber"));
            objCriteria.setMaxResults(queryStrideSize);
            if (partNumberMarker > 0) {
                objCriteria.add((Criterion)Restrictions.gt((String)"partNumber", (Object)partNumberMarker));
            }
            objCriteria = DbMpuPartMetadataManagerImpl.getSearchByBucket(objCriteria, bucket);
            List partInfos = null;
            int resultKeyCount = 0;
            Object parts = null;
            int pages = 0;
            block5: do {
                parts = null;
                objCriteria.setFirstResult(pages++ * queryStrideSize);
                partInfos = objCriteria.list();
                if (partInfos == null) break;
                for (PartEntity partRecord : partInfos) {
                    if (resultKeyCount == maxParts) {
                        result.setIsTruncated(true);
                        ++resultKeyCount;
                        continue block5;
                    }
                    result.getEntityList().add(partRecord);
                    result.setLastEntry(partRecord);
                    ++resultKeyCount;
                }
            } while ((resultKeyCount > maxParts || partInfos.size() > maxParts) && resultKeyCount <= maxParts);
            PaginatedResult<PartEntity> paginatedResult = result;
            return paginatedResult;
        }
        catch (Exception e) {
            LOG.error((Object)("Error generating paginated parts list for upload ID " + uploadId), (Throwable)e);
            throw e;
        }
        finally {
            db.rollback();
        }
    }
}

