/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.objectstorage.BucketTaggingManagers;
import com.eucalyptus.objectstorage.entities.BucketTags;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageException;
import com.eucalyptus.objectstorage.metadata.BucketTaggingManager;
import com.eucalyptus.storage.msgs.s3.BucketTag;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DbBucketTaggingManagerImpl
implements BucketTaggingManager {
    private static Logger LOG = Logger.getLogger(DbBucketTaggingManagerImpl.class);

    @Override
    public void addBucketTagging(@Nonnull List<BucketTag> tags, @Nonnull String bucketUuid) throws ObjectStorageException {
        try (TransactionResource tx = Entities.transactionFor(BucketTags.class);){
            BucketTaggingManagers.getInstance().deleteBucketTagging(bucketUuid);
            for (BucketTag bucketTag : tags) {
                BucketTags entity = new BucketTags();
                entity.setBucketUuid(bucketUuid);
                entity.setKey(bucketTag.getKey());
                entity.setValue(bucketTag.getValue());
                Entities.merge((Object)entity);
            }
            tx.commit();
        }
        catch (Exception e) {
            LOG.trace((Object)("Error in setting entity for tagging to database" + e));
            throw new ObjectStorageException("InternalServerError", "An exception was caught while adding TagSet for bucket - " + bucketUuid, "Bucket", bucketUuid, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public void deleteBucketTagging(@Nonnull String bucketUuid) throws ObjectStorageException {
        try (TransactionResource tx = Entities.transactionFor(BucketTags.class);){
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("bucketUuid", bucketUuid);
            Entities.deleteAllMatching(BucketTags.class, (String)"WHERE bucketUuid = :bucketUuid", parameters);
            tx.commit();
        }
        catch (Exception e) {
            LOG.trace((Object)("Error in deleting entity for tagging to database" + e));
            throw new ObjectStorageException("InternalServerError", "An exception was caught while deleting TagSet for bucket - " + bucketUuid, "Bucket", bucketUuid, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BucketTags> getBucketTagging(@Nonnull String bucketUuid) throws NoSuchEntityException, ObjectStorageException {
        try (TransactionResource tx = Entities.transactionFor(BucketTags.class);){
            List resultTags = Entities.query((Object)new BucketTags().withUuid(bucketUuid));
            tx.commit();
            List list = resultTags;
            return list;
        }
        catch (Exception e) {
            LOG.trace((Object)("Error in getting entity for tagging to database: " + e));
            throw new ObjectStorageException("InternalServerError", "An exception was caught while deleting TagSet for bucket - " + bucketUuid, "Bucket", bucketUuid, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

