/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.metadata.BucketMetadataManager;
import com.eucalyptus.objectstorage.metadata.BucketStateTransitions;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.PersistentObjectException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

public class DbBucketMetadataManagerImpl
implements BucketMetadataManager {
    private static final Logger LOG = Logger.getLogger(DbBucketMetadataManagerImpl.class);

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public Bucket persistBucketInCreatingState(@Nonnull String bucketName, @Nonnull AccessControlPolicy acp, @Nullable String iamUserId, @Nullable String location) throws IllegalResourceStateException, MetadataOperationFailureException, NoSuchEntityException {
        Bucket initialized;
        try {
            initialized = Bucket.getInitializedBucket((String)bucketName, (String)iamUserId, (AccessControlPolicy)acp, (String)location);
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
        return this.transitionBucketToState(initialized, BucketState.creating);
    }

    @Override
    public Bucket lookupExtantBucket(@Nonnull String bucketName) throws NoSuchEntityException, MetadataOperationFailureException {
        try {
            Bucket searchExample = new Bucket(bucketName).withState(BucketState.extant);
            return (Bucket)Transactions.find((Object)searchExample);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketName);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error querying bucket existence in db", (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public Bucket lookupBucket(@Nonnull String bucketName) throws NoSuchEntityException, MetadataOperationFailureException {
        try {
            Bucket searchExample = new Bucket(bucketName);
            return (Bucket)Transactions.find((Object)searchExample);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketName);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error querying bucket existence in db", (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public Bucket lookupBucketByUuid(@Nonnull String bucketUuid) throws NoSuchEntityException, MetadataOperationFailureException {
        try {
            Bucket searchExample = new Bucket().withUuid(bucketUuid);
            return (Bucket)Transactions.find((Object)searchExample);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketUuid);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error querying bucket existence in db", (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public List<Bucket> getBucketsForDeletion() throws Exception {
        try {
            Bucket searchBucket = new Bucket().withState(BucketState.deleting);
            return Transactions.findAll((Object)searchBucket);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error querying bucket existence in db", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Bucket transitionBucketToState(@Nonnull Bucket bucket, @Nonnull BucketState destState) throws NoSuchEntityException, IllegalResourceStateException, MetadataOperationFailureException {
        Function<Bucket, Bucket> transitionFunction = null;
        switch (destState) {
            case creating: {
                transitionFunction = BucketStateTransitions.TRANSITION_TO_CREATING;
                break;
            }
            case extant: {
                transitionFunction = BucketStateTransitions.TRANSITION_TO_EXTANT;
                break;
            }
            case deleting: {
                transitionFunction = BucketStateTransitions.TRANSITION_TO_DELETING;
                break;
            }
            default: {
                LOG.error((Object)("Unexpected destination state: " + destState));
                throw new IllegalArgumentException();
            }
        }
        try {
            return (Bucket)Entities.asTransaction(Bucket.class, transitionFunction).apply((Object)bucket);
        }
        catch (IllegalResourceStateException e) {
            throw e;
        }
        catch (ConstraintViolationException e) {
            IllegalResourceStateException ex = new IllegalResourceStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (PersistentObjectException e) {
            throw new NoSuchEntityException("Bucket entity not found for merge", e);
        }
        catch (Exception e) {
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public void deleteBucketMetadata(@Nonnull Bucket bucket) throws Exception {
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Bucket bucketToDelete = (Bucket)Entities.uniqueResult((Object)bucket);
            if (!BucketState.deleting.equals((Object)bucketToDelete.getState())) {
                throw new IllegalResourceStateException("Bucket not in deleting state, no valid transition to deleted", null, BucketState.deleting.toString(), ((BucketState)bucketToDelete.getState()).toString());
            }
            Entities.delete((Object)bucketToDelete);
            trans.commit();
        }
        catch (NoSuchElementException e) {
            LOG.trace((Object)("Bucket deletion finalization for (bucket uuid) " + bucket.getBucketUuid() + " failed to find entity record. Returning normally"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Bucket> lookupBucketsByOwner(String ownerCanonicalId) throws MetadataOperationFailureException {
        Bucket searchBucket = new Bucket().withState(BucketState.extant);
        searchBucket.setOwnerCanonicalId(ownerCanonicalId);
        List buckets = null;
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Criteria searchCriteria = Entities.createCriteria(Bucket.class);
            Example example = Example.create((Object)searchBucket);
            searchCriteria.add((Criterion)example);
            searchCriteria.addOrder(Order.asc((String)"bucketName"));
            searchCriteria.setReadOnly(true);
            buckets = searchCriteria.list();
            trans.commit();
            List list = buckets;
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)("Error listing buckets for user " + ownerCanonicalId + " due to DB transaction error"), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Bucket> lookupBucketsByState(BucketState state) throws TransactionException {
        Bucket searchBucket = new Bucket().withState(state);
        List buckets = null;
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Criteria searchCriteria = Entities.createCriteria(Bucket.class);
            Example example = Example.create((Object)searchBucket);
            searchCriteria.add((Criterion)example);
            searchCriteria.addOrder(Order.asc((String)"bucketName"));
            searchCriteria.setReadOnly(true);
            buckets = searchCriteria.list();
            trans.commit();
            List list = buckets;
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)("Error listing buckets in the state: " + state + " due to DB transaction error"), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<Bucket> lookupBucketsByUser(String userIamId) throws MetadataOperationFailureException {
        Bucket searchBucket = new Bucket().withState(BucketState.extant);
        searchBucket.setOwnerIamUserId(userIamId);
        List buckets = null;
        try {
            buckets = Transactions.findAll((Object)searchBucket);
            return buckets;
        }
        catch (TransactionException e) {
            LOG.error((Object)("Error listing buckets for user " + userIamId + " due to DB transaction error"), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countBucketsByUser(String userIamId) throws MetadataOperationFailureException {
        Bucket searchBucket = new Bucket();
        searchBucket.setOwnerIamUserId(userIamId);
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            long l = Entities.count((Object)searchBucket, (Criterion)Restrictions.ne((String)"state", (Object)BucketState.deleting), new HashMap());
            return l;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error counting buckets for user " + userIamId + " due to DB transaction error"), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countBucketsByAccount(String canonicalId) throws MetadataOperationFailureException {
        Bucket searchBucket = new Bucket();
        searchBucket.setOwnerCanonicalId(canonicalId);
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            long l = Entities.count((Object)searchBucket, (Criterion)Restrictions.ne((String)"state", (Object)BucketState.deleting), new HashMap());
            return l;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error counting buckets for account canonicalId " + canonicalId + " due to DB transaction error"), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bucket setAcp(@Nonnull Bucket bucketEntity, @Nonnull String jsonMarshalledAcl) throws MetadataOperationFailureException, NoSuchEntityException {
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Bucket bucket = (Bucket)Entities.merge((Object)bucketEntity);
            bucket.setAcl(jsonMarshalledAcl);
            trans.commit();
            Bucket bucket2 = bucket;
            return bucket2;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketEntity.getBucketName());
        }
        catch (Exception e) {
            LOG.error((Object)("Error updating acl for bucket " + bucketEntity.getBucketName()), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bucket setAcp(@Nonnull Bucket bucketEntity, @Nonnull AccessControlPolicy acp) throws MetadataOperationFailureException, NoSuchEntityException {
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Bucket bucket = (Bucket)Entities.merge((Object)bucketEntity);
            bucket.setAcl(acp);
            trans.commit();
            Bucket bucket2 = bucket;
            return bucket2;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketEntity.getBucketName());
        }
        catch (Exception e) {
            LOG.error((Object)("Error updating acl for bucket " + bucketEntity.getBucketName()), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public Bucket setLoggingStatus(@Nonnull Bucket bucketEntity, @Nonnull Boolean loggingEnabled, @Nullable String destBucket, @Nullable String destPrefix) throws TransactionException, S3Exception {
        EntityTransaction db = Entities.get(Bucket.class);
        try {
            Bucket bucket = (Bucket)Entities.uniqueResult((Object)bucketEntity);
            bucket.setLoggingEnabled(loggingEnabled);
            bucket.setTargetBucket(destBucket);
            bucket.setTargetPrefix(destPrefix);
            db.commit();
            Bucket bucket2 = bucket;
            return bucket2;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketEntity.getBucketName());
        }
        catch (TransactionException e) {
            LOG.error((Object)("Transaction error updating acl for bucket " + bucketEntity.getBucketName()), (Throwable)e);
            throw e;
        }
        finally {
            if (db != null && db.isActive()) {
                db.rollback();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bucket setVersioning(@Nonnull Bucket bucketEntity, @Nonnull ObjectStorageProperties.VersioningStatus newState) throws IllegalResourceStateException, MetadataOperationFailureException, NoSuchEntityException {
        try (TransactionResource trans = Entities.transactionFor(Bucket.class);){
            Bucket bucket = (Bucket)Entities.uniqueResult((Object)new Bucket().withUuid(bucketEntity.getBucketUuid()));
            if (ObjectStorageProperties.VersioningStatus.Disabled.equals((Object)newState)) {
                throw new IllegalResourceStateException("Invalid versioning state transition");
            }
            bucket.setVersioning(newState);
            trans.commit();
            Bucket bucket2 = bucket;
            return bucket2;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(bucketEntity.getBucketName());
        }
        catch (TransactionException e) {
            LOG.error((Object)("Transaction error updating versioning state for bucket " + bucketEntity.getBucketName()), (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
    }

    @Override
    public long totalSizeOfAllBuckets() throws MetadataOperationFailureException {
        long size = -1L;
        try (TransactionResource db = Entities.transactionFor(Bucket.class);){
            size = ((Number)Objects.firstNonNull((Object)((Number)Entities.createCriteria(Bucket.class).setProjection((Projection)Projections.sum((String)"bucketSize")).setReadOnly(true).uniqueResult()), (Object)0)).longValue();
            db.commit();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting buckets cumulative size", (Throwable)e);
            throw new MetadataOperationFailureException(e);
        }
        return size;
    }
}

