/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.objectstorage.BucketLifecycleManagers;
import com.eucalyptus.objectstorage.entities.LifecycleRule;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageException;
import com.eucalyptus.objectstorage.metadata.BucketLifecycleManager;
import com.eucalyptus.storage.msgs.s3.Expiration;
import com.eucalyptus.storage.msgs.s3.Transition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DbBucketLifecycleManagerImpl
implements BucketLifecycleManager {
    private static Logger LOG = Logger.getLogger(DbBucketLifecycleManagerImpl.class);

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void deleteLifecycleRules(@Nonnull String bucketUuid, TransactionResource tran) {
        if (tran == null || !tran.isActive()) {
            throw new RuntimeException(new ObjectStorageException("in DbBucketLifecycleManagerImpl.deleteLifecycleRules, but was not given an active transaction"));
        }
        LifecycleRule example = new LifecycleRule();
        example.setBucketUuid(bucketUuid);
        List existing = Entities.query((Object)example);
        if (existing != null && existing.size() > 0) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("bucketUuid", bucketUuid);
            Entities.deleteAllMatching(LifecycleRule.class, (String)"WHERE bucketUuid = :bucketUuid", criteria);
        }
    }

    @Override
    public void deleteLifecycleRules(@Nonnull String bucketUuid) throws ObjectStorageException {
        try (TransactionResource tran = Entities.transactionFor(LifecycleRule.class);){
            BucketLifecycleManagers.getInstance().deleteLifecycleRules(bucketUuid, tran);
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("caught exception while deleting object lifecycle rules for bucket - " + bucketUuid + ", with error - " + ex.getMessage()));
            throw new ObjectStorageException("InternalServerError", "An exception was caught while deleting the object lifecycle rules for bucket - " + bucketUuid, "Bucket", bucketUuid, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public void addLifecycleRules(@Nonnull List<com.eucalyptus.storage.msgs.s3.LifecycleRule> rules, @Nonnull String bucketUuid) throws ObjectStorageException {
        try (TransactionResource tran = Entities.transactionFor(LifecycleRule.class);){
            BucketLifecycleManagers.getInstance().deleteLifecycleRules(bucketUuid, tran);
            if (rules != null && rules.size() > 0) {
                for (com.eucalyptus.storage.msgs.s3.LifecycleRule ruleInfo : rules) {
                    LifecycleRule converted = this.convertLifecycleRule(ruleInfo, bucketUuid);
                    Entities.merge((Object)converted);
                }
            }
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("caught exception while managing object lifecycle for bucket - " + bucketUuid + ", with error - " + ex.getMessage()));
            throw new ObjectStorageException("InternalServerError", "An exception was caught while managing the object lifecycle for bucket - " + bucketUuid, "Bucket", bucketUuid, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public List<com.eucalyptus.storage.msgs.s3.LifecycleRule> getLifecycleRules(@Nonnull String bucketUuid) throws Exception {
        ArrayList responseRules = Lists.newArrayList();
        List rulesFromDb = null;
        LifecycleRule exampleRule = new LifecycleRule();
        exampleRule.setBucketUuid(bucketUuid);
        try (TransactionResource tran2 = Entities.transactionFor(LifecycleRule.class);){
            rulesFromDb = Entities.query((Object)exampleRule);
            tran2.commit();
        }
        catch (NoSuchElementException tran2) {
        }
        catch (Exception ex) {
            LOG.error((Object)("exception caught while retrieving lifecycle rules for bucket " + bucketUuid), (Throwable)ex);
        }
        if (rulesFromDb != null) {
            for (LifecycleRule fromDb : rulesFromDb) {
                responseRules.add(this.convertLifecycleRule(fromDb));
            }
        }
        return responseRules;
    }

    private LifecycleRule convertLifecycleRule(com.eucalyptus.storage.msgs.s3.LifecycleRule rule, String bucketUuid) {
        LifecycleRule entity = new LifecycleRule();
        entity.setBucketUuid(bucketUuid);
        entity.setRuleId(rule.getId());
        entity.setPrefix(rule.getPrefix());
        Boolean enabled = new Boolean(false);
        if (rule.getStatus() != null && "Enabled".equals(rule.getStatus())) {
            enabled = new Boolean(true);
        }
        entity.setEnabled(enabled);
        if (rule.getTransition() != null) {
            Transition transition = rule.getTransition();
            if (transition.getEffectiveDate() != null) {
                entity.setTransitionDate(transition.getEffectiveDate());
            }
            if (transition.getCreationDelayDays() > 0) {
                entity.setTransitionDays(new Integer(transition.getCreationDelayDays()));
            }
            if (transition.getDestinationClass() != null) {
                entity.setTransitionStorageClass(transition.getDestinationClass());
            }
        }
        if (rule.getExpiration() != null) {
            Expiration expiration = rule.getExpiration();
            if (expiration.getEffectiveDate() != null) {
                entity.setExpirationDate(expiration.getEffectiveDate());
            }
            if (expiration.getCreationDelayDays() > 0) {
                entity.setExpirationDays(new Integer(expiration.getCreationDelayDays()));
            }
        }
        return entity;
    }

    private com.eucalyptus.storage.msgs.s3.LifecycleRule convertLifecycleRule(LifecycleRule entity) {
        Transition transition;
        Expiration expiration;
        com.eucalyptus.storage.msgs.s3.LifecycleRule ruleResponse = new com.eucalyptus.storage.msgs.s3.LifecycleRule();
        ruleResponse.setId(entity.getRuleId());
        ruleResponse.setStatus(entity.getEnabled() != null && entity.getEnabled() != false ? "Enabled" : "Disabled");
        ruleResponse.setPrefix(entity.getPrefix());
        if (entity.getExpirationDate() != null) {
            expiration = new Expiration();
            expiration.setEffectiveDate(entity.getExpirationDate());
            ruleResponse.setExpiration(expiration);
        }
        if (entity.getExpirationDays() != null) {
            expiration = new Expiration();
            expiration.setCreationDelayDays(entity.getExpirationDays().intValue());
            ruleResponse.setExpiration(expiration);
        }
        if (entity.getTransitionDate() != null) {
            transition = new Transition();
            transition.setDestinationClass(entity.getTransitionStorageClass());
            transition.setEffectiveDate(entity.getTransitionDate());
            ruleResponse.setTransition(transition);
        }
        if (entity.getTransitionDays() != null) {
            transition = new Transition();
            transition.setDestinationClass(entity.getTransitionStorageClass());
            transition.setCreationDelayDays(entity.getTransitionDays().intValue());
            ruleResponse.setTransition(transition);
        }
        return ruleResponse;
    }

    @Override
    public List<LifecycleRule> getLifecycleRules() throws Exception {
        List rules = null;
        try (TransactionResource tran = Entities.transactionFor(LifecycleRule.class);){
            rules = Entities.query((Object)new LifecycleRule());
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("exception occurred while retrieving lifecycle rules - " + ex.getMessage()));
        }
        return rules;
    }

    @Override
    public LifecycleRule getLifecycleRuleForReaping(String ruleId, String bucketUuid) throws ObjectStorageException {
        LifecycleRule result;
        block21: {
            result = null;
            LifecycleRule example = new LifecycleRule();
            example.setBucketUuid(bucketUuid);
            example.setRuleId(ruleId);
            try (TransactionResource tran2 = Entities.transactionFor(LifecycleRule.class);){
                List results = Entities.query((Object)example);
                if (results != null && results.size() > 1) {
                    tran2.commit();
                    throw new ObjectStorageException("duplicate rule ids in bucket");
                }
                if (results != null && results.size() == 1) {
                    result = (LifecycleRule)results.get(0);
                    if (result.getLastProcessingStart() != null) {
                        Date now = new Date();
                        long difference = now.getTime() - result.getLastProcessingStart().getTime();
                        if (difference > 60000L) {
                            result.setLastProcessingStart(now);
                            tran2.commit();
                        } else {
                            result = null;
                        }
                    } else {
                        result.setLastProcessingStart(new Date());
                        tran2.commit();
                    }
                    break block21;
                }
                tran2.commit();
                throw new ObjectStorageException("unexpected results querying for lifecycle rules, potential data corruption in lifecycle_rules");
            }
            catch (NoSuchElementException tran2) {
            }
            catch (Exception ex) {
                LOG.error((Object)("exception occurred while retrieving lifecycle rule with id - " + ruleId + " in bucket - " + bucketUuid + " with message - " + ex.getMessage()));
                throw new ObjectStorageException("exception occurred while retrieving lifecycle rule with id - " + ruleId + " in bucket - " + bucketUuid + " with message - " + ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }
}

