/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.google.common.base.Function;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class BucketStateTransitions {
    static final Function<Bucket, Bucket> TRANSITION_TO_CREATING = new Function<Bucket, Bucket>(){

        @Nullable
        public Bucket apply(@Nullable Bucket initializedBucket) {
            if (initializedBucket == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            if (initializedBucket.getState() == null || BucketState.creating.equals((Object)initializedBucket.getState())) {
                initializedBucket.setState((Enum)BucketState.creating);
                return (Bucket)Entities.persist((Object)initializedBucket);
            }
            throw new IllegalResourceStateException(initializedBucket.getBucketName(), null, BucketState.creating.toString(), ((BucketState)initializedBucket.getState()).toString());
        }
    };
    static final Function<Bucket, Bucket> TRANSITION_TO_EXTANT = new Function<Bucket, Bucket>(){

        @Nullable
        public Bucket apply(@Nullable Bucket searchBucket) {
            if (searchBucket == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                Bucket foundBucket = (Bucket)Entities.uniqueResult((Object)new Bucket().withUuid(searchBucket.getBucketUuid()));
                if (!BucketState.deleting.equals((Object)foundBucket.getState())) {
                    foundBucket.setState((Enum)BucketState.extant);
                    return foundBucket;
                }
                throw new IllegalResourceStateException("Cannot transition to extant from non-creating state", null, BucketState.creating.toString(), ((BucketState)foundBucket.getState()).toString());
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(searchBucket.getBucketUuid());
            }
            catch (TransactionException e) {
                throw new MetadataOperationFailureException(e);
            }
        }
    };
    static final Function<Bucket, Bucket> TRANSITION_TO_DELETING = new Function<Bucket, Bucket>(){

        @Nullable
        public Bucket apply(@Nullable Bucket searchBucket) {
            if (searchBucket == null) {
                throw new RuntimeException("Null bucket record cannot be updated");
            }
            try {
                Bucket foundBucket = (Bucket)Entities.uniqueResult((Object)new Bucket().withUuid(searchBucket.getBucketUuid()));
                if (ObjectMetadataManagers.getInstance().countValid(foundBucket) > 0L) {
                    throw new Exception("Bucket not empty");
                }
                foundBucket.setState((Enum)BucketState.deleting);
                foundBucket.setBucketName(null);
                return foundBucket;
            }
            catch (NoSuchElementException e) {
                throw new NoSuchEntityException(searchBucket.getBucketUuid());
            }
            catch (Exception e) {
                throw new MetadataOperationFailureException(e);
            }
        }
    };
}

