/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.metadata;

import com.eucalyptus.objectstorage.metadata.Validator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BucketNameValidatorRepo {
    private static final Validator<String> extendedValidator = BucketNameValidatorRepo.setupExtended();
    private static final Validator<String> dnsCompliantValidator = BucketNameValidatorRepo.setupDnsCompliant();
    private static final Logger LOG = Logger.getLogger(BucketNameValidatorRepo.class);
    private static final Pattern IP_MATCHER = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static Validator<String> getBucketNameValidator(final String restrictionValue) {
        if (restrictionValue != null && "extended".equalsIgnoreCase(restrictionValue)) {
            return extendedValidator;
        }
        if (restrictionValue != null && "dns-compliant".equalsIgnoreCase(restrictionValue)) {
            return dnsCompliantValidator;
        }
        return new Validator<String>(){

            @Override
            public boolean check(String value) {
                LOG.error((Object)("the value " + restrictionValue + " is not valid, must be either 'extended' or 'dns-compliant'. No validation " + "will be done on the specified bucket name (may result in errors)."));
                return value != null && value.length() > 0;
            }
        };
    }

    private static Validator<String> setupExtended() {
        IteratingValidator<String> extended = new IteratingValidator<String>();
        ArrayList checks = Lists.newArrayListWithExpectedSize((int)3);
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String bucketName) {
                return bucketName != null && bucketName.length() > 1;
            }
        });
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String bucketName) {
                return bucketName.length() <= 255;
            }
        });
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String bucketName) {
                for (char ch : bucketName.toCharArray()) {
                    boolean isBad;
                    boolean bl = isBad = !BucketNameValidatorRepo.isLowerOrNumber(ch) && (ch < 'A' || ch > 'Z') && ch != '.' && ch != '-' && ch != '_';
                    if (!isBad) continue;
                    return false;
                }
                return true;
            }
        });
        extended.setValidators(checks);
        return extended;
    }

    private static Validator<String> setupDnsCompliant() {
        IteratingValidator<String> dnsCompliant = new IteratingValidator<String>();
        ArrayList checks = Lists.newArrayListWithExpectedSize((int)5);
        checks.add(extendedValidator);
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String bucketName) {
                return bucketName.length() >= 3 && bucketName.length() <= 63;
            }
        });
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String bucketName) {
                return bucketName.charAt(0) != '.' && bucketName.charAt(bucketName.length() - 1) != '.';
            }
        });
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String value) {
                ArrayList labels;
                if (value.contains(".")) {
                    StringTokenizer tokenizer = new StringTokenizer(value, ".", true);
                    labels = Lists.newArrayList();
                    String lastTok = "";
                    while (tokenizer.hasMoreElements()) {
                        String curTok = tokenizer.nextToken();
                        if (!".".equals(curTok)) {
                            labels.add(curTok);
                        } else if (".".equals(lastTok) && ".".equals(curTok)) {
                            return false;
                        }
                        lastTok = curTok;
                    }
                } else {
                    labels = Lists.newArrayListWithExpectedSize((int)1);
                    labels.add(value);
                }
                for (String label : labels) {
                    char[] asChars = label.toCharArray();
                    if (!BucketNameValidatorRepo.isLowerOrNumber(asChars[0]) || !BucketNameValidatorRepo.isLowerOrNumber(asChars[asChars.length - 1])) {
                        return false;
                    }
                    for (char ch : asChars) {
                        if (BucketNameValidatorRepo.isLowerOrNumber(ch) || ch == '-') continue;
                        return false;
                    }
                }
                return true;
            }
        });
        checks.add(new Validator<String>(){

            @Override
            public boolean check(String value) {
                return !IP_MATCHER.matcher(value).matches();
            }
        });
        dnsCompliant.setValidators(checks);
        return dnsCompliant;
    }

    private static boolean isLowerOrNumber(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static class IteratingValidator<T>
    implements Validator<T> {
        private List<Validator<T>> validators;

        private IteratingValidator() {
        }

        @Override
        public boolean check(T bucketName) {
            if (this.getValidators().size() < 1) {
                return true;
            }
            for (Validator<T> checker : this.getValidators()) {
                if (checker.check(bucketName)) continue;
                return false;
            }
            return true;
        }

        public List<Validator<T>> getValidators() {
            if (this.validators == null) {
                return Lists.newArrayList();
            }
            return this.validators;
        }

        public void setValidators(List<Validator<T>> validators) {
            this.validators = validators;
        }
    }
}

