/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.jobs;

import com.eucalyptus.objectstorage.BucketLifecycleManagers;
import com.eucalyptus.objectstorage.BucketMetadataManagers;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.LifecycleRule;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class LifecycleReaperJob
implements InterruptableJob {
    private static Logger LOG = Logger.getLogger(LifecycleReaperJob.class);
    private boolean interrupted = false;

    public void interrupt() throws UnableToInterruptJobException {
        this.interrupted = true;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.info((Object)"beginning Object Lifecycle processing");
        LOG.debug((Object)"retrieving Object Lifecycle rules from the database");
        List<LifecycleRule> rules = null;
        try {
            rules = BucketLifecycleManagers.getInstance().getLifecycleRules();
        }
        catch (Exception ex) {
            LOG.error((Object)("exception occurred while retrieving lifecycle rules - " + ex.getMessage()));
            throw new JobExecutionException("exception occurred while retrieving lifecycle rules", (Throwable)ex);
        }
        if (rules != null && rules.size() > 0) {
            LOG.debug((Object)("found " + rules.size() + " Object Lifecycle rules"));
            for (int idx = 0; idx < rules.size() && !this.interrupted; ++idx) {
                LifecycleRule rule = rules.get(idx);
                if (rule.getEnabled() != null && rule.getEnabled().booleanValue()) {
                    Bucket bucket;
                    LOG.debug((Object)("rule id - " + rule.getRuleId() + " on bucket " + rule.getBucketUuid() + " processing"));
                    String ruleId = rule.getRuleId();
                    String prefix = rule.getPrefix();
                    try {
                        bucket = BucketMetadataManagers.getInstance().lookupBucketByUuid(rule.getBucketUuid());
                    }
                    catch (Exception e) {
                        bucket = null;
                    }
                    if (bucket == null || !BucketState.extant.equals((Object)bucket.getState())) {
                        LOG.warn((Object)("Cannot process lifecycle rule for bucket valid 'extant' record. bucket uuid: " + rule.getBucketUuid()));
                        continue;
                    }
                    if (rule.getExpirationDate() != null) {
                        this.processExpirationByDate(ruleId, bucket, prefix, rule.getExpirationDate());
                    } else if (rule.getExpirationDays() != null) {
                        this.processExpirationByDays(ruleId, bucket, prefix, rule.getExpirationDays());
                    }
                    if (rule.getTransitionDate() != null) {
                        this.processTransitionByDate(ruleId, bucket, prefix, rule.getTransitionDate());
                        continue;
                    }
                    if (rule.getTransitionDays() == null) continue;
                    this.processTransitionByDays(ruleId, bucket, prefix, rule.getExpirationDays());
                    continue;
                }
                LOG.debug((Object)("rule id - " + rule.getRuleId() + " on bucket " + rule.getBucketUuid() + " is not enabled"));
            }
        } else {
            LOG.info((Object)"there are no rules to process");
        }
    }

    private List<String> findMatchingObjects(String ruleId, Bucket bucket, String objPrefix, Date age) {
        try {
            LifecycleRule retrievedRule = BucketLifecycleManagers.getInstance().getLifecycleRuleForReaping(ruleId, bucket.getBucketUuid());
            if (retrievedRule == null) {
                return Collections.EMPTY_LIST;
            }
        }
        catch (ObjectStorageException e) {
            LOG.error((Object)("exception caught while attempting to retrieve lifecycle rule with id - " + ruleId + " in bucket - " + bucket.getBucketName() + " with message " + e.getMessage()));
        }
        Calendar ageCal = Calendar.getInstance();
        ageCal.setTime(age);
        Calendar queryCal = Calendar.getInstance();
        queryCal.set(5, ageCal.get(5));
        queryCal.set(2, ageCal.get(2));
        queryCal.set(1, ageCal.get(1));
        queryCal.set(11, 0);
        queryCal.set(12, 0);
        queryCal.set(13, 0);
        queryCal.set(14, 0);
        List<ObjectEntity> results = ObjectMetadataManagers.getInstance().lookupObjectsForReaping(bucket, objPrefix, queryCal.getTime());
        if (results == null || results.size() == 0) {
            LOG.debug((Object)("there were no objects in bucket " + bucket.getBucketName() + " with prefix " + objPrefix + " older than " + queryCal.toString()));
            return Collections.EMPTY_LIST;
        }
        ArrayList objectKeys = Lists.newArrayList();
        for (ObjectEntity objectInfo : results) {
            objectKeys.add(objectInfo.getObjectKey());
        }
        LOG.debug((Object)("found " + objectKeys.size() + " matching objects in bucket " + bucket.getBucketName()));
        return this.interrupted ? Collections.EMPTY_LIST : objectKeys;
    }

    public void processExpirationByDate(String ruleId, Bucket bucket, String prefix, Date expirationDate) {
        LOG.info((Object)("processing phase one for ruleId '" + ruleId + "' for bucket " + bucket.getBucketName() + " against objects prefixed '" + prefix + "', marking matches for expiration if it is now past " + expirationDate.toString()));
        List<String> expiredObjectKeys = this.findMatchingObjects(ruleId, bucket, prefix, expirationDate);
        ObjectInfoProcessor processor = new ObjectInfoProcessor(expiredObjectKeys, bucket){

            @Override
            public void handle(ObjectEntity retrieved) {
                ObjectMetadataManagers.getInstance().transitionObjectToState(retrieved, ObjectState.deleting);
                if (LifecycleReaperJob.this.interrupted) {
                    this.interrupt();
                }
            }
        };
        processor.process();
    }

    public void processExpirationByDays(String ruleId, Bucket bucket, String prefix, Integer expirationDays) {
        LOG.info((Object)("processing phase one for ruleId '" + ruleId + "' for bucket " + bucket.getBucketName() + " against objects prefixed '" + prefix + "', marking matches for expiration if they are older than " + expirationDays.toString() + " days old"));
        Calendar expireDay = Calendar.getInstance();
        expireDay.add(5, -1 * expirationDays);
        List<String> expiredObjectKeys = this.findMatchingObjects(ruleId, bucket, prefix, expireDay.getTime());
        ObjectInfoProcessor processor = new ObjectInfoProcessor(expiredObjectKeys, bucket){

            @Override
            public void handle(ObjectEntity retrieved) {
                ObjectMetadataManagers.getInstance().transitionObjectToState(retrieved, ObjectState.deleting);
                if (LifecycleReaperJob.this.interrupted) {
                    this.interrupt();
                }
            }
        };
        processor.process();
    }

    public void processTransitionByDate(String ruleId, Bucket bucket, String prefix, Date transitionDate) {
        LOG.info((Object)("processing phase one for ruleId '" + ruleId + "' for bucket " + bucket.getBucketName() + " against objects prefixed '" + prefix + "', marking matches for transition if it is now past " + transitionDate.toString()));
        List<String> expiredObjectKeys = this.findMatchingObjects(ruleId, bucket, prefix, transitionDate);
        ObjectInfoProcessor processor = new ObjectInfoProcessor(expiredObjectKeys, bucket){

            @Override
            public void handle(ObjectEntity retrieved) {
                if (LifecycleReaperJob.this.interrupted) {
                    this.interrupt();
                }
            }
        };
        processor.process();
    }

    public void processTransitionByDays(String ruleId, Bucket bucket, String prefix, Integer transitionDays) {
        LOG.info((Object)("processing phase one for ruleId '" + ruleId + "' for bucket " + bucket.getBucketName() + " against objects prefixed '" + prefix + "', marking matches for transition if they are older than " + transitionDays.toString() + " days old"));
        Calendar transitionDay = Calendar.getInstance();
        transitionDay.add(5, -1 * transitionDays);
        List<String> transitionObjectKeys = this.findMatchingObjects(ruleId, bucket, prefix, transitionDay.getTime());
        ObjectInfoProcessor processor = new ObjectInfoProcessor(transitionObjectKeys, bucket){

            @Override
            public void handle(ObjectEntity retrieved) {
                if (LifecycleReaperJob.this.interrupted) {
                    this.interrupt();
                }
            }
        };
        processor.process();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    private static abstract class ObjectInfoProcessor {
        private List<String> objectKeys;
        private Bucket bucket;
        private boolean interrupted = false;

        public ObjectInfoProcessor(List<String> objectKeys, Bucket foundBucket) {
            this.objectKeys = objectKeys;
            this.bucket = foundBucket;
        }

        public void process() {
            if (this.objectKeys != null && this.objectKeys.size() > 0) {
                for (int idx = 0; !this.interrupted && idx < this.objectKeys.size(); ++idx) {
                    String objectKey = this.objectKeys.get(idx);
                    try {
                        ObjectEntity objectEntity = ObjectMetadataManagers.getInstance().lookupObject(this.bucket, objectKey, null);
                        if (objectEntity == null) {
                            LOG.debug((Object)("failed to process object " + objectKey + " in bucket " + this.bucket.getBucketName() + " because it was not found in the database"));
                        }
                        this.handle(objectEntity);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("failed to process object " + objectKey + " in bucket " + this.bucket.getBucketName() + " because an exception occurred with message " + ex.getMessage()));
                    }
                }
            }
        }

        public abstract void handle(ObjectEntity var1);

        public void interrupt() {
            this.interrupted = true;
        }
    }
}

