/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.config;

import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.entities.ObjectStorageConfiguration;
import com.eucalyptus.objectstorage.msgs.DeregisterObjectStorageGatewayType;
import com.eucalyptus.objectstorage.msgs.DescribeObjectStorageGatewaysType;
import com.eucalyptus.objectstorage.msgs.ModifyObjectStorageAttributeType;
import com.eucalyptus.objectstorage.msgs.RegisterObjectStorageGatewayType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Joiner;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

@ComponentPart(value=ObjectStorage.class)
@Handles(value={RegisterObjectStorageGatewayType.class, DeregisterObjectStorageGatewayType.class, DescribeObjectStorageGatewaysType.class, ModifyObjectStorageAttributeType.class})
public class OsgBuilder
extends AbstractServiceBuilder<ObjectStorageConfiguration> {
    private static final Logger LOG = Logger.getLogger(OsgBuilder.class);

    public ObjectStorageConfiguration newInstance() {
        return new ObjectStorageConfiguration();
    }

    public ObjectStorageConfiguration newInstance(String partition, String name, String host, Integer port) {
        return new ObjectStorageConfiguration(partition, name, host, port);
    }

    public ComponentId getComponentId() {
        return ComponentIds.lookup(ObjectStorage.class);
    }

    public void fireLoad(ServiceConfiguration parent) throws ServiceRegistrationException {
        block4: {
            try {
                if (!parent.isVmLocal().booleanValue()) break block4;
                EntityTransaction tx = Entities.get((Object)parent);
                try {
                    parent = (ServiceConfiguration)Entities.merge((Object)parent);
                    ((ObjectStorageConfiguration)parent).setAvailableClients(Joiner.on((String)",").join((Iterable)ObjectStorageProviders.list()));
                    tx.commit();
                }
                catch (Exception ex) {
                    LOG.debug((Object)"Error merging parent transaction. Rolling back.");
                    tx.rollback();
                }
                ObjectStorageProviders.getInstance();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
        try {
            ObjectStorageProviders.flushClientInstances();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)"Error flushing client instances. Non-fatal", (Throwable)e);
        }
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException {
    }
}

