/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.ObjectStorageGateway;
import com.eucalyptus.objectstorage.bootstrap.ObjectStorageSchedulerManager;
import org.apache.log4j.Logger;

@Provides(value=ObjectStorage.class)
@RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
@DependsLocal(value={ObjectStorage.class})
public class OsgBootstrapper
extends Bootstrapper {
    private static Logger LOG = Logger.getLogger(OsgBootstrapper.class);
    private static OsgBootstrapper singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bootstrapper getInstance() {
        Class<OsgBootstrapper> clazz = OsgBootstrapper.class;
        synchronized (OsgBootstrapper.class) {
            if (singleton == null) {
                singleton = new OsgBootstrapper();
                LOG.info((Object)"Creating ObjectStorageGateway Bootstrapper instance.");
            } else {
                LOG.info((Object)"Returning ObjectStorageGateway Bootstrapper instance.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean load() throws Exception {
        ObjectStorageGateway.checkPreconditions();
        return true;
    }

    public boolean start() throws Exception {
        ObjectStorageGateway.configure();
        return true;
    }

    public boolean enable() throws Exception {
        ObjectStorageGateway.enable();
        ObjectStorageSchedulerManager.start();
        return true;
    }

    public boolean stop() throws Exception {
        ObjectStorageSchedulerManager.stop();
        ObjectStorageGateway.stop();
        return true;
    }

    public void destroy() throws Exception {
    }

    public boolean disable() throws Exception {
        ObjectStorageSchedulerManager.stop();
        ObjectStorageGateway.disable();
        return true;
    }

    public boolean check() throws Exception {
        ObjectStorageGateway.check();
        return true;
    }
}

