/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.bootstrap;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.objectstorage.entities.ScheduledJob;
import com.eucalyptus.objectstorage.jobs.LifecycleReaperJob;
import com.eucalyptus.objectstorage.jobs.MainBucketReaperJob;
import com.eucalyptus.objectstorage.jobs.MainObjectReaperJob;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class ObjectStorageSchedulerManager {
    private static Logger LOG = Logger.getLogger(ObjectStorageSchedulerManager.class);
    static final String OSG_JOB_GROUP = "OsgJobs";
    static final String LIFECYCLE_CLEANUP_CLASSNAME = LifecycleReaperJob.class.getName();
    static final String LIFECYCLE_CLEANUP_DEFAULT_SCHEDULE = "0 0 1 * * ?";
    static final String OBJECT_REAPER_CLASSNAME = MainObjectReaperJob.class.getName();
    static final String OBJECT_REAPER_DEFAULT_SCHEDULE = "interval: 60";
    static final String BUCKET_REAPER_CLASSNAME = MainBucketReaperJob.class.getName();
    static final String BUCKET_REAPER_DEFAULT_SCHEDULE = "interval: 60";
    private static Scheduler scheduler = null;
    private static final Lock lock = new ReentrantLock(true);
    private static boolean initted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        lock.lock();
        try {
            if (!initted) {
                LOG.error((Object)"cannot start quartz scheduler for ObjectStorageGateway because it is not initialized");
            } else {
                ObjectStorageSchedulerManager.populateJobs();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("caught an exception while attempting to start the quartz scheduler for ObjectStorageGateway jobs, the exception had the message - " + e.getMessage()));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        lock.lock();
        try {
            if (!initted) {
                LOG.error((Object)"cannot shutdown quartz scheduler for ObjectStorageGateway because it is not initialized");
            } else {
                List runningJobs;
                Set osgJobKeys = scheduler.getJobKeys(GroupMatcher.groupEquals((String)OSG_JOB_GROUP));
                if (osgJobKeys != null && osgJobKeys.size() > 0) {
                    for (JobKey jobKey : osgJobKeys) {
                        scheduler.deleteJob(jobKey);
                    }
                }
                if ((runningJobs = scheduler.getCurrentlyExecutingJobs()) != null && runningJobs.size() > 0) {
                    for (JobExecutionContext ctx : runningJobs) {
                        try {
                            scheduler.interrupt(ctx.getFireInstanceId());
                        }
                        catch (UnableToInterruptJobException utije) {
                            LOG.warn((Object)("unable to interrupt job - " + ctx.getJobDetail().getJobClass().getName() + ", received an UnableToInterruptJobException which was caught so it " + "does not bubble up"));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("caught an exception while attempting to shutdown the quartz scheduler for ObjectStorageGateway jobs, the exception had the message - " + e.getMessage()));
        }
        finally {
            lock.unlock();
        }
    }

    public static String dumpInfo() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("scheduler is named " + scheduler.getSchedulerName() + "\n");
            if (scheduler.isStarted()) {
                sb.append("scheduler is started\n");
                if (scheduler.getJobGroupNames() != null && scheduler.getJobGroupNames().size() > 0) {
                    sb.append("scheduler has " + scheduler.getJobGroupNames().size() + " job groups\n");
                    for (String groupName : scheduler.getJobGroupNames()) {
                        Set jobKeys = scheduler.getJobKeys(GroupMatcher.groupEquals((String)groupName));
                        if (jobKeys == null || jobKeys.size() <= 0) continue;
                        sb.append(" in job group " + groupName + " there are " + jobKeys.size() + " jobs\n");
                        for (JobKey jobKey : jobKeys) {
                            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                            if (jobDetail == null) continue;
                            sb.append("  job named " + jobKey.getName() + " using class " + jobDetail.getJobClass().getName() + "\n");
                            List triggers = scheduler.getTriggersOfJob(jobKey);
                            if (triggers == null || triggers.size() <= 0) continue;
                            for (Trigger trigger : triggers) {
                                sb.append("   " + jobKey.getName() + " is triggered by " + trigger.getKey().getName() + "\n");
                            }
                        }
                    }
                } else {
                    sb.append("scheduler does not have any job groups\n");
                }
                if (scheduler.getTriggerGroupNames() != null && scheduler.getTriggerGroupNames().size() > 0) {
                    sb.append("scheduler has " + scheduler.getTriggerGroupNames().size() + " trigger groups\n");
                    for (String triggerGroupName : scheduler.getTriggerGroupNames()) {
                        Set triggerKeys = scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)triggerGroupName));
                        if (triggerKeys == null || triggerKeys.size() <= 0) continue;
                        sb.append(" in trigger group " + triggerGroupName + " there are " + triggerKeys.size() + " triggers\n");
                        for (TriggerKey triggerKey : triggerKeys) {
                            sb.append("   trigger named " + triggerKey.getName() + " is currently in state " + scheduler.getTriggerState(triggerKey).name() + " and will fire again at " + scheduler.getTrigger(triggerKey).getNextFireTime().toString() + "\n");
                        }
                    }
                } else {
                    sb.append("scheduler does not have any trigger groups\n");
                }
            } else {
                sb.append("scheduler is shutdown\n");
            }
        }
        catch (SchedulerException se) {
            sb.append("exception caught while dumping scheduler info - " + se.getMessage() + "\n");
        }
        return sb.toString();
    }

    private static boolean checkForLifecycleCleanupJob(String jobName) {
        return ObjectStorageSchedulerManager.checkForJobByName(jobName, LIFECYCLE_CLEANUP_CLASSNAME);
    }

    private static boolean checkForDeletedObjectReaperJob(String jobName) {
        return ObjectStorageSchedulerManager.checkForJobByName(jobName, OBJECT_REAPER_CLASSNAME);
    }

    private static boolean checkForDeletedBucketReaperJob(String jobName) {
        return ObjectStorageSchedulerManager.checkForJobByName(jobName, BUCKET_REAPER_CLASSNAME);
    }

    private static boolean checkForJobByName(String checking, String checkAgainst) {
        return checking != null && checking.equals(checkAgainst);
    }

    private static void populateJobs() {
        boolean foundLifecycleCleanup = false;
        boolean foundDeletedObjectReaper = false;
        boolean foundDeletedBucketReaper = false;
        List jobs = null;
        try (TransactionResource tran = Entities.transactionFor(ScheduledJob.class);){
            jobs = Entities.query((Object)new ScheduledJob());
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("exception encountered while populating ObjectStorageGateway scheduled jobs from database - " + ex.getMessage()));
        }
        int jobIdx = 1;
        if (jobs != null && jobs.size() > 0) {
            for (ScheduledJob job : jobs) {
                ObjectStorageSchedulerManager.scheduleJobInQuartz(job.getJobClassName(), job.getJobSchedule(), jobIdx);
                ++jobIdx;
                if (!foundLifecycleCleanup) {
                    foundLifecycleCleanup = ObjectStorageSchedulerManager.checkForLifecycleCleanupJob(job.getJobClassName());
                }
                if (!foundDeletedObjectReaper) {
                    foundDeletedObjectReaper = ObjectStorageSchedulerManager.checkForDeletedObjectReaperJob(job.getJobClassName());
                }
                if (foundDeletedBucketReaper) continue;
                foundDeletedBucketReaper = ObjectStorageSchedulerManager.checkForDeletedBucketReaperJob(job.getJobClassName());
            }
        } else {
            LOG.debug((Object)"jobs were either not found in the database, or an exception occurred while querying for scheduled jobs");
        }
        if (!foundDeletedObjectReaper) {
            ObjectStorageSchedulerManager.saveJobToDb(OBJECT_REAPER_CLASSNAME, "interval: 60", "performs upstream deletes of objects that have been deleted in the object storage gateway");
            ObjectStorageSchedulerManager.scheduleJobInQuartz(OBJECT_REAPER_CLASSNAME, "interval: 60", jobIdx);
            ++jobIdx;
        }
        if (!foundDeletedBucketReaper) {
            ObjectStorageSchedulerManager.saveJobToDb(BUCKET_REAPER_CLASSNAME, "interval: 60", "performs upstream deletes of buckets that have been deleted in the object storage gateway");
            ObjectStorageSchedulerManager.scheduleJobInQuartz(BUCKET_REAPER_CLASSNAME, "interval: 60", jobIdx);
            ++jobIdx;
        }
        if (!foundLifecycleCleanup) {
            ObjectStorageSchedulerManager.saveJobToDb(LIFECYCLE_CLEANUP_CLASSNAME, LIFECYCLE_CLEANUP_DEFAULT_SCHEDULE, "processes bucket lifecycle rules");
            ObjectStorageSchedulerManager.scheduleJobInQuartz(LIFECYCLE_CLEANUP_CLASSNAME, LIFECYCLE_CLEANUP_DEFAULT_SCHEDULE, jobIdx);
            ++jobIdx;
        }
    }

    private static void saveJobToDb(String jobClassName, String schedule, String description) {
        ScheduledJob job = new ScheduledJob();
        job.setJobSchedule(schedule);
        job.setJobClassName(jobClassName);
        job.setJobDescription(description);
        try (TransactionResource tran = Entities.transactionFor(ScheduledJob.class);){
            Entities.persist((Object)job);
            tran.commit();
        }
        catch (Exception ex) {
            LOG.warn((Object)("an exception was thrown while saving record to scheduled_jobs table for job_class_name - " + jobClassName + " the error message is - " + ex.getMessage() + ". Ignoring so that the job can be scheduled in quartz"));
        }
    }

    private static void scheduleJobInQuartz(String jobClassName, String schedule, int jobIdx) {
        block9: {
            Class<?> jobClass = null;
            try {
                jobClass = Class.forName(jobClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("attempting to add job of type " + jobClassName + ", but the class was not found, job will not be added"));
            }
            if (jobClass != null) {
                try {
                    JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity("job" + jobIdx, OSG_JOB_GROUP).build();
                    if (schedule != null && schedule.startsWith("interval:")) {
                        String jobSchedule = schedule.substring("interval:".length(), schedule.length());
                        try {
                            int intervalSecs = Integer.parseInt(jobSchedule.trim());
                            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger" + jobIdx, OSG_JOB_GROUP).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(intervalSecs).repeatForever()).startAt(DateBuilder.futureDate((int)(intervalSecs + jobIdx), (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).build();
                            scheduler.scheduleJob(jobDetail, trigger);
                            LOG.info((Object)("job named job" + jobIdx + " added to group " + OSG_JOB_GROUP + " using class " + jobClassName + " with interval schedule '" + schedule + "'"));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.error((Object)("failed to schedule job with class name - " + jobClassName + " because the interval - " + jobSchedule + " failed to be parsed as an integer"));
                        }
                        break block9;
                    }
                    CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger" + jobIdx, OSG_JOB_GROUP).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedule)).build();
                    scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                    LOG.info((Object)("job named job" + jobIdx + " added to group " + OSG_JOB_GROUP + " using class " + jobClassName + " with cron schedule '" + schedule + "'"));
                }
                catch (SchedulerException se) {
                    LOG.error((Object)("while attempting to schedule job using class " + jobClassName + " an exception occurred with message - " + se.getMessage()));
                }
            } else {
                LOG.error((Object)("job was not scheduled because class " + jobClassName + " was either not found or invalid"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        lock.lock();
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            if (!scheduler.isStarted()) {
                scheduler.start();
            }
            initted = true;
        }
        catch (SchedulerException se) {
            LOG.error((Object)("quartz scheduler for ObjectStorageGateway jobs did not initialize properly, exception caught with message - " + se.getMessage()));
        }
        finally {
            lock.unlock();
        }
    }
}

