/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.bittorrent;

import com.eucalyptus.objectstorage.bittorrent.TorrentClient;
import com.eucalyptus.objectstorage.bittorrent.Torrents;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.util.Collection;
import org.apache.log4j.Logger;

public class Tracker
extends Thread {
    private static Logger LOG = Logger.getLogger(Tracker.class);
    private static Tracker tracker;
    private Process proc;

    public static void initialize() {
        tracker = new Tracker();
        if (tracker.exists()) {
            ObjectStorageProperties.enableTorrents = true;
            tracker.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    tracker.bye();
                    Collection<TorrentClient> torrentClients = Torrents.getClients();
                    for (TorrentClient torrentClient : torrentClients) {
                        torrentClient.bye();
                    }
                }
            });
        } else {
            LOG.warn((Object)"bttrack not found (bittorrent installed?). Torrent support disabled (non critical).");
        }
    }

    public boolean exists() {
        try {
            return this.findTracker().length() > 0;
        }
        catch (EucalyptusCloudException e) {
            return false;
        }
    }

    private String findTracker() throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{"bttrack"});
    }

    @Override
    public void run() {
        this.track();
    }

    private void track() {
        new File(ObjectStorageProperties.TRACKER_DIR).mkdirs();
        try {
            Runtime rt = Runtime.getRuntime();
            this.proc = rt.exec(new String[]{"bttrack", "--port", ObjectStorageProperties.TRACKER_PORT, "--dfile", ObjectStorageProperties.TRACKER_DIR + "dstate", "--logfile", ObjectStorageProperties.TRACKER_DIR + "tracker.log"});
            StreamConsumer error = new StreamConsumer(this.proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(this.proc.getInputStream());
            error.start();
            output.start();
            Thread.sleep(300L);
            String errValue = error.getReturnValue();
            if (errValue.length() > 0 && !errValue.contains("already in use")) {
                LOG.warn((Object)errValue);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    public void bye() {
        if (this.proc != null) {
            this.proc.destroy();
        }
    }

    public static void die() {
        if (tracker != null) {
            tracker.bye();
        }
    }
}

