/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.PolicyResourceContext;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.objectstorage.auth.RequestAuthorizationHandler;
import com.eucalyptus.objectstorage.entities.S3AccessControlledEntity;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.policy.AdminOverrideAllowed;
import com.eucalyptus.objectstorage.policy.RequiresACLPermission;
import com.eucalyptus.objectstorage.policy.RequiresPermission;
import com.eucalyptus.objectstorage.policy.ResourceType;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.system.Ats;
import com.google.common.base.Strings;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class OsgAuthorizationHandler
implements RequestAuthorizationHandler {
    private static final Logger LOG = Logger.getLogger(OsgAuthorizationHandler.class);
    private static final RequestAuthorizationHandler authzHandler = new OsgAuthorizationHandler();
    private static RequestAuthorizationHandler mocked = null;

    public static RequestAuthorizationHandler getInstance() {
        if (mocked != null) {
            return mocked;
        }
        return authzHandler;
    }

    public static void setInstance(RequestAuthorizationHandler mock) {
        mocked = mock;
    }

    protected static boolean isUserAnonymous(User usr) {
        return Principals.nobodyUser().equals(usr);
    }

    @Override
    public <T extends ObjectStorageRequestType> boolean operationAllowed(@Nonnull T request, @Nullable S3AccessControlledEntity bucketResourceEntity, @Nullable S3AccessControlledEntity objectResourceEntity, long resourceAllocationSize) throws IllegalArgumentException {
        PolicyResourceContext.PolicyResourceInfo policyResourceInfo;
        Account resourceOwnerAccount;
        Ats requestAuthzProperties = Ats.from(request);
        ObjectStorageProperties.Permission[] requiredBucketACLPermissions = null;
        ObjectStorageProperties.Permission[] requiredObjectACLPermissions = null;
        Boolean allowOwnerOnly = null;
        RequiresACLPermission requiredACLs = (RequiresACLPermission)requestAuthzProperties.get(RequiresACLPermission.class);
        if (requiredACLs != null) {
            requiredBucketACLPermissions = requiredACLs.bucket();
            requiredObjectACLPermissions = requiredACLs.object();
            allowOwnerOnly = requiredACLs.ownerOnly();
        }
        String[] requiredActions = null;
        RequiresPermission perms = (RequiresPermission)requestAuthzProperties.get(RequiresPermission.class);
        if (perms != null) {
            requiredActions = perms.value();
        }
        Boolean allowAdmin = requestAuthzProperties.get(AdminOverrideAllowed.class) != null;
        Boolean allowOnlyAdmin = requestAuthzProperties.get(AdminOverrideAllowed.class) != null && ((AdminOverrideAllowed)requestAuthzProperties.get(AdminOverrideAllowed.class)).adminOnly();
        if (requiredBucketACLPermissions == null && requiredObjectACLPermissions == null && requiredActions == null && !allowAdmin.booleanValue()) {
            LOG.error((Object)("Insufficient permission annotations on type: " + request.getClass().getName() + " cannot evaluate authorization"));
            return false;
        }
        String resourceType = null;
        if (requestAuthzProperties.get(ResourceType.class) != null) {
            resourceType = ((ResourceType)requestAuthzProperties.get(ResourceType.class)).value();
        }
        User requestUser = null;
        Account requestAccount = null;
        AuthContextSupplier authContext = null;
        try {
            try {
                Context ctx = Contexts.lookup((String)request.getCorrelationId());
                requestUser = ctx.getUser();
                requestAccount = requestUser.getAccount();
                authContext = ctx.getAuthContext();
            }
            catch (NoSuchContextException e) {
                requestUser = null;
                requestAccount = null;
                authContext = null;
            }
            if (requestUser == null && !Strings.isNullOrEmpty((String)request.getEffectiveUserId())) {
                requestUser = Accounts.lookupUserById((String)request.getEffectiveUserId());
                requestAccount = requestUser.getAccount();
            }
            if (requestUser == null) {
                requestUser = Principals.nobodyUser();
                requestAccount = requestUser.getAccount();
            }
        }
        catch (AuthException e) {
            LOG.error((Object)("Failed to get user for request, cannot verify authorization: " + e.getMessage()), (Throwable)e);
            return false;
        }
        if (allowAdmin.booleanValue() && requestUser.isSystemAdmin()) {
            return true;
        }
        if (authContext == null) {
            authContext = Permissions.createAuthContextSupplier((User)requestUser, Collections.emptyMap());
        }
        if (resourceType == null) {
            LOG.error((Object)"No resource type found in request class annotations, cannot process.");
            return false;
        }
        try {
            switch (resourceType) {
                case "bucket": {
                    if (bucketResourceEntity == null) {
                        LOG.error((Object)"Could not check access for operation due to no bucket resource entity found");
                        return false;
                    }
                    resourceOwnerAccount = Accounts.lookupAccountByCanonicalId((String)bucketResourceEntity.getOwnerCanonicalId());
                    policyResourceInfo = PolicyResourceContext.resourceInfo((String)resourceOwnerAccount.getAccountNumber(), (Object)bucketResourceEntity);
                    break;
                }
                case "object": {
                    if (objectResourceEntity == null) {
                        LOG.error((Object)"Could not check access for operation due to no object resource entity found");
                        return false;
                    }
                    resourceOwnerAccount = Accounts.lookupAccountByCanonicalId((String)objectResourceEntity.getOwnerCanonicalId());
                    policyResourceInfo = PolicyResourceContext.resourceInfo((String)resourceOwnerAccount.getAccountNumber(), (Object)objectResourceEntity);
                    break;
                }
                default: {
                    LOG.error((Object)"Unknown resource type looking up resource owner. Disallowing operation.");
                    return false;
                }
            }
        }
        catch (AuthException e) {
            LOG.error((Object)"Exception caught looking up resource owner. Disallowing operation.", (Throwable)e);
            return false;
        }
        String resourceId = null;
        if (resourceId == null) {
            if ("bucket".equals(resourceType)) {
                resourceId = request.getBucket();
            } else if ("object".equals(resourceType)) {
                resourceId = request.getFullResource();
            }
        }
        if (allowAdmin.booleanValue() && requestUser.isSystemUser() && OsgAuthorizationHandler.iamPermissionsAllow(authContext, requiredActions, policyResourceInfo, resourceType, resourceId, resourceAllocationSize).booleanValue()) {
            return true;
        }
        if (requiredBucketACLPermissions == null && requiredObjectACLPermissions == null) {
            throw new IllegalArgumentException("No requires-permission actions found in request class annotations, cannot process.");
        }
        Boolean aclAllow = false;
        if (requiredBucketACLPermissions != null && requiredBucketACLPermissions.length > 0) {
            if (bucketResourceEntity == null) {
                LOG.error((Object)"Null bucket resource, cannot evaluate bucket ACL");
                return false;
            }
            for (ObjectStorageProperties.Permission permission : requiredBucketACLPermissions) {
                aclAllow = aclAllow != false || bucketResourceEntity.can(permission, requestAccount.getCanonicalId());
            }
        }
        if (requiredObjectACLPermissions != null && requiredObjectACLPermissions.length > 0) {
            if (objectResourceEntity == null) {
                LOG.error((Object)"Null bucket resource, cannot evaluate bucket ACL");
                return false;
            }
            for (ObjectStorageProperties.Permission permission : requiredObjectACLPermissions) {
                aclAllow = aclAllow != false || objectResourceEntity.can(permission, requestAccount.getCanonicalId());
            }
        }
        aclAllow = allowOwnerOnly != false ? resourceOwnerAccount.getAccountNumber().equals(requestAccount.getAccountNumber()) : aclAllow.booleanValue();
        if (OsgAuthorizationHandler.isUserAnonymous(requestUser)) {
            return aclAllow;
        }
        Boolean iamAllow = OsgAuthorizationHandler.iamPermissionsAllow(authContext, requiredActions, policyResourceInfo, resourceType, resourceId, resourceAllocationSize);
        return aclAllow != false && iamAllow != false;
    }

    private static Boolean iamPermissionsAllow(AuthContextSupplier authContext, String[] requiredActions, PolicyResourceContext.PolicyResourceInfo policyResourceInfo, String resourceType, String resourceId, long resourceAllocationSize) {
        boolean iamAllow = true;
        for (String action : requiredActions) {
            try (PolicyResourceContext context = PolicyResourceContext.of((Object)policyResourceInfo, (String)action);){
                iamAllow &= Permissions.isAuthorized((String)"s3", (String)resourceType, (String)resourceId, null, (String)action, (AuthContextSupplier)authContext) && Permissions.canAllocate((String)"s3", (String)resourceType, (String)resourceId, (String)action, (AuthContextSupplier)authContext, (Long)resourceAllocationSize);
            }
        }
        return iamAllow;
    }
}

