/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.asynctask;

import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.OsgObjectFactory;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.entities.PartEntity;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.util.EucalyptusCloudException;
import java.util.List;
import org.apache.log4j.Logger;

public class ObjectReaperTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ObjectReaperTask.class);
    private boolean interrupted = false;

    public void interrupt() {
        this.interrupted = true;
    }

    public void resume() {
        this.interrupted = false;
    }

    public void reapObject(ObjectEntity obj) throws Exception {
        LOG.trace((Object)("Reaping object " + obj.getObjectUuid()));
        try {
            OsgObjectFactory.getFactory().actuallyDeleteObject(ObjectStorageProviders.getInstance(), obj, null);
        }
        catch (EucalyptusCloudException ex) {
            LOG.trace((Object)("Reaping failed due to error for object: " + obj.getBucket().getBucketUuid() + "/" + obj.getObjectUuid() + " Will retry"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            LOG.debug((Object)"Initiating object-storage object reaper task");
            this.cleanDeleting();
            this.cleanFailed();
            this.cleanParts();
        }
        catch (Throwable f) {
            LOG.error((Object)"Error during object reaper execution. Will retry later", f);
        }
        finally {
            try {
                long endTime = System.currentTimeMillis();
                LOG.debug((Object)("Object reaper execution task took " + Long.toString(endTime - startTime) + "ms to complete"));
            }
            catch (Throwable endTime) {}
        }
    }

    private void cleanDeleting() {
        try {
            List<ObjectEntity> entitiesToClean = ObjectMetadataManagers.getInstance().lookupObjectsInState(null, null, null, ObjectState.deleting);
            LOG.trace((Object)("Reaping " + entitiesToClean.size() + " objects from backend"));
            for (ObjectEntity obj : entitiesToClean) {
                try {
                    this.reapObject(obj);
                }
                catch (Throwable f) {
                    LOG.error((Object)("Error during object reaper cleanup for object:  uuid= " + obj.getObjectUuid()), f);
                }
                if (!this.interrupted) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error encountered during reaping of deleting-state object. Will retry on next cycle", (Throwable)e);
        }
    }

    private void cleanFailed() {
        try {
            List<ObjectEntity> entitiesToClean = ObjectMetadataManagers.getInstance().lookupFailedObjects();
            LOG.trace((Object)("Reaping " + entitiesToClean.size() + " objects with expired creation time from backend"));
            for (ObjectEntity obj : entitiesToClean) {
                try {
                    this.reapObject(obj);
                }
                catch (Throwable f) {
                    LOG.error((Object)("Error during object reaper cleanup for object:  uuid= " + obj.getObjectUuid()), f);
                }
                if (!this.interrupted) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error encountered during reaping of deleting-state object. Will retry on next cycle", (Throwable)e);
        }
    }

    private void cleanParts() {
        try {
            List<PartEntity> partsToClean = MpuPartMetadataManagers.getInstance().lookupPartsInState(null, null, null, ObjectState.deleting);
            LOG.trace((Object)("Reaping " + partsToClean.size() + " parts from backend"));
            for (PartEntity part : partsToClean) {
                try {
                    this.reapPart(part);
                }
                catch (Throwable f) {
                    LOG.error((Object)("Error during part reaper cleanup for part: " + part.getBucket().getBucketName() + " uploadId: " + part.getUploadId() + " partNumber: " + part.getPartNumber() + " uuid= " + part.getPartUuid()), f);
                }
                if (!this.interrupted) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error cleaning parts. Will retry later.", (Throwable)e);
        }
    }

    public void reapPart(PartEntity part) throws Exception {
        try {
            Transactions.delete((Object)part);
        }
        catch (TransactionException e) {
            LOG.error((Object)("Unable to drop part: " + part.getBucket().getBucketName() + " uploadId: " + part.getUploadId() + " partNumber: " + part.getPartNumber() + " uuid: " + part.getPartUuid()));
        }
    }
}

