/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.asynctask;

import com.eucalyptus.objectstorage.BucketMetadataManagers;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.OsgBucketFactory;
import com.eucalyptus.objectstorage.PaginatedResult;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.entities.ObjectStorageGlobalConfiguration;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.storage.config.ConfigurationCache;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class BucketReaperTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(BucketReaperTask.class);
    private long startTime;
    private static final long MAX_TASK_DURATION = 30000L;
    private static final Random rand = new Random(System.currentTimeMillis());
    private boolean interrupted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        try {
            LOG.trace((Object)"Initiating bucket cleanup task");
            List<Bucket> buckets = BucketMetadataManagers.getInstance().lookupBucketsByState(null);
            if (buckets == null || buckets.size() <= 0) {
                LOG.trace((Object)"No buckets found to clean. Cleanup task complete");
                return;
            }
            while (buckets.size() > 0 && !this.isTimedOut() && !this.interrupted) {
                int idx = rand.nextInt(buckets.size());
                Bucket b = buckets.get(idx);
                this.cleanObjectHistoriesInBucket(b);
                this.resolveBucketState(b);
                buckets.remove(idx);
            }
        }
        catch (Throwable f) {
            LOG.error((Object)"Error during bucket cleanup execution. Will retry later", f);
        }
        finally {
            try {
                long endTime = System.currentTimeMillis();
                LOG.trace((Object)("Bucket cleanup execution task took " + Long.toString(endTime - this.startTime) + "ms to complete"));
            }
            catch (Throwable endTime) {}
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void resume() {
        this.interrupted = false;
    }

    private void resolveBucketState(Bucket bucket) {
        LOG.trace((Object)("Resolving bucket state for bucket uuid " + bucket.getBucketUuid()));
        if (BucketState.deleting.equals((Object)bucket.getState()) || !bucket.stateStillValid(((ObjectStorageGlobalConfiguration)ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class)).getBucket_creation_wait_interval_seconds().intValue())) {
            LOG.trace((Object)("Deleting backend bucket for bucket uuid " + bucket.getBucketUuid() + " during bucket cleanup"));
            try {
                OsgBucketFactory.getFactory().deleteBucket(ObjectStorageProviders.getInstance(), bucket, null, null);
            }
            catch (Exception e) {
                LOG.error((Object)("Error cleaning deletion marked bucketuuid " + bucket.getBucketUuid()), (Throwable)e);
            }
        }
    }

    private boolean isTimedOut() {
        return System.currentTimeMillis() - this.startTime >= 30000L;
    }

    protected void cleanObjectHistoriesInBucket(Bucket b) {
        String nextKey = null;
        int chunkSize = 1000;
        PaginatedResult<ObjectEntity> result = null;
        LOG.trace((Object)("Cleaning object histories for bucket uuid " + b.getBucketUuid()));
        block4: do {
            try {
                result = ObjectMetadataManagers.getInstance().listPaginated(b, 1000, null, null, nextKey);
            }
            catch (Throwable f) {
                LOG.error((Object)("Could not get object listing for bucket " + b.getBucketName() + " with next marker: " + nextKey));
                nextKey = null;
                result = null;
                break;
            }
            for (ObjectEntity obj : result.getEntityList()) {
                try {
                    ObjectMetadataManagers.getInstance().cleanupInvalidObjects(b, obj.getObjectKey());
                }
                catch (Throwable f) {
                    LOG.error((Object)("Error doing async repair of object " + b.getBucketName() + "/" + obj.getObjectKey() + " Continuing to next object"), f);
                }
                if (!this.interrupted) continue;
                continue block4;
            }
        } while ((nextKey = !this.interrupted && result.getIsTruncated() ? ((ObjectEntity)result.getLastEntry()).getObjectKey() : null) != null && !this.isTimedOut());
    }
}

