/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.objectstorage.BucketLifecycleManagers;
import com.eucalyptus.objectstorage.BucketMetadataManagers;
import com.eucalyptus.objectstorage.BucketTaggingManagers;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.OSGChannelWriter;
import com.eucalyptus.objectstorage.OSGMessageResponse;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.ObjectStorageService;
import com.eucalyptus.objectstorage.OsgBucketFactory;
import com.eucalyptus.objectstorage.OsgObjectFactory;
import com.eucalyptus.objectstorage.PaginatedResult;
import com.eucalyptus.objectstorage.auth.OsgAuthorizationHandler;
import com.eucalyptus.objectstorage.bittorrent.Tracker;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.BucketTags;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.entities.ObjectStorageGlobalConfiguration;
import com.eucalyptus.objectstorage.entities.PartEntity;
import com.eucalyptus.objectstorage.entities.S3AccessControlledEntity;
import com.eucalyptus.objectstorage.exceptions.IllegalResourceStateException;
import com.eucalyptus.objectstorage.exceptions.MetadataOperationFailureException;
import com.eucalyptus.objectstorage.exceptions.NoSuchEntityException;
import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.objectstorage.exceptions.s3.AccountProblemException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketAlreadyExistsException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketNotEmptyException;
import com.eucalyptus.objectstorage.exceptions.s3.IllegalVersioningConfigurationException;
import com.eucalyptus.objectstorage.exceptions.s3.InlineDataTooLargeException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidArgumentException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidBucketNameException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidBucketStateException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidRangeException;
import com.eucalyptus.objectstorage.exceptions.s3.InvalidRequestException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedACLErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.MalformedXMLException;
import com.eucalyptus.objectstorage.exceptions.s3.MissingContentLengthException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchKeyException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchTagSetException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchUploadException;
import com.eucalyptus.objectstorage.exceptions.s3.NotImplementedException;
import com.eucalyptus.objectstorage.exceptions.s3.PreconditionFailedException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.exceptions.s3.TooManyBucketsException;
import com.eucalyptus.objectstorage.exceptions.s3.UnresolvableGrantByEmailAddressException;
import com.eucalyptus.objectstorage.metadata.BucketNameValidatorRepo;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CopyObjectResponseType;
import com.eucalyptus.objectstorage.msgs.CopyObjectType;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketLifecycleResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketLifecycleType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketTaggingResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketTaggingType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectType;
import com.eucalyptus.objectstorage.msgs.DeleteVersionResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteVersionType;
import com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.GetBucketLifecycleResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLifecycleType;
import com.eucalyptus.objectstorage.msgs.GetBucketLocationResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLocationType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.objectstorage.msgs.GetBucketTaggingResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketTaggingType;
import com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.GetObjectExtendedResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectExtendedType;
import com.eucalyptus.objectstorage.msgs.GetObjectResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectStorageConfigurationResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectStorageConfigurationType;
import com.eucalyptus.objectstorage.msgs.GetObjectType;
import com.eucalyptus.objectstorage.msgs.HeadBucketResponseType;
import com.eucalyptus.objectstorage.msgs.HeadBucketType;
import com.eucalyptus.objectstorage.msgs.HeadObjectResponseType;
import com.eucalyptus.objectstorage.msgs.HeadObjectType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsType;
import com.eucalyptus.objectstorage.msgs.ListBucketResponseType;
import com.eucalyptus.objectstorage.msgs.ListBucketType;
import com.eucalyptus.objectstorage.msgs.ListMultipartUploadsResponseType;
import com.eucalyptus.objectstorage.msgs.ListMultipartUploadsType;
import com.eucalyptus.objectstorage.msgs.ListPartsResponseType;
import com.eucalyptus.objectstorage.msgs.ListPartsType;
import com.eucalyptus.objectstorage.msgs.ListVersionsResponseType;
import com.eucalyptus.objectstorage.msgs.ListVersionsType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.msgs.PostObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PostObjectType;
import com.eucalyptus.objectstorage.msgs.PutObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PutObjectType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.SetBucketLifecycleResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketLifecycleType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.objectstorage.msgs.SetBucketTaggingResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketTaggingType;
import com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.UpdateObjectStorageConfigurationResponseType;
import com.eucalyptus.objectstorage.msgs.UpdateObjectStorageConfigurationType;
import com.eucalyptus.objectstorage.msgs.UploadPartResponseType;
import com.eucalyptus.objectstorage.msgs.UploadPartType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviderClient;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.objectstorage.util.AclUtils;
import com.eucalyptus.objectstorage.util.ObjectStorageProperties;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.S3ObjectEvent;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.config.ConfigurationCache;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.BucketTag;
import com.eucalyptus.storage.msgs.s3.BucketTagSet;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.CommonPrefixesEntry;
import com.eucalyptus.storage.msgs.s3.Initiator;
import com.eucalyptus.storage.msgs.s3.LifecycleConfiguration;
import com.eucalyptus.storage.msgs.s3.LifecycleRule;
import com.eucalyptus.storage.msgs.s3.ListAllMyBucketsList;
import com.eucalyptus.storage.msgs.s3.LoggingEnabled;
import com.eucalyptus.storage.msgs.s3.TaggingConfiguration;
import com.eucalyptus.storage.msgs.s3.TargetGrants;
import com.eucalyptus.storage.msgs.s3.Upload;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ObjectStorageGateway
implements ObjectStorageService {
    private static Logger LOG = Logger.getLogger(ObjectStorageGateway.class);
    private static ObjectStorageProviderClient ospClient = null;

    public static void checkPreconditions() throws EucalyptusCloudException, ExecutionException {
        LOG.debug((Object)"Checking ObjectStorageGateway preconditions");
        LOG.debug((Object)"ObjectStorageGateway Precondition check complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure() throws EucalyptusCloudException {
        Class<ObjectStorageGateway> clazz = ObjectStorageGateway.class;
        synchronized (ObjectStorageGateway.class) {
            ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class);
            if (ospClient == null) {
                try {
                    ospClient = ObjectStorageProviders.getInstance();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error getting the configured providerclient for ObjectStorageGateway. Cannot continue", (Throwable)ex);
                    throw new EucalyptusCloudException((Throwable)ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                ospClient.initialize();
            }
            catch (S3Exception ex) {
                LOG.error((Object)"Error initializing Object Storage Gateway", (Throwable)ex);
                SystemUtil.shutdownWithError((String)ex.getMessage());
            }
            try {
                if (ospClient != null) {
                    ospClient.start();
                }
            }
            catch (S3Exception ex) {
                LOG.error((Object)("Error starting storage backend: " + (Object)((Object)ex)));
            }
            return;
        }
    }

    public static void enable() throws EucalyptusCloudException {
        LOG.debug((Object)"Enabling ObjectStorageGateway");
        ospClient.enable();
        LOG.debug((Object)"Enabling ObjectStorageGateway complete");
    }

    public static void disable() throws EucalyptusCloudException {
        LOG.debug((Object)"Disabling ObjectStorageGateway");
        ospClient.disable();
        LOG.debug((Object)"Disabling ObjectStorageGateway complete");
    }

    public static void check() throws EucalyptusCloudException {
        LOG.trace((Object)"Checking ObjectStorageGateway");
        ospClient.check();
        LOG.trace((Object)"Checking ObjectStorageGateway complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() throws EucalyptusCloudException {
        LOG.debug((Object)"Checking ObjectStorageGateway preconditions");
        ospClient.stop();
        Class<ObjectStorageGateway> clazz = ObjectStorageGateway.class;
        synchronized (ObjectStorageGateway.class) {
            ospClient = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            Tracker.die();
            try {
                ObjectMetadataManagers.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Error stopping object manager", (Throwable)e);
            }
            try {
                BucketMetadataManagers.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Error stopping bucket manager", (Throwable)e);
            }
            LOG.debug((Object)"Checking ObjectStorageGateway preconditions");
            return;
        }
    }

    @Override
    public UpdateObjectStorageConfigurationResponseType updateObjectStorageConfiguration(UpdateObjectStorageConfigurationType request) throws EucalyptusCloudException {
        UpdateObjectStorageConfigurationResponseType reply = (UpdateObjectStorageConfigurationResponseType)request.getReply();
        if (((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name().equals(request.getEffectiveUserId())) {
            throw new AccessDeniedException("Only admin can change object storage properties.");
        }
        if (request.getProperties() != null) {
            for (ComponentProperty prop : request.getProperties()) {
                try {
                    ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)prop.getQualifiedName());
                    entry.setValue(prop.getValue());
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
        }
        ospClient.check();
        return reply;
    }

    @Override
    public GetObjectStorageConfigurationResponseType getObjectStorageConfiguration(GetObjectStorageConfigurationType request) throws EucalyptusCloudException {
        GetObjectStorageConfigurationResponseType reply = (GetObjectStorageConfigurationResponseType)request.getReply();
        ConfigurableClass configurableClass = ObjectStorageGlobalConfiguration.class.getAnnotation(ConfigurableClass.class);
        if (configurableClass != null) {
            String prefix = configurableClass.root();
            reply.setProperties((ArrayList)PropertyDirectory.getComponentPropertySet((String)prefix));
        }
        return reply;
    }

    protected static boolean checkBucketNameValidity(String bucketName) {
        return BucketNameValidatorRepo.getBucketNameValidator(((ObjectStorageGlobalConfiguration)ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class)).getBucket_naming_restrictions()).check(bucketName);
    }

    @Override
    public PutObjectResponseType putObject(PutObjectType request) throws S3Exception {
        ObjectStorageGateway.logRequest(request);
        return this.doPutOperation(request);
    }

    protected PutObjectResponseType doPutOperation(PutObjectType request) throws S3Exception {
        try {
            long objectSize;
            Bucket bucket;
            User requestUser = this.getRequestUser((ObjectStorageRequestType)request);
            try {
                bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
            }
            catch (NoSuchEntityException e) {
                LOG.debug((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + "Responding to client with 404, no bucket found"));
                throw new NoSuchBucketException(request.getBucket());
            }
            if (Strings.isNullOrEmpty((String)request.getContentLength())) {
                throw new MissingContentLengthException(request.getBucket() + "/" + request.getKey());
            }
            try {
                objectSize = Long.parseLong(request.getContentLength());
            }
            catch (Exception e) {
                LOG.error((Object)("Could not parse content length into a long: " + request.getContentLength()), (Throwable)e);
                throw new MissingContentLengthException(request.getBucket() + "/" + request.getKey());
            }
            ObjectEntity objectEntity = ObjectEntity.newInitializedForCreate((Bucket)bucket, (String)request.getKey(), (long)objectSize, (User)requestUser, (Map)request.getCopiedHeaders());
            if (!OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)objectEntity, objectSize)) {
                throw new AccessDeniedException(request.getBucket());
            }
            if (request.getExpectHeader()) {
                OSGChannelWriter.writeResponse(Contexts.lookup((String)request.getCorrelationId()), OSGMessageResponse.Continue);
            }
            AccessControlPolicy acp = this.getFullAcp(request.getAccessControlList(), requestUser, bucket.getOwnerCanonicalId());
            objectEntity.setAcl(acp);
            String fullObjectKey = objectEntity.getObjectUuid();
            request.setKey(fullObjectKey);
            try {
                objectEntity = OsgObjectFactory.getFactory().createObject(ospClient, objectEntity, (InputStream)request.getData(), request.getMetaData(), requestUser);
            }
            catch (Exception e) {
                throw new InternalErrorException(request.getKey(), (Throwable)e);
            }
            PutObjectResponseType response = (PutObjectResponseType)request.getReply();
            if (!"null".equals(objectEntity.getVersionId())) {
                response.setVersionId(objectEntity.getVersionId());
            }
            response.setEtag(objectEntity.geteTag());
            response.setLastModified(objectEntity.getObjectModifiedTimestamp());
            Map storedHeaders = objectEntity.getStoredHeaders();
            this.populateStoredHeaders((ObjectStorageDataResponseType)response, storedHeaders);
            try {
                this.fireObjectCreationEvent(bucket.getBucketName(), objectEntity.getObjectKey(), objectEntity.getVersionId(), requestUser.getUserId(), objectEntity.getSize(), null);
            }
            catch (Exception ex) {
                LOG.debug((Object)"Failed to fire reporting event for OSG object creation", (Throwable)ex);
            }
            return response;
        }
        catch (S3Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with: "), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
            throw new InternalErrorException(request.getKey(), (Throwable)e);
        }
    }

    private User getRequestUser(ObjectStorageRequestType request) throws AccountProblemException {
        try {
            String requestUserId = request.getEffectiveUserId();
            if (Strings.isNullOrEmpty((String)requestUserId)) {
                return Contexts.lookup().getUser();
            }
            if (Principals.systemFullName().getUserId().equals(requestUserId)) {
                return Accounts.lookupSystemAdmin();
            }
            return Accounts.lookupUserById((String)requestUserId);
        }
        catch (AuthException e) {
            throw new AccountProblemException(request.getEffectiveUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <I extends ObjectStorageRequestType> void logRequest(I request) {
        if (!Logs.isTrace()) {
            return;
        }
        StringBuilder canonicalLogEntry = new StringBuilder("osg handling request:");
        try {
            String accnt = null;
            String src = null;
            try {
                Context ctx = Contexts.lookup((String)request.getCorrelationId());
                accnt = ctx.getAccount().getAccountNumber();
                src = ctx.getRemoteAddress().getHostAddress();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed context lookup by correlation Id: " + request.getCorrelationId()));
            }
            finally {
                if (Strings.isNullOrEmpty((String)accnt)) {
                    accnt = "unknown";
                }
                if (Strings.isNullOrEmpty((String)src)) {
                    src = "unknown";
                }
            }
            canonicalLogEntry.append(" CorrelationId: " + request.getCorrelationId());
            canonicalLogEntry.append(" Operation: " + request.getClass().getSimpleName());
            canonicalLogEntry.append(" Account: " + accnt);
            canonicalLogEntry.append(" Src Ip: " + src);
            canonicalLogEntry.append(" Bucket: " + request.getBucket());
            canonicalLogEntry.append(" Object: " + request.getKey());
            if (request instanceof GetObjectType) {
                canonicalLogEntry.append(" VersionId: " + ((GetObjectType)request).getVersionId());
            } else if (request instanceof PutObjectType) {
                canonicalLogEntry.append(" ContentMD5: " + ((PutObjectType)request).getContentMD5());
            }
            LOG.trace((Object)canonicalLogEntry.toString());
        }
        catch (Exception e) {
            LOG.warn((Object)("Problem formatting request log entry. Incomplete entry: " + canonicalLogEntry.toString()), (Throwable)e);
        }
    }

    @Override
    public HeadBucketResponseType headBucket(HeadBucketType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        HeadBucketResponseType reply = (HeadBucketResponseType)request.getReply();
        reply.setBucket(bucket.getBucketName());
        reply.setStatus(HttpResponseStatus.OK);
        reply.setStatusMessage("OK");
        reply.setTimestamp(new Date());
        return reply;
    }

    protected AccessControlPolicy getFullAcp(@Nonnull AccessControlList acl, @Nonnull User requestUser, @Nullable String extantBucketOwnerCanonicalId) throws Exception {
        AccessControlPolicy tmpPolicy = new AccessControlPolicy();
        tmpPolicy.setAccessControlList(acl);
        if (extantBucketOwnerCanonicalId == null) {
            return AclUtils.processNewResourcePolicy((User)requestUser, (AccessControlPolicy)tmpPolicy, null);
        }
        return AclUtils.processNewResourcePolicy((User)requestUser, (AccessControlPolicy)tmpPolicy, (String)extantBucketOwnerCanonicalId);
    }

    @Override
    public CreateBucketResponseType createBucket(CreateBucketType request) throws S3Exception {
        ObjectStorageGateway.logRequest(request);
        try {
            User requestUser = this.getRequestUser((ObjectStorageRequestType)request);
            Account requestAccount = requestUser.getAccount();
            if (!ObjectStorageGateway.checkBucketNameValidity(request.getBucket())) {
                throw new InvalidBucketNameException(request.getBucket());
            }
            AccessControlPolicy acPolicy = this.getFullAcp(request.getAccessControlList(), requestUser, null);
            Bucket bucket = Bucket.getInitializedBucket((String)request.getBucket(), (String)requestUser.getUserId(), (AccessControlPolicy)acPolicy, (String)request.getLocationConstraint());
            if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, null, 1L)) {
                if (!Contexts.lookup().hasAdministrativePrivileges() && BucketMetadataManagers.getInstance().countBucketsByAccount(requestAccount.getCanonicalId()) >= (long)((ObjectStorageGlobalConfiguration)ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class)).getMax_buckets_per_account().intValue()) {
                    throw new TooManyBucketsException(request.getBucket());
                }
                try {
                    bucket = OsgBucketFactory.getFactory().createBucket(ospClient, bucket, request.getCorrelationId(), requestUser);
                    CreateBucketResponseType reply = (CreateBucketResponseType)request.getReply();
                    reply.setStatus(HttpResponseStatus.OK);
                    reply.setBucket(bucket.getBucketName());
                    reply.setTimestamp(new Date());
                    reply.setStatusMessage("OK");
                    LOG.trace((Object)("CorrelationId: " + request.getCorrelationId() + " Responding with " + reply.getStatus().toString()));
                    return reply;
                }
                catch (BucketAlreadyExistsException e) {
                    Bucket extantBucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
                    if (extantBucket.isOwnedBy(requestAccount.getCanonicalId())) {
                        CreateBucketResponseType reply = (CreateBucketResponseType)request.getReply();
                        reply.setStatus(HttpResponseStatus.OK);
                        reply.setBucket(bucket.getBucketName());
                        reply.setStatusMessage("OK");
                        LOG.trace((Object)("CorrelationId: " + request.getCorrelationId() + " Responding with " + reply.getStatus().toString()));
                        return reply;
                    }
                    throw new BucketAlreadyExistsException(request.getBucket());
                }
            }
            LOG.error((Object)("CorrelationId: " + request.getCorrelationId() + " Create bucket " + request.getBucket() + " access is denied based on acl and/or IAM policy"));
            throw new AccessDeniedException(request.getBucket());
        }
        catch (Exception ex) {
            if (ex instanceof S3Exception) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with: "), (Throwable)ex);
                throw (S3Exception)((Object)ex);
            }
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)ex);
            throw new InternalErrorException(request.getBucket(), (Throwable)ex);
        }
    }

    @Override
    public DeleteBucketResponseType deleteBucket(DeleteBucketType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        if (bucket != null) {
            try {
                OsgBucketFactory.getFactory().deleteBucket(ospClient, bucket, request.getCorrelationId(), Contexts.lookup().getUser());
            }
            catch (MetadataOperationFailureException e) {
                throw new BucketNotEmptyException(bucket.getBucketName());
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
                throw new InternalErrorException(request.getKey(), (Throwable)e);
            }
        }
        DeleteBucketResponseType reply = (DeleteBucketResponseType)request.getReply();
        reply.setStatus(HttpResponseStatus.NO_CONTENT);
        reply.setStatusMessage("NoContent");
        LOG.trace((Object)("CorrelationId: " + request.getCorrelationId() + " Responding with " + reply.getStatus().toString()));
        return reply;
    }

    protected static ListAllMyBucketsList generateBucketListing(List<Bucket> buckets) {
        ListAllMyBucketsList bucketList = new ListAllMyBucketsList();
        bucketList.setBuckets(new ArrayList());
        for (Bucket b : buckets) {
            bucketList.getBuckets().add(b.toBucketListEntry());
        }
        return bucketList;
    }

    @Override
    public ListAllMyBucketsResponseType listAllMyBuckets(ListAllMyBucketsType request) throws S3Exception {
        ObjectStorageGateway.logRequest(request);
        Bucket fakeBucket = new Bucket();
        fakeBucket.setBucketName("*");
        fakeBucket.setOwnerCanonicalId(Contexts.lookup().getAccount().getCanonicalId());
        request.setBucket(fakeBucket.getBucketName());
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)fakeBucket, null, 0L)) {
            Account accnt;
            ListAllMyBucketsResponseType response = (ListAllMyBucketsResponseType)request.getReply();
            try {
                accnt = Contexts.lookup((String)request.getCorrelationId()).getAccount();
                if (accnt == null) {
                    throw new NoSuchContextException();
                }
            }
            catch (NoSuchContextException e) {
                LOG.error((Object)("Could not retrieve canonicalId for user with userId: " + request.getUserId() + " effectiveUserId: " + request.getEffectiveUserId()));
                throw new AccountProblemException(request.getUserId());
            }
            try {
                List<Bucket> listing = BucketMetadataManagers.getInstance().lookupBucketsByOwner(accnt.getCanonicalId());
                response.setBucketList(ObjectStorageGateway.generateBucketListing(listing));
                response.setOwner(AclUtils.buildCanonicalUser((Account)accnt));
                return response;
            }
            catch (Exception e) {
                throw new InternalErrorException("Error getting bucket metadata", (Throwable)e);
            }
        }
        AccessDeniedException ex = new AccessDeniedException("ListAllMyBuckets");
        ex.setMessage("Insufficient permissions to list buckets. Check with your account administrator");
        ex.setResourceType("Service");
        throw ex;
    }

    @Override
    public GetBucketAccessControlPolicyResponseType getBucketAccessControlPolicy(GetBucketAccessControlPolicyType request) throws S3Exception {
        Bucket bucket;
        ObjectStorageGateway.logRequest(request);
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting metadata for object " + request.getBucket() + " " + request.getKey()));
            throw new InternalErrorException(request.getBucket() + "/?acl");
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, null, 0L)) {
            GetBucketAccessControlPolicyResponseType reply = (GetBucketAccessControlPolicyResponseType)request.getReply();
            reply.setBucket(request.getBucket());
            try {
                reply.setAccessControlPolicy(bucket.getAccessControlPolicy());
            }
            catch (Exception e) {
                throw new InternalErrorException(request.getBucket() + "/?acl");
            }
            return reply;
        }
        throw new AccessDeniedException(request.getBucket());
    }

    @Override
    public PostObjectResponseType postObject(PostObjectType request) throws S3Exception {
        ObjectStorageGateway.logRequest(request);
        String bucketName = request.getBucket();
        String key = request.getKey();
        PutObjectType putObject = new PutObjectType();
        putObject.setUserId(Contexts.lookup().getUserFullName().getUserId());
        putObject.setBucket(bucketName);
        putObject.setKey(key);
        putObject.setAccessControlList(request.getAccessControlList());
        putObject.setContentType(request.getContentType());
        putObject.setContentLength(request.getContentLength());
        putObject.setEffectiveUserId(request.getEffectiveUserId());
        putObject.setIsCompressed(request.getIsCompressed());
        putObject.setMetaData(request.getMetaData());
        putObject.setStorageClass(request.getStorageClass());
        putObject.setData(request.getData());
        putObject.setCorrelationId(request.getCorrelationId());
        PutObjectResponseType putObjectResponse = this.doPutOperation(putObject);
        String etag = putObjectResponse.getEtag();
        PostObjectResponseType reply = (PostObjectResponseType)request.getReply();
        reply.setEtag(etag);
        reply.setLastModified(putObjectResponse.getLastModified());
        reply.set_return(putObjectResponse.get_return());
        reply.setMetaData(putObjectResponse.getMetaData());
        reply.setErrorCode(putObjectResponse.getErrorCode());
        reply.setStatusMessage(putObjectResponse.getStatusMessage());
        String successActionRedirect = request.getSuccessActionRedirect();
        if (successActionRedirect != null) {
            try {
                URI addrUri = new URL(successActionRedirect).toURI();
                InetAddress.getByName(addrUri.getHost());
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
            }
            String paramString = "bucket=" + bucketName + "&key=" + key + "&etag=quot;" + etag + "quot;";
            reply.setRedirectUrl(successActionRedirect + "?" + paramString);
        } else {
            Integer successActionStatus = request.getSuccessActionStatus();
            if (successActionStatus != null) {
                if (successActionStatus == 200 || successActionStatus == 201) {
                    reply.setSuccessCode(successActionStatus);
                    if (successActionStatus == 200) {
                        return reply;
                    }
                    reply.setBucket(bucketName);
                    reply.setKey(key);
                    reply.setLocation(Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]).getUri().getHost() + "/" + bucketName + "/" + key);
                } else {
                    reply.setSuccessCode(Integer.valueOf(204));
                    return reply;
                }
            }
        }
        return reply;
    }

    @Override
    public DeleteObjectResponseType deleteObject(DeleteObjectType request) throws S3Exception {
        ObjectEntity objectEntity;
        try {
            objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, null);
        }
        catch (NoSuchEntityException | NoSuchBucketException | NoSuchKeyException | NoSuchElementException e) {
            DeleteObjectResponseType reply = (DeleteObjectResponseType)request.getReply();
            reply.setStatus(HttpResponseStatus.NO_CONTENT);
            reply.setStatusMessage("No Content");
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting bucket metadata for bucket " + request.getBucket()));
            throw new InternalErrorException(request.getBucket());
        }
        try {
            ObjectEntity responseEntity = OsgObjectFactory.getFactory().logicallyDeleteObject(ospClient, objectEntity, Contexts.lookup().getUser());
            try {
                this.fireObjectUsageEvent(S3ObjectEvent.S3ObjectAction.OBJECTDELETE, objectEntity.getBucket().getBucketName(), objectEntity.getObjectKey(), objectEntity.getVersionId(), Contexts.lookup().getUser().getUserId(), objectEntity.getSize());
            }
            catch (Exception e) {
                LOG.warn((Object)("caught exception while attempting to fire reporting event, exception message - " + e.getMessage()));
            }
            DeleteObjectResponseType reply = (DeleteObjectResponseType)request.getReply();
            reply.setStatus(HttpResponseStatus.NO_CONTENT);
            reply.setStatusMessage("No Content");
            if (responseEntity != null) {
                reply.setVersionId(responseEntity.getVersionId());
                if (responseEntity.getIsDeleteMarker() != null && responseEntity.getIsDeleteMarker().booleanValue()) {
                    reply.setIsDeleteMarker(Boolean.TRUE);
                }
            }
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)("Transaction error during delete object: " + request.getBucket() + "/" + request.getKey()), (Throwable)e);
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
        }
    }

    @Override
    public ListBucketResponseType listBucket(ListBucketType request) throws S3Exception {
        PaginatedResult<ObjectEntity> result;
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        ListBucketResponseType reply = (ListBucketResponseType)request.getReply();
        int maxKeys = 1000;
        try {
            if (!Strings.isNullOrEmpty((String)request.getMaxKeys())) {
                maxKeys = Integer.parseInt(request.getMaxKeys());
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Failed to parse maxKeys from request properly: " + request.getMaxKeys()), (Throwable)e);
            throw new InvalidArgumentException("MaxKeys");
        }
        reply.setMaxKeys(maxKeys);
        reply.setName(request.getBucket());
        reply.setDelimiter(request.getDelimiter());
        reply.setMarker(request.getMarker());
        reply.setPrefix(request.getPrefix());
        reply.setIsTruncated(false);
        try {
            result = ObjectMetadataManagers.getInstance().listPaginated(bucket, maxKeys, request.getPrefix(), request.getDelimiter(), request.getMarker());
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting object listing for bucket: " + request.getBucket()), (Throwable)e);
            throw new InternalErrorException(request.getBucket());
        }
        if (result != null) {
            reply.setContents(new ArrayList());
            for (ObjectEntity obj : result.getEntityList()) {
                reply.getContents().add(obj.toListEntry());
            }
            if (result.getCommonPrefixes() != null && result.getCommonPrefixes().size() > 0) {
                reply.setCommonPrefixesList(new ArrayList());
                for (String s : result.getCommonPrefixes()) {
                    reply.getCommonPrefixesList().add(new CommonPrefixesEntry(s));
                }
            }
            reply.setIsTruncated(result.isTruncated);
            if (result.isTruncated) {
                if (result.getLastEntry() instanceof ObjectEntity) {
                    reply.setNextMarker(((ObjectEntity)result.getLastEntry()).getObjectKey());
                } else {
                    reply.setNextMarker(result.getLastEntry() != null ? result.getLastEntry().toString() : "");
                }
            }
        }
        return reply;
    }

    @Override
    public GetObjectAccessControlPolicyResponseType getObjectAccessControlPolicy(GetObjectAccessControlPolicyType request) throws S3Exception {
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, request.getVersionId());
        GetObjectAccessControlPolicyResponseType reply = (GetObjectAccessControlPolicyResponseType)request.getReply();
        reply.setBucket(request.getBucket());
        try {
            reply.setAccessControlPolicy(objectEntity.getAccessControlPolicy());
        }
        catch (Exception e) {
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
        }
        return reply;
    }

    @Override
    public SetBucketAccessControlPolicyResponseType setBucketAccessControlPolicy(SetBucketAccessControlPolicyType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        if (request.getAccessControlPolicy() == null || request.getAccessControlPolicy().getAccessControlList() == null) {
            LOG.error((Object)"Cannot put ACL that does not exist in request");
            throw new MalformedACLErrorException(request.getBucket() + "?acl");
        }
        AccessControlPolicy fullPolicy = new AccessControlPolicy();
        try {
            fullPolicy.setAccessControlList(AclUtils.expandCannedAcl((AccessControlList)request.getAccessControlPolicy().getAccessControlList(), (String)bucket.getOwnerCanonicalId(), null));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot expand the ACL in the request");
            throw new MalformedACLErrorException(request.getBucket() + "?acl");
        }
        if (fullPolicy.getAccessControlList() == null || fullPolicy.getAccessControlList().getGrants() == null || fullPolicy.getAccessControlList().getGrants().size() == 0) {
            LOG.error((Object)"Cannot put ACL that does not exist in request");
            throw new MalformedACLErrorException(request.getBucket() + "?acl");
        }
        if (request.getAccessControlPolicy().getOwner() == null) {
            fullPolicy.setOwner(new CanonicalUser(bucket.getOwnerCanonicalId(), bucket.getOwnerDisplayName()));
        } else {
            fullPolicy.setOwner(request.getAccessControlPolicy().getOwner());
        }
        try {
            String aclString = S3AccessControlledEntity.marshallAcpToString((AccessControlPolicy)fullPolicy);
            if (Strings.isNullOrEmpty((String)aclString)) {
                throw new MalformedACLErrorException(request.getBucket() + "?acl");
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof UnresolvableGrantByEmailAddressException) {
                    throw (UnresolvableGrantByEmailAddressException)cause;
                }
                if (cause instanceof InvalidArgumentException) {
                    throw (InvalidArgumentException)cause;
                }
            }
            LOG.error((Object)"Invalid ACL policy");
            throw new MalformedACLErrorException(request.getBucket() + "?acl");
        }
        try {
            BucketMetadataManagers.getInstance().setAcp(bucket, fullPolicy);
            SetBucketAccessControlPolicyResponseType reply = (SetBucketAccessControlPolicyResponseType)request.getReply();
            reply.setBucket(request.getBucket());
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)("Transaction error updating bucket ACL for bucket " + request.getBucket()), (Throwable)e);
            throw new InternalErrorException(request.getBucket() + "?acl");
        }
    }

    @Override
    public SetObjectAccessControlPolicyResponseType setObjectAccessControlPolicy(SetObjectAccessControlPolicyType request) throws S3Exception {
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, request.getVersionId());
        SetObjectAccessControlPolicyResponseType reply = (SetObjectAccessControlPolicyResponseType)request.getReply();
        String bucketOwnerId = objectEntity.getBucket().getOwnerCanonicalId();
        String objectOwnerId = objectEntity.getOwnerCanonicalId();
        try {
            String aclString = null;
            if (request.getAccessControlPolicy() == null || request.getAccessControlPolicy().getAccessControlList() == null) {
                throw new MalformedACLErrorException(request.getBucket() + "/" + request.getKey() + "?acl");
            }
            request.getAccessControlPolicy().setAccessControlList(AclUtils.expandCannedAcl((AccessControlList)request.getAccessControlPolicy().getAccessControlList(), (String)bucketOwnerId, (String)objectOwnerId));
            if (request.getAccessControlPolicy() == null || request.getAccessControlPolicy().getAccessControlList() == null) {
                LOG.error((Object)"Cannot put ACL that does not exist in request");
                throw new InternalErrorException(request.getBucket() + "/" + request.getKey() + "?acl");
            }
            if (request.getAccessControlPolicy().getOwner() == null) {
                request.getAccessControlPolicy().setOwner(new CanonicalUser(objectOwnerId, objectEntity.getOwnerDisplayName()));
            }
            try {
                aclString = S3AccessControlledEntity.marshallAcpToString((AccessControlPolicy)request.getAccessControlPolicy());
            }
            catch (Exception e) {
                throw new MalformedACLErrorException(request.getBucket() + "/" + request.getKey() + "?acl");
            }
            if (Strings.isNullOrEmpty((String)aclString)) {
                throw new MalformedACLErrorException(request.getBucket() + "/" + request.getKey() + "?acl");
            }
            ObjectMetadataManagers.getInstance().setAcp(objectEntity, request.getAccessControlPolicy());
            if (!objectEntity.getBucket().getVersioning().equals((Object)ObjectStorageProperties.VersioningStatus.Disabled)) {
                reply.setVersionId(objectEntity.getVersionId());
            } else {
                reply.setVersionId(null);
            }
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)("Internal error during PUT object?acl for object " + request.getBucket() + "/" + request.getKey()), (Throwable)e);
            if (e instanceof MalformedACLErrorException) {
                throw new MalformedACLErrorException(request.getBucket() + "/" + request.getKey() + "?acl");
            }
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
        }
    }

    @Override
    public GetObjectResponseType getObject(GetObjectType request) throws S3Exception {
        GetObjectResponseType reply;
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, request.getVersionId());
        if (objectEntity.getIsDeleteMarker().booleanValue()) {
            throw new NoSuchKeyException(request.getKey());
        }
        request.setKey(objectEntity.getObjectUuid());
        request.setBucket(objectEntity.getBucket().getBucketUuid());
        String originalVersionId = request.getVersionId();
        request.setVersionId(null);
        try {
            reply = ospClient.getObject(request);
        }
        catch (Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
            throw new InternalErrorException(objectEntity.getResourceFullName(), (Throwable)e);
        }
        reply.setLastModified(objectEntity.getObjectModifiedTimestamp());
        reply.setEtag(objectEntity.geteTag());
        reply.setVersionId(objectEntity.getVersionId());
        reply.setHasStreamingData(true);
        if (request.getInlineData().booleanValue()) {
            if (reply.getSize() * 4L > ObjectStorageProperties.MAX_INLINE_DATA_SIZE) {
                LOG.error((Object)("Base64 encoded object size: " + reply.getSize() + " exceeds maximum inline response size: " + ObjectStorageProperties.MAX_INLINE_DATA_SIZE + "bytes. Cannot return response."));
                throw new InlineDataTooLargeException(request.getBucket() + "/" + request.getKey());
            }
            byte[] buffer = new byte[ObjectStorageProperties.IO_CHUNK_SIZE];
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            try {
                int readLength;
                while ((readLength = reply.getDataInputStream().read(buffer)) >= 0) {
                    data.write(buffer, 0, readLength);
                }
                reply.setBase64Data(B64.url.encString((byte[])data.toByteArray()));
            }
            catch (BufferOverflowException e) {
                LOG.error((Object)("Maximum inline response size: " + ObjectStorageProperties.MAX_INLINE_DATA_SIZE + "bytes exceeded. Cannot return response."), (Throwable)e);
                throw new InlineDataTooLargeException(request.getBucket() + "/" + request.getKey());
            }
            catch (IOException e) {
                LOG.error((Object)"Error reading data to write into in-line response", (Throwable)e);
                throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
            }
            finally {
                try {
                    reply.getDataInputStream().close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Could not close inputstream for data content on inline-data GetObject.", (Throwable)ex);
                }
                reply.setDataInputStream(null);
                reply.setHasStreamingData(false);
            }
        }
        this.populateStoredHeaders((ObjectStorageDataResponseType)reply, objectEntity.getStoredHeaders());
        reply.setResponseHeaderOverrides(request.getResponseHeaderOverrides());
        return reply;
    }

    @Override
    public GetObjectExtendedResponseType getObjectExtended(GetObjectExtendedType request) throws S3Exception {
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, null);
        Long objectSize = objectEntity.getSize();
        Long lastIndex = objectSize - 1L < 0L ? 0L : objectSize - 1L;
        Long byteRangeStart = request.getByteRangeStart();
        Long byteRangeEnd = request.getByteRangeEnd();
        if (byteRangeStart != null && byteRangeEnd != null) {
            if (byteRangeEnd < byteRangeStart) {
                byteRangeStart = null;
                byteRangeEnd = null;
            }
        } else if (byteRangeStart != null || byteRangeEnd != null) {
            if (byteRangeStart != null) {
                if (objectSize == 0L) {
                    throw new InvalidRangeException("bytes=" + ObjectUtils.toString((Object)request.getByteRangeStart()) + "-" + ObjectUtils.toString((Object)request.getByteRangeEnd()));
                }
                byteRangeEnd = lastIndex;
            } else {
                if (byteRangeEnd == 0L) {
                    throw new InvalidRangeException("bytes=" + ObjectUtils.toString((Object)request.getByteRangeStart()) + "-" + ObjectUtils.toString((Object)request.getByteRangeEnd()));
                }
                byteRangeStart = objectSize - byteRangeEnd > 0L ? objectSize - byteRangeEnd : 0L;
                byteRangeEnd = lastIndex;
            }
        }
        if (byteRangeStart != null && byteRangeStart > lastIndex) {
            throw new InvalidRangeException("bytes=" + ObjectUtils.toString((Object)request.getByteRangeStart()) + "-" + ObjectUtils.toString((Object)request.getByteRangeEnd()));
        }
        if (byteRangeEnd != null && byteRangeEnd > lastIndex) {
            byteRangeEnd = lastIndex;
        }
        request.setKey(objectEntity.getObjectUuid());
        request.setBucket(objectEntity.getBucket().getBucketUuid());
        request.setByteRangeStart(byteRangeStart);
        request.setByteRangeEnd(byteRangeEnd);
        try {
            GetObjectExtendedResponseType response = ospClient.getObjectExtended(request);
            response.setVersionId(objectEntity.getVersionId());
            response.setLastModified(objectEntity.getObjectModifiedTimestamp());
            this.populateStoredHeaders((ObjectStorageDataResponseType)response, objectEntity.getStoredHeaders());
            response.setResponseHeaderOverrides(request.getResponseHeaderOverrides());
            return response;
        }
        catch (S3Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with: "), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey(), (Throwable)e);
        }
    }

    private void populateStoredHeaders(ObjectStorageDataResponseType reply, Map<String, String> storedHeaders) {
        if (storedHeaders == null || storedHeaders.size() == 0) {
            return;
        }
        if (storedHeaders.containsKey("Content-Type")) {
            reply.setContentType(storedHeaders.get("Content-Type"));
        }
        if (storedHeaders.containsKey("Content-Disposition")) {
            reply.setContentDisposition(storedHeaders.get("Content-Disposition"));
        }
        if (storedHeaders.containsKey("Cache-Control")) {
            reply.setCacheControl(storedHeaders.get("Cache-Control"));
        }
        if (storedHeaders.containsKey("Content-Encoding")) {
            reply.setContentEncoding(storedHeaders.get("Content-Encoding"));
        }
        if (storedHeaders.containsKey("Expires")) {
            reply.setExpires(storedHeaders.get("Expires"));
        }
    }

    @Override
    public HeadObjectResponseType headObject(HeadObjectType request) throws S3Exception {
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, request.getVersionId());
        if (objectEntity.getIsDeleteMarker().booleanValue()) {
            throw new NoSuchKeyException(request.getKey());
        }
        HeadObjectResponseType reply = (HeadObjectResponseType)request.getReply();
        request.setKey(objectEntity.getObjectUuid());
        request.setBucket(objectEntity.getBucket().getBucketUuid());
        String originalVersionId = request.getVersionId();
        try {
            request.setVersionId(null);
            HeadObjectResponseType backendReply = ospClient.headObject(request);
            reply.setMetaData(backendReply.getMetaData());
            this.populateStoredHeaders((ObjectStorageDataResponseType)reply, objectEntity.getStoredHeaders());
        }
        catch (S3Exception e) {
            LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        reply.setLastModified(objectEntity.getObjectModifiedTimestamp());
        reply.setSize(objectEntity.getSize());
        reply.setVersionId(objectEntity.getVersionId());
        reply.setEtag(objectEntity.geteTag());
        return reply;
    }

    @Override
    public GetBucketLocationResponseType getBucketLocation(GetBucketLocationType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        GetBucketLocationResponseType reply = (GetBucketLocationResponseType)request.getReply();
        reply.setLocationConstraint(bucket.getLocation() == null ? "" : bucket.getLocation());
        reply.setBucket(request.getBucket());
        return reply;
    }

    @Override
    public CopyObjectResponseType copyObject(CopyObjectType request) throws S3Exception {
        ObjectEntity srcObject;
        ObjectStorageGateway.logRequest(request);
        String sourceBucket = request.getSourceBucket();
        String sourceKey = request.getSourceObject();
        String sourceVersionId = request.getSourceVersionId();
        User requestUser = Contexts.lookup().getUser();
        Bucket srcBucket = this.ensureBucketExists(sourceBucket);
        try {
            srcObject = ObjectMetadataManagers.getInstance().lookupObject(srcBucket, sourceKey, sourceVersionId);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchKeyException(sourceBucket + "/" + sourceKey);
        }
        catch (Exception e) {
            throw new InternalErrorException(sourceBucket);
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request.getGetObjectRequest(), (S3AccessControlledEntity)srcBucket, (S3AccessControlledEntity)srcObject, 0L)) {
            ObjectEntity destObject;
            CopyObjectResponseType reply = (CopyObjectResponseType)request.getReply();
            String destinationBucket = request.getDestinationBucket();
            String destinationKey = request.getDestinationObject();
            Bucket destBucket = this.ensureBucketExists(destinationBucket);
            try {
                destObject = ObjectEntity.newInitializedForCreate((Bucket)destBucket, (String)destinationKey, (long)srcObject.getSize(), (User)requestUser);
            }
            catch (Exception e) {
                LOG.error((Object)("Error initializing entity for persisting object metadata for " + destinationBucket + "/" + destinationKey));
                throw new InternalErrorException(destinationBucket + "/" + destinationKey);
            }
            if (OsgAuthorizationHandler.getInstance().operationAllowed(request.getPutObjectRequest(), (S3AccessControlledEntity)destBucket, (S3AccessControlledEntity)destObject, srcObject.getSize())) {
                String metadataDirective = request.getMetadataDirective();
                String copyIfMatch = request.getCopySourceIfMatch();
                String copyIfNoneMatch = request.getCopySourceIfNoneMatch();
                Date copyIfUnmodifiedSince = request.getCopySourceIfUnmodifiedSince();
                Date copyIfModifiedSince = request.getCopySourceIfModifiedSince();
                boolean updateMetadataOnly = false;
                if (Strings.isNullOrEmpty((String)metadataDirective)) {
                    metadataDirective = ObjectStorageProperties.MetadataDirective.COPY.toString();
                } else {
                    try {
                        metadataDirective = ObjectStorageProperties.MetadataDirective.valueOf((String)metadataDirective).toString();
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidArgumentException("x-amz-metadata-directive", "Unknown metadata directive: " + metadataDirective);
                    }
                }
                if (sourceBucket.equals(destinationBucket) && sourceKey.equals(destinationKey) && Strings.isNullOrEmpty((String)request.getSourceVersionId())) {
                    if (ObjectStorageProperties.MetadataDirective.REPLACE.toString().equals(metadataDirective)) {
                        updateMetadataOnly = true;
                    } else {
                        throw new InvalidRequestException(destinationBucket + "/" + destinationKey, "This copy request is illegal because it is trying to copy an object to itself without changing the object's metadata, storage class, website redirect location or encryption attributes.");
                    }
                }
                Map modded = null;
                modded = ObjectStorageProperties.MetadataDirective.REPLACE.toString().equals(metadataDirective) ? (request.getCopiedHeaders() != null && !request.getCopiedHeaders().isEmpty() ? Maps.newHashMap((Map)request.getCopiedHeaders()) : Maps.newHashMap()) : srcObject.getStoredHeaders();
                destObject.setStoredHeaders(modded);
                if (copyIfMatch != null && !copyIfMatch.equals(srcObject.geteTag())) {
                    throw new PreconditionFailedException(sourceKey + " CopySourceIfMatch: " + copyIfMatch);
                }
                if (copyIfNoneMatch != null && copyIfNoneMatch.equals(srcObject.geteTag())) {
                    throw new PreconditionFailedException(sourceKey + " CopySourceIfNoneMatch: " + copyIfNoneMatch);
                }
                if (copyIfUnmodifiedSince != null && copyIfUnmodifiedSince.getTime() < srcObject.getObjectModifiedTimestamp().getTime()) {
                    throw new PreconditionFailedException(sourceKey + " CopySourceIfUnmodifiedSince: " + copyIfUnmodifiedSince.toString());
                }
                if (copyIfModifiedSince != null && copyIfModifiedSince.getTime() > srcObject.getObjectModifiedTimestamp().getTime()) {
                    throw new PreconditionFailedException(sourceKey + " CopySourceIfModifiedSince: " + copyIfModifiedSince.toString());
                }
                try {
                    AccessControlPolicy acp = this.getFullAcp(request.getAccessControlList(), requestUser, destBucket.getOwnerCanonicalId());
                    destObject.setAcl(acp);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Encountered an exception while constructing access control policy to set on " + destinationBucket + "/" + destinationKey), (Throwable)e);
                    throw new InternalErrorException(destinationBucket + "/" + destinationKey + "?acl");
                }
                destObject.setSize(srcObject.getSize());
                destObject.setStorageClass(srcObject.getStorageClass());
                destObject.seteTag(srcObject.geteTag());
                destObject.setIsLatest(Boolean.TRUE);
                request.setSourceObject(srcObject.getObjectUuid());
                request.setSourceBucket(srcBucket.getBucketUuid());
                request.setSourceVersionId("null");
                request.setDestinationObject(destObject.getObjectUuid());
                request.setDestinationBucket(destBucket.getBucketUuid());
                try {
                    ObjectEntity objectEntity = OsgObjectFactory.getFactory().copyObject(ospClient, destObject, request, requestUser, metadataDirective);
                    reply.setLastModified(DateFormatter.dateToListingFormattedString((Date)objectEntity.getObjectModifiedTimestamp()));
                    reply.setEtag(objectEntity.geteTag());
                    try {
                        if (!updateMetadataOnly) {
                            this.fireObjectCreationEvent(destinationBucket, destinationKey, destObject.getVersionId(), requestUser.getUserId(), destObject.getSize(), null);
                        }
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)"Failed to fire reporting event for OSG COPY object operation", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)ex);
                    throw new InternalErrorException("Could not copy " + srcBucket.getBucketName() + "/" + srcObject.getObjectKey() + " to " + destBucket.getBucketName() + "/" + destObject.getObjectKey(), (Throwable)ex);
                }
                reply.setCopySourceVersionId(sourceVersionId != null ? sourceVersionId : (!srcObject.getVersionId().equals("null") ? srcObject.getVersionId() : null));
                reply.setVersionId(!destObject.getVersionId().equals("null") ? destObject.getVersionId() : null);
                return reply;
            }
            throw new AccessDeniedException(destinationBucket + "/" + destinationKey);
        }
        throw new AccessDeniedException(sourceBucket + "/" + sourceKey);
    }

    @Override
    public GetBucketLoggingStatusResponseType getBucketLoggingStatus(GetBucketLoggingStatusType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        GetBucketLoggingStatusResponseType reply = (GetBucketLoggingStatusResponseType)request.getReply();
        LoggingEnabled loggingConfig = new LoggingEnabled();
        if (bucket.getLoggingEnabled().booleanValue()) {
            TargetGrants grants = new TargetGrants();
            try {
                Bucket targetBucket = BucketMetadataManagers.getInstance().lookupExtantBucket(bucket.getTargetBucket());
                grants.setGrants((List)targetBucket.getAccessControlPolicy().getAccessControlList().getGrants());
            }
            catch (Exception e) {
                LOG.warn((Object)("Error populating target grants for bucket " + request.getBucket() + " for target " + bucket.getTargetBucket()), (Throwable)e);
                grants.setGrants(new ArrayList());
            }
            loggingConfig.setTargetBucket(bucket.getTargetBucket());
            loggingConfig.setTargetPrefix(bucket.getTargetPrefix());
            loggingConfig.setTargetGrants(grants);
            reply.setLoggingEnabled(loggingConfig);
        } else {
            reply.setLoggingEnabled(null);
        }
        return reply;
    }

    @Override
    public SetBucketLoggingStatusResponseType setBucketLoggingStatus(SetBucketLoggingStatusType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        throw new NotImplementedException("PUT ?logging");
    }

    @Override
    public GetBucketVersioningStatusResponseType getBucketVersioningStatus(GetBucketVersioningStatusType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        GetBucketVersioningStatusResponseType reply = (GetBucketVersioningStatusResponseType)request.getReply();
        reply.setVersioningStatus(bucket.getVersioning().toString());
        reply.setBucket(request.getBucket());
        return reply;
    }

    @Override
    public SetBucketVersioningStatusResponseType setBucketVersioningStatus(SetBucketVersioningStatusType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        try {
            ObjectStorageProperties.VersioningStatus versionStatus = ObjectStorageProperties.VersioningStatus.valueOf((String)request.getVersioningStatus());
            BucketMetadataManagers.getInstance().setVersioning(bucket, versionStatus);
        }
        catch (IllegalResourceStateException | IllegalArgumentException e) {
            throw new IllegalVersioningConfigurationException(request.getVersioningStatus());
        }
        catch (MetadataOperationFailureException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        SetBucketVersioningStatusResponseType reply = (SetBucketVersioningStatusResponseType)request.getReply();
        return reply;
    }

    @Override
    public ListVersionsResponseType listVersions(ListVersionsType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        int maxKeys = ObjectStorageProperties.MAX_KEYS;
        if (!Strings.isNullOrEmpty((String)request.getMaxKeys())) {
            try {
                maxKeys = Integer.parseInt(request.getMaxKeys());
                if (maxKeys < 0 || maxKeys > ObjectStorageProperties.MAX_KEYS) {
                    throw new InvalidArgumentException(request.getMaxKeys());
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(request.getMaxKeys());
            }
        }
        try {
            PaginatedResult<ObjectEntity> versionListing = ObjectMetadataManagers.getInstance().listVersionsPaginated(bucket, maxKeys, request.getPrefix(), request.getDelimiter(), request.getKeyMarker(), request.getVersionIdMarker(), false);
            ListVersionsResponseType reply = (ListVersionsResponseType)request.getReply();
            reply.setName(bucket.getBucketName());
            reply.setMaxKeys(maxKeys);
            reply.setKeyMarker(request.getKeyMarker());
            reply.setVersionIdMarker(request.getVersionIdMarker());
            reply.setDelimiter(request.getDelimiter());
            reply.setPrefix(request.getPrefix());
            reply.setIsTruncated(versionListing.getIsTruncated());
            for (ObjectEntity ent : versionListing.getEntityList()) {
                reply.getKeyEntries().add(ent.toVersionEntry());
            }
            if (reply.getIsTruncated()) {
                if (versionListing.getLastEntry() instanceof ObjectEntity) {
                    reply.setNextKeyMarker(((ObjectEntity)versionListing.getLastEntry()).getObjectKey());
                    reply.setNextVersionIdMarker(((ObjectEntity)versionListing.getLastEntry()).getVersionId());
                } else if (versionListing.getLastEntry() instanceof String) {
                    reply.setNextKeyMarker((String)versionListing.getLastEntry());
                }
            }
            for (String s : versionListing.getCommonPrefixes()) {
                reply.getCommonPrefixesList().add(new CommonPrefixesEntry(s));
            }
            return reply;
        }
        catch (S3Exception e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error listing versions for bucket " + request.getBucket()));
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public DeleteVersionResponseType deleteVersion(DeleteVersionType request) throws S3Exception {
        ObjectEntity objectEntity = this.getObjectEntityAndCheckPermissions((ObjectStorageRequestType)request, request.getVersionId());
        ObjectEntity responseEntity = OsgObjectFactory.getFactory().logicallyDeleteVersion(ospClient, objectEntity, Contexts.lookup().getUser());
        DeleteVersionResponseType reply = (DeleteVersionResponseType)request.getReply();
        reply.setStatus(HttpResponseStatus.NO_CONTENT);
        reply.setKey(request.getKey());
        if (responseEntity != null) {
            reply.setVersionId(responseEntity.getVersionId());
            if (responseEntity.getIsDeleteMarker() != null && responseEntity.getIsDeleteMarker().booleanValue()) {
                reply.setIsDeleteMarker(Boolean.TRUE);
            }
        }
        return reply;
    }

    @Override
    public GetBucketLifecycleResponseType getBucketLifecycle(GetBucketLifecycleType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        GetBucketLifecycleResponseType reply = (GetBucketLifecycleResponseType)request.getReply();
        try {
            LifecycleConfiguration lifecycle = new LifecycleConfiguration();
            List<LifecycleRule> responseRules = BucketLifecycleManagers.getInstance().getLifecycleRules(bucket.getBucketUuid());
            lifecycle.setRules(responseRules);
            reply.setLifecycleConfiguration(lifecycle);
        }
        catch (Exception e) {
            throw new InternalErrorException(request.getBucket());
        }
        return reply;
    }

    @Override
    public SetBucketLifecycleResponseType setBucketLifecycle(SetBucketLifecycleType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        SetBucketLifecycleResponseType response = (SetBucketLifecycleResponseType)request.getReply();
        String bucketName = request.getBucket();
        ArrayList<LifecycleRule> goodRules = new ArrayList<LifecycleRule>();
        if (request.getLifecycleConfiguration() != null && request.getLifecycleConfiguration().getRules() != null) {
            if (request.getLifecycleConfiguration().getRules().size() > 1000) {
                throw new MalformedXMLException(bucketName);
            }
            ArrayList<String> ruleIds = new ArrayList<String>();
            String badId = null;
            for (LifecycleRule rule : request.getLifecycleConfiguration().getRules()) {
                for (String ruleId : ruleIds) {
                    if (rule != null && (rule.getId() == null || rule.getId().equals(ruleId))) {
                        badId = rule.getId() == null ? "null" : rule.getId();
                    } else {
                        ruleIds.add(ruleId);
                    }
                    if (badId == null) continue;
                    break;
                }
                if (badId != null) {
                    InvalidArgumentException ex = new InvalidArgumentException(badId);
                    ex.setMessage("RuleId must be unique. Found same ID for more than one rule.");
                    throw ex;
                }
                goodRules.add(rule);
            }
        }
        if (!ObjectStorageProperties.VersioningStatus.Disabled.equals((Object)bucket.getVersioning())) {
            throw new InvalidBucketStateException(bucketName);
        }
        try {
            BucketLifecycleManagers.getInstance().addLifecycleRules(goodRules, bucket.getBucketUuid());
        }
        catch (Exception ex) {
            LOG.error((Object)("caught exception while managing object lifecycle for bucket - " + bucketName + ", with error - " + ex.getMessage()));
            throw new InternalErrorException(bucketName);
        }
        return response;
    }

    @Override
    public DeleteBucketLifecycleResponseType deleteBucketLifecycle(DeleteBucketLifecycleType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        DeleteBucketLifecycleResponseType response = (DeleteBucketLifecycleResponseType)request.getReply();
        try {
            BucketLifecycleManagers.getInstance().deleteLifecycleRules(bucket.getBucketUuid());
        }
        catch (Exception e) {
            InternalErrorException ex = new InternalErrorException(bucket.getBucketName() + "?lifecycle");
            ex.setMessage("An exception was caught while managing the object lifecycle for bucket - " + bucket.getBucketName());
            throw ex;
        }
        return response;
    }

    @Override
    public SetBucketTaggingResponseType setBucketTagging(SetBucketTaggingType request) throws S3Exception {
        SetBucketTaggingResponseType reply = (SetBucketTaggingResponseType)request.getReply();
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        try {
            TaggingConfiguration taggingConfiguration = request.getTaggingConfiguration();
            List bucketTagList = taggingConfiguration.getBucketTagSet().getBucketTags();
            if (bucketTagList.isEmpty() || bucketTagList.size() > 10) {
                throw new MalformedXMLException(bucket.getBucketName());
            }
            BucketTaggingManagers.getInstance().addBucketTagging(bucketTagList, bucket.getBucketUuid());
        }
        catch (S3Exception ex) {
            LOG.warn((Object)("Failed to put TagSet for bucket '" + bucket.getBucketName() + "' due to: " + ex.getMessage()));
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to put TagSet for bucket '" + bucket.getBucketName() + "' "), (Throwable)ex);
            InternalErrorException e = new InternalErrorException(bucket.getBucketName() + "?tagging", (Throwable)ex);
            e.setMessage("An exception was caught while setting TagSets for bucket - " + bucket.getBucketName());
            throw e;
        }
        reply.setStatus(HttpResponseStatus.NO_CONTENT);
        return reply;
    }

    @Override
    public GetBucketTaggingResponseType getBucketTagging(GetBucketTaggingType request) throws S3Exception {
        GetBucketTaggingResponseType reply = (GetBucketTaggingResponseType)request.getReply();
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        try {
            List<BucketTags> bucketTagsLookup = BucketTaggingManagers.getInstance().getBucketTagging(bucket.getBucketUuid());
            if (bucketTagsLookup == null || bucketTagsLookup.isEmpty()) {
                throw new NoSuchTagSetException(bucket.getBucketName());
            }
            TaggingConfiguration tagging = new TaggingConfiguration();
            ArrayList<BucketTag> bucketTagList = new ArrayList<BucketTag>();
            for (BucketTags bucketTags : bucketTagsLookup) {
                BucketTag bucketTag = new BucketTag();
                bucketTag.setKey(bucketTags.getKey());
                bucketTag.setValue(bucketTags.getValue());
                bucketTagList.add(bucketTag);
            }
            BucketTagSet tagSet = new BucketTagSet();
            tagSet.setBucketTags(bucketTagList);
            tagging.setBucketTagSet(tagSet);
            reply.setTaggingConfiguration(tagging);
        }
        catch (S3Exception ex) {
            LOG.warn((Object)("Failed to get TagSet for bucket '" + bucket.getBucketName() + "' due to: " + ex.getMessage()));
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to get TagSet for bucket '" + bucket.getBucketName() + "' "), (Throwable)ex);
            InternalErrorException e = new InternalErrorException(bucket.getBucketName() + "?tagging", (Throwable)ex);
            e.setMessage("An exception was caught while getting TagSets for bucket - " + bucket.getBucketName());
            throw e;
        }
        return reply;
    }

    @Override
    public DeleteBucketTaggingResponseType deleteBucketTagging(DeleteBucketTaggingType request) throws S3Exception {
        DeleteBucketTaggingResponseType reply = (DeleteBucketTaggingResponseType)request.getReply();
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        try {
            BucketTaggingManagers.getInstance().deleteBucketTagging(bucket.getBucketUuid());
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to delete TagSet for bucket '" + bucket.getBucketName() + "' "), (Throwable)ex);
            InternalErrorException e = new InternalErrorException(bucket.getBucketName() + "?tagging");
            e.setMessage("An exception was caught while deleting TagSets for bucket - " + bucket.getBucketName());
            throw e;
        }
        return reply;
    }

    private Bucket getBucketAndCheckAuthorization(ObjectStorageRequestType request) throws S3Exception {
        ObjectStorageGateway.logRequest(request);
        Bucket bucket = this.ensureBucketExists(request.getBucket());
        if (!OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, null, 0L)) {
            throw new AccessDeniedException(request.getBucket());
        }
        return bucket;
    }

    private ObjectEntity getObjectEntityAndCheckPermissions(ObjectStorageRequestType request, String versionId) throws S3Exception {
        ObjectEntity object;
        ObjectStorageGateway.logRequest(request);
        Bucket bucket = this.ensureBucketExists(request.getBucket());
        String keyFullName = request.getBucket() + "/" + request.getKey() + (versionId == null ? "" : "?versionId=" + versionId);
        try {
            object = ObjectMetadataManagers.getInstance().lookupObject(bucket, request.getKey(), versionId);
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchKeyException(keyFullName);
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting metadata for " + keyFullName));
            throw new InternalErrorException(keyFullName);
        }
        if (!OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)object, 0L)) {
            throw new AccessDeniedException(keyFullName);
        }
        return object;
    }

    private Bucket ensureBucketExists(String bucketName) throws S3Exception {
        Bucket bucket = null;
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(bucketName);
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting metadata for bucket " + bucketName));
            throw new InternalErrorException(bucketName);
        }
        return bucket;
    }

    @Override
    public InitiateMultipartUploadResponseType initiateMultipartUpload(InitiateMultipartUploadType request) throws S3Exception {
        ObjectEntity objectEntity;
        ObjectStorageGateway.logRequest(request);
        Bucket bucket = null;
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        catch (Exception e) {
            throw new InternalErrorException();
        }
        User requestUser = this.getRequestUser((ObjectStorageRequestType)request);
        try {
            objectEntity = ObjectEntity.newInitializedForCreate((Bucket)bucket, (String)request.getKey(), (long)0L, (User)requestUser);
        }
        catch (Exception e) {
            LOG.error((Object)("Error initializing entity for persisting object metadata for " + request.getBucket() + "/" + request.getKey()));
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)objectEntity, 0L)) {
            String originalBucket = request.getBucket();
            String originalKey = request.getKey();
            try {
                AccessControlPolicy acp = this.getFullAcp(request.getAccessControlList(), requestUser, bucket.getOwnerCanonicalId());
                objectEntity.setAcl(acp);
                String fullObjectKey = objectEntity.getObjectUuid();
                request.setKey(fullObjectKey);
                request.setBucket(bucket.getBucketUuid());
                objectEntity = ObjectMetadataManagers.getInstance().initiateCreation(objectEntity);
                InitiateMultipartUploadResponseType response = ospClient.initiateMultipartUpload(request);
                objectEntity.setUploadId(response.getUploadId());
                response.setKey(originalKey);
                response.setBucket(originalBucket);
                ObjectMetadataManagers.getInstance().finalizeMultipartInit(objectEntity, new Date(), response.getUploadId());
                return response;
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
                throw new InternalErrorException(originalBucket + "/" + originalKey, (Throwable)e);
            }
        }
        throw new AccessDeniedException(request.getBucket() + "/" + request.getKey());
    }

    @Override
    public UploadPartResponseType uploadPart(UploadPartType request) throws S3Exception {
        PartEntity partEntity;
        int partNumber;
        Bucket bucket;
        block20: {
            UploadPartResponseType reply = (UploadPartResponseType)request.getReply();
            ObjectStorageGateway.logRequest(request);
            bucket = null;
            try {
                bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchBucketException(request.getBucket());
            }
            catch (Exception e) {
                throw new InternalErrorException();
            }
            if (Strings.isNullOrEmpty((String)request.getContentLength())) {
                throw new MissingContentLengthException(request.getBucket() + "/" + request.getKey());
            }
            partNumber = 0;
            if (!Strings.isNullOrEmpty((String)request.getPartNumber())) {
                try {
                    partNumber = Integer.parseInt(request.getPartNumber());
                    if (partNumber < ObjectStorageProperties.MIN_PART_NUMBER || partNumber > ObjectStorageProperties.MAX_PART_NUMBER) {
                        throw new InvalidArgumentException("PartNumber", "Part number must be an integer between " + ObjectStorageProperties.MIN_PART_NUMBER + " and " + ObjectStorageProperties.MAX_PART_NUMBER + ", inclusive");
                    }
                    break block20;
                }
                catch (NumberFormatException e) {
                    throw new InvalidArgumentException("PartNumber", "Part number must be an integer between " + ObjectStorageProperties.MIN_PART_NUMBER + " and " + ObjectStorageProperties.MAX_PART_NUMBER + ", inclusive");
                }
            }
            throw new InvalidArgumentException("PartNumber", "Part number must be an integer between " + ObjectStorageProperties.MIN_PART_NUMBER + " and " + ObjectStorageProperties.MAX_PART_NUMBER + ", inclusive");
        }
        long objectSize = 0L;
        try {
            objectSize = Long.parseLong(request.getContentLength());
        }
        catch (Exception e) {
            LOG.error((Object)("Could not parse content length into a long: " + request.getContentLength()), (Throwable)e);
            throw new MissingContentLengthException(request.getBucket() + "/" + request.getKey());
        }
        User requestUser = Contexts.lookup().getUser();
        try {
            partEntity = PartEntity.newInitializedForCreate((Bucket)bucket, (String)request.getKey(), (String)request.getUploadId(), (Integer)partNumber, (long)objectSize, (User)requestUser);
        }
        catch (Exception e) {
            LOG.error((Object)("Error initializing entity for persisting part metadata for " + request.getBucket() + "/" + request.getKey() + " uploadId: " + request.getUploadId() + " partNumber: " + partNumber));
            throw new InternalErrorException(request.getBucket() + "/" + request.getKey());
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)partEntity, objectSize)) {
            ObjectEntity objectEntity;
            try {
                if (request.getExpectHeader()) {
                    OSGChannelWriter.writeResponse(Contexts.lookup((String)request.getCorrelationId()), OSGMessageResponse.Continue);
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                objectEntity = ObjectMetadataManagers.getInstance().lookupUpload(bucket, request.getKey(), request.getUploadId());
            }
            catch (Exception e) {
                throw new NoSuchUploadException(request.getUploadId());
            }
            try {
                PartEntity updatedEntity = OsgObjectFactory.getFactory().createObjectPart(ospClient, objectEntity, partEntity, (InputStream)request.getData(), requestUser);
                UploadPartResponseType response = (UploadPartResponseType)request.getReply();
                response.setLastModified(updatedEntity.getObjectModifiedTimestamp());
                response.setEtag(updatedEntity.geteTag());
                response.setStatusMessage("OK");
                response.setSize(updatedEntity.getSize());
                return response;
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
                throw new InternalErrorException(partEntity.getResourceFullName(), (Throwable)e);
            }
        }
        throw new AccessDeniedException(request.getBucket());
    }

    @Override
    public CompleteMultipartUploadResponseType completeMultipartUpload(CompleteMultipartUploadType request) throws S3Exception {
        long newBucketSize;
        ObjectEntity objectEntity;
        Bucket bucket;
        ObjectStorageGateway.logRequest(request);
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        catch (Exception e) {
            throw new InternalErrorException("Error during bucket lookup: " + request.getBucket(), (Throwable)e);
        }
        User requestUser = Contexts.lookup().getUser();
        try {
            objectEntity = ObjectMetadataManagers.getInstance().lookupUpload(bucket, request.getKey(), request.getUploadId());
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchUploadException(request.getUploadId());
        }
        catch (Exception e) {
            throw new InternalErrorException("Error during upload lookup: " + request.getBucket() + "/" + request.getKey() + "?uploadId=" + request.getUploadId(), (Throwable)e);
        }
        long l = newBucketSize = bucket.getBucketSize() == null ? 0L : bucket.getBucketSize();
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)objectEntity, newBucketSize)) {
            if (request.getParts() == null || request.getParts().isEmpty()) {
                throw new InvalidRequestException(request.getBucket() + "/" + request.getKey() + "?uploadId=" + request.getUploadId(), "You must specify at least one part");
            }
            try {
                ObjectEntity completedEntity = OsgObjectFactory.getFactory().completeMultipartUpload(ospClient, objectEntity, request.getParts(), requestUser);
                try {
                    this.fireObjectCreationEvent(bucket.getBucketName(), completedEntity.getObjectKey(), completedEntity.getVersionId(), requestUser.getUserId(), completedEntity.getSize(), null);
                }
                catch (Exception ex) {
                    LOG.debug((Object)"Failed to fire reporting event for OSG object creation while completing multipart upload", (Throwable)ex);
                }
                CompleteMultipartUploadResponseType response = (CompleteMultipartUploadResponseType)request.getReply();
                response.setSize(completedEntity.getSize());
                response.setEtag(completedEntity.geteTag());
                response.setLastModified(completedEntity.getObjectModifiedTimestamp());
                response.setLocation(Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]).getUri() + "/" + completedEntity.getBucket().getBucketName() + "/" + completedEntity.getObjectKey());
                response.setBucket(request.getBucket());
                response.setKey(request.getKey());
                return response;
            }
            catch (S3Exception e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
                throw new InternalErrorException(request.getBucket() + "/" + request.getKey() + "?uploadId=" + request.getUploadId(), (Throwable)e);
            }
        }
        throw new AccessDeniedException(request.getBucket() + "/" + request.getKey());
    }

    @Override
    public AbortMultipartUploadResponseType abortMultipartUpload(AbortMultipartUploadType request) throws S3Exception {
        ObjectEntity objectEntity;
        Bucket bucket;
        ObjectStorageGateway.logRequest(request);
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(request.getBucket());
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        try {
            objectEntity = ObjectMetadataManagers.getInstance().lookupUpload(bucket, request.getKey(), request.getUploadId());
            request.setKey(objectEntity.getObjectUuid());
            request.setBucket(bucket.getBucketUuid());
        }
        catch (NoSuchEntityException | NoSuchElementException e) {
            throw new NoSuchUploadException(request.getUploadId());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)objectEntity, 0L)) {
            ObjectMetadataManagers.getInstance().transitionObjectToState(objectEntity, ObjectState.deleting);
            try {
                AbortMultipartUploadResponseType response = ospClient.abortMultipartUpload(request);
                User requestUser = Contexts.lookup().getUser();
                OsgObjectFactory.getFactory().flushMultipartUpload(ospClient, objectEntity, requestUser);
                return response;
            }
            catch (Exception e) {
                LOG.warn((Object)("CorrelationId: " + Contexts.lookup().getCorrelationId() + " Responding to client with 500 InternalError because of:"), (Throwable)e);
                throw new InternalErrorException("Could not remove parts for: " + request.getUploadId());
            }
        }
        throw new AccessDeniedException(request.getBucket() + "/" + request.getKey());
    }

    public ListPartsResponseType listParts(ListPartsType request) throws S3Exception {
        ObjectEntity objectEntity;
        Bucket bucket;
        ObjectStorageGateway.logRequest(request);
        int maxParts = ObjectStorageProperties.MAX_KEYS;
        if (!Strings.isNullOrEmpty((String)request.getMaxParts())) {
            try {
                maxParts = Integer.parseInt(request.getMaxParts());
                if (maxParts < 0 || maxParts > ObjectStorageProperties.MAX_KEYS) {
                    throw new InvalidArgumentException("max-parts");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("max-parts");
            }
        }
        int partNumberMarker = 0;
        if (!Strings.isNullOrEmpty((String)request.getPartNumberMarker())) {
            try {
                partNumberMarker = Integer.parseInt(request.getPartNumberMarker());
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("part-number-marker");
            }
        }
        ListPartsResponseType reply = (ListPartsResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        try {
            bucket = BucketMetadataManagers.getInstance().lookupExtantBucket(bucketName);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(request.getBucket());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        try {
            objectEntity = ObjectMetadataManagers.getInstance().lookupUpload(bucket, request.getKey(), request.getUploadId());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchUploadException(request.getUploadId());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
        if (OsgAuthorizationHandler.getInstance().operationAllowed(request, (S3AccessControlledEntity)bucket, (S3AccessControlledEntity)objectEntity, 0L)) {
            try {
                PaginatedResult<PartEntity> result = MpuPartMetadataManagers.getInstance().listPartsForUpload(bucket, objectKey, request.getUploadId(), partNumberMarker, maxParts);
                reply.setStorageClass(objectEntity.getStorageClass());
                reply.setPartNumberMarker(partNumberMarker);
                reply.setMaxParts(maxParts);
                reply.setBucket(bucketName);
                reply.setKey(objectKey);
                reply.setUploadId(request.getUploadId());
                reply.setIsTruncated(Boolean.valueOf(result.getIsTruncated()));
                reply.setInitiator(new Initiator(Accounts.getUserArn((User)Accounts.lookupUserById((String)objectEntity.getOwnerIamUserId())), objectEntity.getOwnerIamUserDisplayName()));
                reply.setOwner(new CanonicalUser(objectEntity.getOwnerCanonicalId(), objectEntity.getOwnerDisplayName()));
                if (result.getLastEntry() instanceof PartEntity) {
                    reply.setNextPartNumberMarker(((PartEntity)result.getLastEntry()).getPartNumber().intValue());
                } else {
                    reply.setNextPartNumberMarker(0);
                }
                for (PartEntity entity : result.getEntityList()) {
                    ArrayList replyParts = reply.getParts();
                    replyParts.add(entity.toPartListEntry());
                }
            }
            catch (Exception e) {
                throw new InternalErrorException(e.getMessage());
            }
            return reply;
        }
        throw new AccessDeniedException(request.getBucket() + "/" + request.getKey());
    }

    public ListMultipartUploadsResponseType listMultipartUploads(ListMultipartUploadsType request) throws S3Exception {
        Bucket bucket = this.getBucketAndCheckAuthorization((ObjectStorageRequestType)request);
        int maxUploads = ObjectStorageProperties.MAX_KEYS;
        if (!Strings.isNullOrEmpty((String)request.getMaxUploads())) {
            try {
                maxUploads = Integer.parseInt(request.getMaxUploads());
                if (maxUploads < 0 || maxUploads > ObjectStorageProperties.MAX_KEYS) {
                    throw new InvalidArgumentException("max-uploads");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException("max-uploads");
            }
        }
        ListMultipartUploadsResponseType reply = (ListMultipartUploadsResponseType)request.getReply();
        reply.setMaxUploads(Integer.valueOf(maxUploads));
        reply.setBucket(request.getBucket());
        reply.setDelimiter(request.getDelimiter());
        reply.setKeyMarker(request.getKeyMarker() != null ? request.getKeyMarker() : "");
        reply.setUploadIdMarker(request.getUploadIdMarker() != null ? request.getUploadIdMarker() : "");
        reply.setPrefix(request.getPrefix());
        reply.setIsTruncated(Boolean.valueOf(false));
        reply.setNextKeyMarker("");
        reply.setNextUploadIdMarker("");
        try {
            PaginatedResult<ObjectEntity> result = ObjectMetadataManagers.getInstance().listUploads(bucket, maxUploads, request.getPrefix(), request.getDelimiter(), request.getKeyMarker(), request.getUploadIdMarker());
            if (result != null) {
                reply.setUploads(new ArrayList());
                for (ObjectEntity obj : result.getEntityList()) {
                    reply.getUploads().add(new Upload(obj.getObjectKey(), obj.getUploadId(), new Initiator(Accounts.getUserArn((User)Accounts.lookupUserById((String)obj.getOwnerIamUserId())), obj.getOwnerIamUserDisplayName()), new CanonicalUser(obj.getOwnerCanonicalId(), obj.getOwnerDisplayName()), obj.getStorageClass(), obj.getCreationTimestamp()));
                }
                if (result.getCommonPrefixes() != null && result.getCommonPrefixes().size() > 0) {
                    reply.setCommonPrefixes(new ArrayList());
                    for (String s : result.getCommonPrefixes()) {
                        reply.getCommonPrefixes().add(new CommonPrefixesEntry(s));
                    }
                }
                reply.setIsTruncated(Boolean.valueOf(result.isTruncated));
                if (result.getLastEntry() instanceof ObjectEntity) {
                    reply.setNextKeyMarker(((ObjectEntity)result.getLastEntry()).getObjectKey());
                    reply.setNextUploadIdMarker(((ObjectEntity)result.getLastEntry()).getUploadId());
                } else {
                    reply.setNextKeyMarker("");
                    reply.setNextUploadIdMarker("");
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting object listing for bucket: " + request.getBucket()), (Throwable)e);
            throw new InternalErrorException(request.getBucket());
        }
        return reply;
    }

    private void fireObjectCreationEvent(String bucketName, String objectKey, String version, String userId, Long size, Long oldSize) {
        try {
            if (oldSize != null && oldSize > 0L) {
                this.fireObjectUsageEvent(S3ObjectEvent.S3ObjectAction.OBJECTDELETE, bucketName, objectKey, version, userId, oldSize);
            }
            if (size != null && size > 0L) {
                this.fireObjectUsageEvent(S3ObjectEvent.S3ObjectAction.OBJECTCREATE, bucketName, objectKey, version, userId, size);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    private void fireObjectUsageEvent(S3ObjectEvent.S3ObjectAction actionInfo, String bucketName, String objectKey, String version, String ownerUserId, Long sizeInBytes) {
        try {
            ListenerRegistry.getInstance().fireEvent((Event)S3ObjectEvent.with((S3ObjectEvent.S3ObjectAction)actionInfo, (String)bucketName, (String)objectKey, (String)version, (String)ownerUserId, (Long)sizeInBytes));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }
}

