/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Dispatcher;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.ws.client.ServiceDispatcher;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ObjectStorageBucketLogger {
    private Logger LOG = Logger.getLogger(ObjectStorageBucketLogger.class);
    private static ObjectStorageBucketLogger singleton;
    private static int LOG_THRESHOLD;
    private static int LOG_PERIODICITY;
    private LinkedBlockingQueue<BucketLogData> logData = new LinkedBlockingQueue();
    private ConcurrentHashMap<String, LogFileEntry> logFileMap = new ConcurrentHashMap();
    ScheduledExecutorService logger = Executors.newSingleThreadScheduledExecutor();

    public ObjectStorageBucketLogger() {
        this.logger.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (ObjectStorageBucketLogger.this.logData.size() > LOG_THRESHOLD) {
                    Dispatcher dispatcher = ServiceDispatcher.lookupSingle((Component)Components.lookup(ObjectStorage.class));
                    ArrayList data = new ArrayList();
                    ObjectStorageBucketLogger.this.logData.drainTo(data);
                    data.clear();
                    data = null;
                    ObjectStorageBucketLogger.this.logFileMap.clear();
                }
            }
        }, 1L, LOG_PERIODICITY, TimeUnit.SECONDS);
    }

    public static ObjectStorageBucketLogger getInstance() {
        if (singleton == null) {
            singleton = new ObjectStorageBucketLogger();
        }
        return singleton;
    }

    public void addLogEntry(BucketLogData logEntry) {
        try {
            this.logData.offer(logEntry, 500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public BucketLogData makeLogEntry(String requestId) {
        return new BucketLogData(requestId);
    }

    static {
        LOG_THRESHOLD = 10;
        LOG_PERIODICITY = 120;
    }

    private class LogFileEntry {
        private String logFileName;
        private FileChannel channel;

        public LogFileEntry(String logFileName, FileChannel channel) {
            this.logFileName = logFileName;
            this.channel = channel;
        }

        public FileChannel getChannel() {
            return this.channel;
        }

        public String getLogFileName() {
            return this.logFileName;
        }
    }
}

