/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.BucketState;
import com.eucalyptus.objectstorage.MpuPartMetadataManagers;
import com.eucalyptus.objectstorage.OSGChannelWriter;
import com.eucalyptus.objectstorage.OSGMessageResponse;
import com.eucalyptus.objectstorage.ObjectFactory;
import com.eucalyptus.objectstorage.ObjectMetadataManagers;
import com.eucalyptus.objectstorage.ObjectState;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.objectstorage.entities.ObjectStorageGlobalConfiguration;
import com.eucalyptus.objectstorage.entities.PartEntity;
import com.eucalyptus.objectstorage.exceptions.s3.AccountProblemException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.metadata.ObjectMetadataManager;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CopyObjectResponseType;
import com.eucalyptus.objectstorage.msgs.CopyObjectType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectType;
import com.eucalyptus.objectstorage.msgs.GetObjectResponseType;
import com.eucalyptus.objectstorage.msgs.GetObjectType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.PutObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PutObjectType;
import com.eucalyptus.objectstorage.msgs.UploadPartResponseType;
import com.eucalyptus.objectstorage.msgs.UploadPartType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviderClient;
import com.eucalyptus.objectstorage.util.AclUtils;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.config.ConfigurationCache;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.storage.msgs.s3.Part;
import com.eucalyptus.util.EucalyptusCloudException;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ObjectFactoryImpl
implements ObjectFactory {
    private static final Logger LOG = Logger.getLogger(ObjectFactoryImpl.class);
    private static final int CORE_POOL_SIZE = 10;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_QUEUE_SIZE = 200;
    private static final ExecutorService PUT_OBJECT_SERVICE = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(200));

    public static long getPutTimeoutInMillis() {
        return (long)((ObjectStorageGlobalConfiguration)ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class)).getFailed_put_timeout_hrs().intValue() * 60L * 60L * 1000L;
    }

    public static boolean useGetPutOnCopy() {
        try {
            return ((ObjectStorageGlobalConfiguration)ConfigurationCache.getConfiguration(ObjectStorageGlobalConfiguration.class)).getDoGetPutOnCopyFail();
        }
        catch (Throwable f) {
            LOG.error((Object)"Error getting OSG configuration for get/put on copy fail. Falling back to fail the operation", f);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ObjectEntity copyObject(final @Nonnull ObjectStorageProviderClient provider, @Nonnull ObjectEntity entity, final @Nonnull CopyObjectType request, final @Nonnull User requestUser, final String metadataDirective) throws S3Exception {
        Date lastMod;
        String etag;
        ObjectMetadataManager objectManager = ObjectMetadataManagers.getInstance();
        if (!BucketState.extant.equals((Object)entity.getBucket().getState())) throw new NoSuchBucketException(entity.getBucket().getBucketName());
        try {
            if (!ObjectState.extant.equals((Object)entity.getState())) {
                entity = objectManager.initiateCreation(entity);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error initiating an object in the db:", (Throwable)e);
            throw new InternalErrorException(entity.getResourceFullName());
        }
        try {
            ObjectEntity uploadingObject = entity;
            Callable<CopyObjectResponseType> putCallable = new Callable<CopyObjectResponseType>(){

                @Override
                public CopyObjectResponseType call() throws Exception {
                    CopyObjectResponseType response;
                    LOG.debug((Object)"calling copyObject");
                    try {
                        response = provider.copyObject(request);
                    }
                    catch (Exception ex) {
                        if (ObjectFactoryImpl.useGetPutOnCopy()) {
                            response = ObjectFactoryImpl.this.providerGetPut(provider, request, requestUser, metadataDirective);
                        }
                        LOG.warn((Object)"Exception caught while attempting to copy object on backend");
                        throw ex;
                    }
                    LOG.debug((Object)("Done with copyObject. " + response.getStatusMessage()));
                    return response;
                }
            };
            FutureTask<CopyObjectResponseType> putTask = new FutureTask<CopyObjectResponseType>(putCallable);
            PUT_OBJECT_SERVICE.execute(putTask);
            long failTime = System.currentTimeMillis() + ObjectFactoryImpl.getPutTimeoutInMillis();
            long checkIntervalSec = 15L;
            final AtomicReference<ObjectEntity> entityRef = new AtomicReference<ObjectEntity>(uploadingObject);
            Callable updateTimeout = new Callable(){

                public Object call() throws Exception {
                    ObjectEntity tmp = (ObjectEntity)entityRef.get();
                    try {
                        entityRef.getAndSet(ObjectMetadataManagers.getInstance().updateCreationTimeout(tmp));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Could not update the creation expiration time for ObjectUUID " + tmp.getObjectUuid() + " Will retry next interval"), (Throwable)ex);
                    }
                    return entityRef.get();
                }
            };
            CopyObjectResponseType response = this.waitForCompletion(putTask, uploadingObject.getObjectUuid(), updateTimeout, failTime, 15L);
            etag = response.getEtag();
            lastMod = new Date();
        }
        catch (Exception e) {
            LOG.error((Object)("Data PUT failure to backend for bucketuuid / objectuuid : " + entity.getBucket().getBucketUuid() + "/" + entity.getObjectUuid()), (Throwable)e);
            try {
                ObjectMetadataManagers.getInstance().transitionObjectToState(entity, ObjectState.deleting);
                throw new InternalErrorException(entity.getObjectKey());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to mark failed object entity in deleting state on failure rollback. Will be cleaned later.", (Throwable)e);
            }
            throw new InternalErrorException(entity.getObjectKey());
        }
        try {
            return ObjectMetadataManagers.getInstance().finalizeCreation(entity, lastMod, etag);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to update object metadata for finalization. Failing PUT operation", (Throwable)e);
            throw new InternalErrorException(entity.getResourceFullName());
        }
    }

    private CopyObjectResponseType providerGetPut(ObjectStorageProviderClient provider, CopyObjectType request, User requestUser, String metadataDirective) throws InternalErrorException {
        GetObjectType got = new GetObjectType(request.getSourceBucket(), request.getSourceObject(), Boolean.FALSE, Boolean.FALSE);
        GetObjectResponseType gort = null;
        try {
            gort = provider.getObject(got);
        }
        catch (S3Exception e) {
            LOG.error((Object)"while attempting to copy an object on a backend that does not support copy, an exception was thrown trying to GET the source object", (Throwable)e);
            return null;
        }
        InputStream sourceObjData = gort.getDataInputStream();
        PutObjectType pot = new PutObjectType();
        pot.setBucket(request.getDestinationBucket());
        pot.setKey(request.getDestinationObject());
        pot.setMetaData(gort.getMetaData());
        pot.setUser(requestUser);
        pot.setContentLength(gort.getSize().toString());
        if (metadataDirective != null && "REPLACE".equals(metadataDirective)) {
            pot.setMetaData(request.getMetaData());
        } else if (metadataDirective == null || "".equals(metadataDirective) || "COPY".equals(metadataDirective)) {
            pot.setMetaData(gort.getMetaData());
        } else {
            throw new InternalErrorException("Could not copy " + request.getSourceBucket() + "/" + request.getSourceObject() + " to " + request.getDestinationBucket() + "/" + request.getDestinationObject() + " on the backend because the metadata directive not recognized");
        }
        PutObjectResponseType port = null;
        try {
            port = provider.putObject(pot, sourceObjData);
        }
        catch (S3Exception e) {
            LOG.error((Object)"while attempting to copy an object on a backend that does not support copy, an exception was thrown trying to PUT the destination object in the backend", (Throwable)e);
            return null;
        }
        CopyObjectResponseType response = new CopyObjectResponseType();
        response.setVersionId(port.getVersionId());
        response.setKey(request.getDestinationObject());
        response.setBucket(request.getDestinationBucket());
        response.setStatusMessage(port.getStatusMessage());
        response.setEtag(port.getEtag());
        response.setMetaData(port.getMetaData());
        response.setLastModified(DateFormatter.dateToListingFormattedString((Date)port.getLastModified()));
        return response;
    }

    @Override
    public ObjectEntity createObject(final @Nonnull ObjectStorageProviderClient provider, @Nonnull ObjectEntity entity, final @Nonnull InputStream content, @Nullable List<MetaDataEntry> userMetadata, @Nonnull User requestUser) throws S3Exception {
        String etag;
        Date lastModified;
        ObjectMetadataManager objectManager = ObjectMetadataManagers.getInstance();
        if (BucketState.extant.equals((Object)entity.getBucket().getState())) {
            try {
                entity = objectManager.initiateCreation(entity);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error initiating an object in the db:", (Throwable)e);
                throw new InternalErrorException(entity.getResourceFullName());
            }
        } else {
            throw new NoSuchBucketException(entity.getBucket().getBucketName());
        }
        try {
            ObjectEntity uploadingObject = entity;
            final PutObjectType putRequest = new PutObjectType();
            putRequest.setBucket(uploadingObject.getBucket().getBucketUuid());
            putRequest.setKey(uploadingObject.getObjectUuid());
            putRequest.setUser(requestUser);
            putRequest.setContentLength(entity.getSize().toString());
            putRequest.setMetaData(userMetadata);
            Callable<PutObjectResponseType> putCallable = new Callable<PutObjectResponseType>(){

                @Override
                public PutObjectResponseType call() throws Exception {
                    LOG.debug((Object)"Putting data");
                    PutObjectResponseType response = provider.putObject(putRequest, content);
                    LOG.debug((Object)("Done with put. Response status: " + response.getStatusMessage()));
                    return response;
                }
            };
            FutureTask<PutObjectResponseType> putTask = new FutureTask<PutObjectResponseType>(putCallable);
            PUT_OBJECT_SERVICE.execute(putTask);
            long failTime = System.currentTimeMillis() + ObjectFactoryImpl.getPutTimeoutInMillis();
            long checkIntervalSec = 15L;
            final AtomicReference<ObjectEntity> entityRef = new AtomicReference<ObjectEntity>(uploadingObject);
            Callable updateTimeout = new Callable(){

                public Object call() throws Exception {
                    ObjectEntity tmp = (ObjectEntity)entityRef.get();
                    try {
                        entityRef.getAndSet(ObjectMetadataManagers.getInstance().updateCreationTimeout(tmp));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Could not update the creation expiration time for ObjectUUID " + tmp.getObjectUuid() + " Will retry next interval"), (Throwable)ex);
                    }
                    return entityRef.get();
                }
            };
            PutObjectResponseType response = this.waitForCompletion(putTask, uploadingObject.getObjectUuid(), updateTimeout, failTime, 15L);
            entity = entityRef.get();
            lastModified = new Date();
            etag = response.getEtag();
        }
        catch (Exception e) {
            LOG.error((Object)("Data PUT failure to backend for bucketuuid / objectuuid : " + entity.getBucket().getBucketUuid() + "/" + entity.getObjectUuid()), (Throwable)e);
            try {
                ObjectMetadataManagers.getInstance().transitionObjectToState(entity, ObjectState.deleting);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to mark failed object entity in deleting state on failure rollback. Will be cleaned later.", (Throwable)e);
            }
            throw new InternalErrorException(entity.getObjectKey());
        }
        try {
            return ObjectMetadataManagers.getInstance().finalizeCreation(entity, lastModified, etag);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to update object metadata for finalization. Failing PUT operation", (Throwable)e);
            throw new InternalErrorException(entity.getResourceFullName());
        }
    }

    private <T extends BaseMessage> T waitForCompletion(@Nonnull Future<T> pendingTask, String objectUuid, @Nonnull Callable timeoutUpdate, long failOperationTimeSec, long checkIntervalSec) throws Exception {
        while (System.currentTimeMillis() < failOperationTimeSec * 1000L) {
            try {
                BaseMessage response = (BaseMessage)pendingTask.get(checkIntervalSec, TimeUnit.SECONDS);
                return (T)response;
            }
            catch (TimeoutException e) {
                timeoutUpdate.call();
            }
            catch (CancellationException e) {
                LOG.debug((Object)("PUT operation cancelled for object/part UUID " + objectUuid));
                throw e;
            }
            catch (ExecutionException e) {
                LOG.debug((Object)("PUT operation failed due to exception. object/part UUID " + objectUuid), (Throwable)e);
                throw e;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("PUT operation interrupted. Object/Part UUID " + objectUuid), (Throwable)e);
                throw e;
            }
        }
        throw new Exception("Timed out on upload");
    }

    private <T extends ObjectStorageDataResponseType> T waitForMultipartCompletion(@Nonnull Future<T> pendingTask, @Nonnull String uploadId, @Nonnull String correlationId, long failOperationTimeSec, long checkIntervalSec) throws Exception {
        while (System.currentTimeMillis() < failOperationTimeSec * 1000L) {
            try {
                ObjectStorageDataResponseType response = (ObjectStorageDataResponseType)pendingTask.get(checkIntervalSec, TimeUnit.SECONDS);
                return (T)response;
            }
            catch (TimeoutException e) {
                OSGChannelWriter.writeResponse(Contexts.lookup((String)correlationId), OSGMessageResponse.Whitespace);
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                LOG.debug((Object)("Complete upload operation failed for upload ID: " + uploadId), (Throwable)e);
                throw e;
            }
        }
        throw new Exception("Timed out on upload");
    }

    @Override
    public ObjectEntity logicallyDeleteVersion(@Nonnull ObjectStorageProviderClient provider, @Nonnull ObjectEntity entity, @Nonnull User requestUser) throws S3Exception {
        ObjectEntity toBeReturned;
        block9: {
            toBeReturned = null;
            if (entity.getBucket() == null) {
                throw new InternalErrorException();
            }
            try {
                List<ObjectEntity> entities = ObjectMetadataManagers.getInstance().lookupObjectVersions(entity.getBucket(), entity.getObjectKey(), Integer.MAX_VALUE);
                if (entities == null || entities.size() <= 0) break block9;
                for (ObjectEntity latest : entities) {
                    if (latest.getObjectUuid().equals(entity.getObjectUuid())) continue;
                    if (!latest.getIsLatest().booleanValue()) {
                        ObjectMetadataManagers.getInstance().makeLatest(latest);
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"while attempting to set isLatest = true on the newest remaining object version, an exception was encountered: ", (Throwable)ex);
            }
        }
        if (!entity.getIsDeleteMarker().booleanValue()) {
            toBeReturned = ObjectMetadataManagers.getInstance().transitionObjectToState(entity, ObjectState.deleting);
            try {
                this.actuallyDeleteObject(provider, toBeReturned, requestUser);
            }
            catch (Exception e) {
                LOG.trace((Object)"Could not delete the object in the sync path, will retry later asynchronosly. Object now in state 'deleting'.", (Throwable)e);
            }
        } else {
            toBeReturned = entity;
            ObjectMetadataManagers.getInstance().delete(entity);
        }
        return toBeReturned;
    }

    @Override
    public ObjectEntity logicallyDeleteObject(@Nonnull ObjectStorageProviderClient provider, @Nonnull ObjectEntity entity, @Nonnull User requestUser) throws S3Exception {
        ObjectEntity toBeReturned = null;
        if (entity.getBucket() == null) {
            throw new InternalErrorException();
        }
        switch (entity.getBucket().getVersioning()) {
            case Suspended: 
            case Enabled: {
                try {
                    AccessControlPolicy acp = AclUtils.processNewResourcePolicy((User)requestUser, null, (String)entity.getBucket().getOwnerCanonicalId());
                    toBeReturned = ObjectMetadataManagers.getInstance().generateAndPersistDeleteMarker(entity, acp, requestUser);
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failure configuring and persisting the delete marker for object " + entity.getResourceFullName()));
                    throw new InternalErrorException((Throwable)e);
                }
            }
            case Disabled: {
                this.logicallyDeleteVersion(provider, entity, requestUser);
                break;
            }
            default: {
                LOG.error((Object)("Cannot logically delete object due to unexpected bucket state found: " + entity.getBucket().getVersioning()));
                throw new InternalErrorException(entity.getBucket().getName());
            }
        }
        return toBeReturned;
    }

    @Override
    public void actuallyDeleteObject(@Nonnull ObjectStorageProviderClient provider, @Nonnull ObjectEntity entity, @Nullable User requestUser) throws S3Exception {
        if (!ObjectState.deleting.equals((Object)entity.getState())) {
            try {
                entity = ObjectMetadataManagers.getInstance().transitionObjectToState(entity, ObjectState.deleting);
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not mark metadata for deletion", (Throwable)e);
                throw e;
            }
        }
        if (entity.getIsDeleteMarker().booleanValue()) {
            ObjectMetadataManagers.getInstance().delete(entity);
            return;
        }
        LOG.trace((Object)("Deleting object " + entity.getObjectUuid() + "."));
        DeleteObjectType deleteRequest = new DeleteObjectType();
        if (requestUser == null) {
            try {
                requestUser = Accounts.lookupSystemAdmin();
            }
            catch (AuthException e) {
                LOG.trace((Object)("System admin account not found for object deletion. Cannot remove object with uuid " + entity.getObjectUuid()));
                throw new AccountProblemException("Eucalyptus/Admin");
            }
        }
        try {
            block13: {
                deleteRequest.setUser(requestUser);
                deleteRequest.setBucket(entity.getBucket().getBucketUuid());
                deleteRequest.setKey(entity.getObjectUuid());
                try {
                    DeleteObjectResponseType deleteResponse = provider.deleteObject(deleteRequest);
                    if (!HttpResponseStatus.NO_CONTENT.equals((Object)deleteResponse.getStatus()) && !HttpResponseStatus.OK.equals((Object)deleteResponse.getStatus())) {
                        LOG.trace((Object)("Backend did not confirm deletion of " + deleteRequest.getBucket() + "/" + deleteRequest.getKey() + " via request: " + deleteRequest.toString()));
                        throw new Exception("Object could not be confirmed as deleted.");
                    }
                }
                catch (S3Exception e) {
                    if (HttpResponseStatus.NOT_FOUND.equals((Object)e.getStatus())) break block13;
                    throw e;
                }
            }
            Transactions.delete((Object)entity);
        }
        catch (EucalyptusCloudException ex) {
            LOG.trace((Object)("Error in response from backend on deletion request for object on backend: " + deleteRequest.getBucket() + "/" + deleteRequest.getKey()));
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting object on backend. Will retry later", (Throwable)e);
        }
    }

    @Override
    public ObjectEntity createMultipartUpload(ObjectStorageProviderClient provider, ObjectEntity upload, User requestUser) throws S3Exception {
        ObjectMetadataManager objectManager = ObjectMetadataManagers.getInstance();
        if (BucketState.extant.equals((Object)upload.getBucket().getState())) {
            try {
                upload = objectManager.initiateCreation(upload);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error initiating an object in the db:", (Throwable)e);
                throw new InternalErrorException(upload.getResourceFullName());
            }
        } else {
            throw new NoSuchBucketException(upload.getBucket().getBucketName());
        }
        try {
            InitiateMultipartUploadType initRequest = new InitiateMultipartUploadType();
            initRequest.setBucket(upload.getBucket().getBucketUuid());
            initRequest.setKey(upload.getObjectUuid());
            initRequest.setUser(requestUser);
            initRequest.setStorageClass(upload.getStorageClass());
            initRequest.setAccessControlList(upload.getAccessControlPolicy().getAccessControlList());
            LOG.trace((Object)"Initiating MPU on backend");
            InitiateMultipartUploadResponseType response = provider.initiateMultipartUpload(initRequest);
            upload.setObjectModifiedTimestamp(response.getLastModified());
            upload.setUploadId(response.getUploadId());
            LOG.trace((Object)("Done with MPU init on backend. " + response.getStatusMessage()));
        }
        catch (Exception e) {
            LOG.error((Object)("InitiateMPU failure to backend for bucketuuid / objectuuid : " + upload.getBucket().getBucketUuid() + "/" + upload.getObjectUuid()), (Throwable)e);
            try {
                ObjectMetadataManagers.getInstance().transitionObjectToState(upload, ObjectState.deleting);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to mark failed object entity in deleting state on failure rollback. Will be cleaned later.", (Throwable)e);
            }
            throw new InternalErrorException(upload.getObjectKey());
        }
        try {
            return ObjectMetadataManagers.getInstance().finalizeMultipartInit(upload, upload.getObjectModifiedTimestamp(), upload.getUploadId());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to update object metadata for finalization. Failing InitiateMPU operation", (Throwable)e);
            throw new InternalErrorException(upload.getResourceFullName());
        }
    }

    @Override
    public PartEntity createObjectPart(final ObjectStorageProviderClient provider, ObjectEntity mpuEntity, PartEntity entity, final InputStream content, User requestUser) throws S3Exception {
        String etag;
        Date lastModified;
        if (BucketState.extant.equals((Object)entity.getBucket().getState())) {
            try {
                entity = MpuPartMetadataManagers.getInstance().initiatePartCreation(entity);
            }
            catch (Exception e) {
                LOG.error((Object)("Error initializing metadata for object creation: " + entity.getResourceFullName()));
                InternalErrorException ex = new InternalErrorException(entity.getResourceFullName());
                ex.initCause((Throwable)e);
                throw ex;
            }
        } else {
            throw new NoSuchBucketException(entity.getBucket().getBucketName());
        }
        try {
            PartEntity uploadingObject = entity;
            final UploadPartType putRequest = new UploadPartType();
            putRequest.setBucket(uploadingObject.getBucket().getBucketUuid());
            putRequest.setKey(mpuEntity.getObjectUuid());
            putRequest.setUser(requestUser);
            putRequest.setContentLength(entity.getSize().toString());
            putRequest.setPartNumber(String.valueOf(entity.getPartNumber()));
            putRequest.setUploadId(entity.getUploadId());
            Callable<UploadPartResponseType> putCallable = new Callable<UploadPartResponseType>(){

                @Override
                public UploadPartResponseType call() throws Exception {
                    LOG.trace((Object)"Putting data");
                    UploadPartResponseType response = provider.uploadPart(putRequest, content);
                    LOG.trace((Object)("Done with put. " + response.getStatusMessage()));
                    return response;
                }
            };
            FutureTask<UploadPartResponseType> putTask = new FutureTask<UploadPartResponseType>(putCallable);
            PUT_OBJECT_SERVICE.execute(putTask);
            long failTime = System.currentTimeMillis() + ObjectFactoryImpl.getPutTimeoutInMillis();
            long checkIntervalSec = 15L;
            final AtomicReference<PartEntity> entityRef = new AtomicReference<PartEntity>(uploadingObject);
            Callable updateTimeout = new Callable(){

                public Object call() throws Exception {
                    PartEntity tmp = (PartEntity)entityRef.get();
                    try {
                        entityRef.getAndSet(MpuPartMetadataManagers.getInstance().updateCreationTimeout(tmp));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Could not update the creation expiration time for PartUUID " + tmp.getPartUuid() + " Will retry next interval"), (Throwable)ex);
                    }
                    return entityRef.get();
                }
            };
            UploadPartResponseType response = this.waitForCompletion(putTask, uploadingObject.getPartUuid(), updateTimeout, failTime, 15L);
            entity = entityRef.get();
            lastModified = new Date();
            etag = response.getEtag();
        }
        catch (Exception e) {
            LOG.error((Object)("Data PUT failure to backend for bucketuuid / objectuuid : " + entity.getBucket().getBucketUuid() + "/" + entity.getPartUuid()), (Throwable)e);
            try {
                MpuPartMetadataManagers.getInstance().transitionPartToState(entity, ObjectState.deleting);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to mark failed object entity in deleting state on failure rollback. Will be cleaned later.", (Throwable)e);
            }
            throw new InternalErrorException(entity.getObjectKey());
        }
        try {
            return MpuPartMetadataManagers.getInstance().finalizeCreation(entity, lastModified, etag);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to update object metadata for finalization. Failing PUT operation", (Throwable)e);
            throw new InternalErrorException(entity.getResourceFullName());
        }
    }

    @Override
    public ObjectEntity completeMultipartUpload(final ObjectStorageProviderClient provider, ObjectEntity mpuEntity, ArrayList<Part> partList, User requestUser) throws S3Exception {
        try {
            final CompleteMultipartUploadType commitRequest = new CompleteMultipartUploadType();
            commitRequest.setParts(partList);
            commitRequest.setBucket(mpuEntity.getBucket().getBucketUuid());
            commitRequest.setKey(mpuEntity.getObjectUuid());
            commitRequest.setUploadId(mpuEntity.getUploadId());
            long fullSize = MpuPartMetadataManagers.getInstance().processPartListAndGetSize(partList, MpuPartMetadataManagers.getInstance().getParts(mpuEntity.getBucket(), mpuEntity.getObjectKey(), mpuEntity.getUploadId()));
            mpuEntity.setSize(Long.valueOf(fullSize));
            Callable<CompleteMultipartUploadResponseType> completeCallable = new Callable<CompleteMultipartUploadResponseType>(){

                @Override
                public CompleteMultipartUploadResponseType call() throws Exception {
                    CompleteMultipartUploadResponseType response = provider.completeMultipartUpload(commitRequest);
                    LOG.debug((Object)("Done with multipart upload. " + response.getStatusMessage()));
                    return response;
                }
            };
            FutureTask<CompleteMultipartUploadResponseType> completeTask = new FutureTask<CompleteMultipartUploadResponseType>(completeCallable);
            PUT_OBJECT_SERVICE.execute(completeTask);
            long failTime = System.currentTimeMillis() + ObjectFactoryImpl.getPutTimeoutInMillis();
            long checkIntervalSec = 60L;
            CompleteMultipartUploadResponseType response = this.waitForMultipartCompletion(completeTask, commitRequest.getUploadId(), commitRequest.getCorrelationId(), failTime, 60L);
            mpuEntity.seteTag(response.getEtag());
            ObjectEntity completedEntity = ObjectMetadataManagers.getInstance().finalizeCreation(mpuEntity, new Date(), mpuEntity.geteTag());
            return completedEntity;
        }
        catch (S3Exception e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed commit of multipart upload " + mpuEntity.getUploadId()), (Throwable)e);
            InternalErrorException ex = new InternalErrorException(mpuEntity.getUploadId());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    @Override
    public void flushMultipartUpload(ObjectStorageProviderClient provider, ObjectEntity entity, User requestUser) throws S3Exception {
        try {
            MpuPartMetadataManagers.getInstance().removeParts(entity.getBucket(), entity.getUploadId());
        }
        catch (Exception e) {
            LOG.warn((Object)"Error removing non-committed parts", (Throwable)e);
            InternalErrorException ex = new InternalErrorException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }
}

