/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage;

import com.eucalyptus.context.Context;
import com.eucalyptus.objectstorage.OSGMessageResponse;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class OSGChannelWriter {
    private static Logger LOG = Logger.getLogger(OSGChannelWriter.class);

    public static void writeResponse(final Context ctx, OSGMessageResponse response) throws InternalErrorException {
        String responseMessage;
        Channel channel = ctx.getChannel();
        if (channel == null || !channel.isConnected()) {
            throw new InternalErrorException("Response: " + response + " requested, but no channel to write to.");
        }
        final HttpResponseStatus status = response.getHttpResponseStatus();
        if (status != null) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            channel.write((Object)httpResponse).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    LOG.debug((Object)("Wrote response status: " + status + " for request: " + ctx.getCorrelationId()));
                }
            });
        }
        if ((responseMessage = response.getHttpResponseBody()) != null) {
            channel.write((Object)responseMessage).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    LOG.debug((Object)("Wrote response body: " + responseMessage + " for request: " + ctx.getCorrelationId()));
                }
            });
        }
    }
}

